// This may look like C code, but it is really -*- C++ -*-
#ifndef REPRESENTATION_H
#define REPRESENTATION_H
#ifdef __GNUG__
#pragma interface
#endif

#include "hash_define.h"
#include "header.h"
#include "point.h"

class Representation{
public:
  Representation (Int= 1, Int= 1);
  ~Representation() { delete representation; }
  class cellList* 
    neighborList(Int c, int &perimeter); // Returns a list of neighboring
					 // cells of the cell c 
  int findNeighborInDirection( Int fromCell, FPoint direction) {
    return getCell( findBoundary( fromCell, direction));
  }
  void swapCellDirection( Int c1, FPoint direction) {
    // swap the locations of the cell c1 with the cell in the specified
    // absolute direction (not relative to the cell location)
    swapCells( c1, getCell( findBoundary( c1, direction)), direction); 
  }
  void attach( Int c1, FPoint direction) {
    // attach the cell c1 to the one in the direction direction
	// EEEE write this routine
  }
  Point getLocation( Int c) { return findLocation( c);}
  void dumpImage(ostream& s = cout) const;
  void outlineImage(ostream& s = cout) const;
  void tissueImage(ostream& s = cout) const;
  void cellNumberImage(ostream& s = cout) const;
  void stateImage(ostream& s = cout) const;
  void move( Int c, int stepsToMove, FPoint direction);
     // move the cell c stepsToMove in the direction. direction has to be of
     // unit length one of the 6 possible //Rewrite this TODO
  static void setTime( float thisTime) {time = thisTime;}
  void saveState( ostream& s);
  void recoverState( istream& s);
  Point randomDirection() const;
  void putCell( Point p, Int Value) // makes the point belong to the specified
				   // cell 
  { *(representation + p.arrayindex(width) ) = Value; }
  void markCell( Point p, Int Value) // do a putCell and setLocation
    { 
      *(representation + p.arrayindex(width) ) = Value; 
      location[ Value] = p; 
    } 
  Int getCell( Int x, Int y) const // gets the cell present at the given point
    { return *( representation + y * width + x ) ; }  
  /* Stored in y major, lower left corner is 0,0 1st quadrant*/
  void setLocationToCentreofCell( Int c);

#ifdef UNIT_CELLS
  int getArea(Int c) const {return 1;} // Computes and returns area of cell c
#else UNIT_CELLS not
  int getArea(Int c); // Computes and returns area of cell c
  Point divideCell(Int c, divideOptions dO, int childNumber,
		  Point previousDivision);
    // Divide the cell c into two with divideOption dO 
  void growCell(Int c, int areaInc, FPoint direction); 
    // Grow the cell c by areaInc in direction
  void configure( Int c); // Reconfigure the shape of cell c
  void shrinkCell(Int c, int areaDec, FPoint direction);
    // shrink the cell c by areaDec
  void connect( Int c); // connect all points of cell c
#endif UNIT_CELLS not

private:
  enum {Environment = 0};
  Int height,width;
  int size; // Size of the representation = height * width
  Int *representation;
  bool *tag; //  To tag visited points while doing searches etc
  Point location[ MAX_NUMBER_CELLS ]; // Keeps track of the location of each
				    // cell, location should be relatively
				    // close to the centroid
  Int getHeight() const { return(height); }
  Int getWidth()  const { return(width); }
  void initializeTags();
  Point findLocation(Int c);  // Find a point belonging to the cell c 
  Int getCell( Point p) const // gets the cell present at the given point
    { return(*(representation + p.arrayindex(width) )); }
  void putCell(Int x, Int y, Int Value) 
    // makes the point belong to the specified cell 
  { *(representation + y*width + x) = Value; }
  void swapCells( Int c1, Int c2, FPoint direction);
     // swap the locations of the adjoining cells c1 and c2
  Point findBoundary( Int c, FPoint direction);
      // direction is an absolute direction; NOT realtive to the cell location
  void diskPoints( int x, int y, int Value, int cx, int cy);
    // Draw 8 lines for the circle, used only by makeCircleCell
  void line( int x1, int y1, int x2, int y2, int Value) 
    // Draw a line between the two specified points, either x or y is
    // guaranteed to be the same for both points, used only by diskPoints
    {
      if (x1 > x2) swap (x1, x2);
      if (y1 > y2) swap (y1, y2);
      for (int y=y1; y<=y2; y++)
	for (int x=x1; x<=x2; x++)
	  putCell( x,y,Value);
    }
  void swap( int& a, int& b) { int temp = a; a = b; b = temp;}
  void printNumber(int x, int width = 2, ostream& s = cout) const;
  void tagPointAndNeighbors( Point p);
  static float time;
#ifndef UNIT_CELLS
  int pointEnergy( Point p, Int c) const;
  bool central( Point p, Int c) const;
  void findExtremePoints( Int c, Point direction, Point& low, Point& high);
    // used by divide cell
  void incrementCellArea(Int c, Point direction);
  void decrementCellArea(Int c, Point direction);
  void transferAreaBetweenCells( Int c1, Int c2, int area);
     // move area from cell c1 to cell c2
  bool canStealPoint( Point p) const; 
  // if the Point p can be stolen from its present cell without breaking it up 
  bool bridge( Point p) const; // check if point p is a bridge
#else
  void decrementCellArea(Int c, Point direction) {} 
  bool canStealPoint( Point p) const {return FALSE;}
#endif
};
#endif
