// Simple vectors of complex numbers.

#ifndef _CL_SV_COMPLEX_H
#define _CL_SV_COMPLEX_H

#include "cl_number.h"
#include "cl_SV.h"
#include "cl_io.h"

typedef cl_heap_SV<cl_N> cl_heap_SV_N;

struct cl_SV_N : public cl_SV<cl_N,cl_SV_any> {
public:
	// Constructors.
	cl_SV_N ();
	cl_SV_N (const cl_SV_N&);
	cl_SV_N (uintL len);
	// Assignment operators.
	cl_SV_N& operator= (const cl_SV_N&);
	// Private pointer manipulations.
	operator cl_heap_SV_N* () const;
	cl_SV_N (cl_heap_SV_N* p) : cl_SV<cl_N,cl_SV_any> (p) {}
	cl_SV_N (cl_private_thing p) : cl_SV<cl_N,cl_SV_any> (p) {}
};
inline cl_SV_N::cl_SV_N (const cl_SV_N& x) : cl_SV<cl_N,cl_SV_any> (as_cl_private_thing(x)) {}
CL_DEFINE_ASSIGNMENT_OPERATOR(cl_SV_N,cl_SV_N)
// Returns a new simple vector with uninitialized contents.
extern cl_heap_SV_N* cl_make_heap_SV_N_uninit (uintL len);
// Returns a new simple vector with all elements initialized to 0.
extern cl_heap_SV_N* cl_make_heap_SV_N (uintL len);
inline cl_SV_N::cl_SV_N (uintL len)
	: cl_SV<cl_N,cl_SV_any> (cl_make_heap_SV_N(len)) {}

// Private pointer manipulations. Never throw away a `struct cl_heap_SV_N *'!
inline cl_SV_N::operator cl_heap_SV_N* () const
{
	cl_heap_SV_N* hpointer = (cl_heap_SV_N*)pointer;
	cl_inc_refcount(*this);
	return hpointer;
}
extern cl_SV_N cl_null_SV_N;
inline cl_SV_N::cl_SV_N ()
	: cl_SV<cl_N,cl_SV_any> ((cl_heap_SV_N*) cl_null_SV_N) {}
CL_REQUIRE(cl_SV_N)

// Copy a simple vector.
inline cl_SV_N copy (const cl_SV_N& vector)
{ return The(cl_SV_N) (copy((const cl_SV_any&) vector)); }

// Output.
inline void fprint (cl_ostream stream, const cl_SV_N& x)
{
	extern cl_print_flags cl_default_print_flags;
	extern void print_vector (cl_ostream stream, const cl_print_flags& flags, void (* fun) (cl_ostream, const cl_print_flags&, const cl_number&), const cl_SV_N& vector);
	extern void print_number (cl_ostream stream, const cl_print_flags& flags, const cl_number& z);
	print_vector(stream, cl_default_print_flags,
	             (void (*) (cl_ostream, const cl_print_flags&, const cl_number&))
	             &print_number,
	             x);
}
CL_DEFINE_PRINT_OPERATOR(cl_SV_N)

// Debugging support.
#ifdef CL_DEBUG
extern int cl_SV_N_debug_module;
static void* cl_SV_N_debug_dummy[] = { &cl_SV_N_debug_dummy,
	&cl_SV_N_debug_module
};
#endif

#endif /* _CL_SV_COMPLEX_H */
