// Input functions.

#ifndef _CL_READ_H
#define _CL_READ_H

#include "cl_number.h"
#include "cl_input.h"

// Wandelt eine Zeichenkette mit Integer-Syntax in ein Integer um.
// Punkte werden berlesen.
// read_integer(base,sign,string,index1,index2)
// > base: Lesebasis (>=2, <=36)
// > sign: Vorzeichen (/=0 falls negativ)
// > string: Simple-String (enthlt Ziffern mit Wert <base und evtl. Punkt)
// > index1: Index der ersten Ziffer
// > index2: Index nach der letzten Ziffer
//   (also index2-index1 Ziffern, incl. evtl. Dezimalpunkt am Schlu)
// < ergebnis: Integer
extern cl_I read_integer (unsigned int base,
            cl_signean sign, const char * string, uintL index1, uintL index2);

// Wandelt eine Zeichenkette mit Rational-Syntax in eine rationale Zahl um.
// read_rational(base,sign,string,index1,index3,index2)
// > base: Lesebasis (>=2, <=36)
// > sign: Vorzeichen (/=0 falls negativ)
// > string: Simple-String (enthlt Ziffern mit Wert <base und Bruchstrich)
// > index1: Index der ersten Ziffer
// > index3: Index von '/'
// > index2: Index nach der letzten Ziffer
//   (also index3-index1 Zhler-Ziffern, index2-index3-1 Nenner-Ziffern)
// < ergebnis: rationale Zahl
extern cl_RA read_rational (unsigned int base,
             cl_signean sign, const char * string, uintL index1, uintL index3, uintL index2);

// Wandelt eine Zeichenkette mit Float-Syntax in ein Float um.
// read_float(base,sign,string,index1,index4,index2,index3)
// > base: Lesebasis (=10)
// > sign: Vorzeichen (/=0 falls negativ)
// > string: Simple-String (enthlt Ziffern und evtl. Punkt und Exponentmarker)
// > index1: Index vom Mantissenanfang (excl. Vorzeichen)
// > index4: Index nach dem Mantissenende
// > index2: Index beim Ende der Characters
// > index3: Index nach dem Dezimalpunkt (=index4 falls keiner da)
//   (also Mantisse mit index4-index1 Characters: Ziffern und max. 1 '.')
//   (also index4-index3 Nachkommaziffern)
//   (also bei index4<index2: index4 = Index des Exponent-Markers,
//    index4+1 = Index des Exponenten-Vorzeichens oder der ersten
//    Exponenten-Ziffer)
// < ergebnis: Float
extern cl_F read_float (unsigned int base, cl_float_format_t prec,
            cl_signean sign, const char * string, uintL index1, uintL index4, uintL index2, uintL index3);

#endif /* _CL_READ_H */
