/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include "math.h"

#include "kask.h"
#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"

extern void Direct(), MeanValue(), ExtraPol(), Iterate(), Refine();


#define NO_OF_F_VALS  4
#define NO_OF_CAU_VALS 2
#define NO_OF_DIR_VALS 1
#define NO_OF_SOL_VALS 3

static REAL	fVals[NO_OF_F_VALS],cauVals[NO_OF_CAU_VALS],
		dirVals[NO_OF_DIR_VALS], solVals[NO_OF_SOL_VALS]; 	

static REAL	*peak=nil;
static char	*peakNames[] = {"peakX","peakY","peakSize"};

 


/*	
	    functions for user problem 1	
        ( equal to example toms1a in tomproblem.c )
*/		

static int UserF_1(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	REAL a_para, b_para;
   	REAL xm1,xm1x,ym1,ym1y,xma,ymb;
  	REAL sum,divisor;

	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/

  	a_para = peak[0];
   	b_para = peak[1];
    xm1  = x-1.0;
    xm1x = x*xm1;
   	ym1  = y-1.0;
   	ym1y = y*ym1;
   	xma  = x-a_para;
   	ymb  = y-b_para;

   	divisor = exp(peak[2]*(xma*xma + ymb*ymb));
  	sum = 2.0*(xm1x+ym1y);
   	sum = sum - 4.0*peak[2]*(xm1x*ym1y + xm1*xma*ym1y + x*xma*ym1y);
   	sum = sum + 4.0*peak[2]*peak[2]*(xm1x*xma*xma*ym1y + xm1x*ym1y*ymb*ymb);
   	sum = sum - 4.0*peak[2]*(xm1x*ym1*ymb + xm1*x*y*ymb);
	fVals[3] = -sum/divisor;	/*	g	*/

    return true;
  }
 
  
static int UserCauchyF_1(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int UserDirichF_1(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] = 0.0;
    return true;
  }

static int UserSol_1(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  {
	REAL a_para, b_para;
	REAL xma, ymb, efac;

	a_para = peak[0];
	b_para = peak[1];
	xma  = x-a_para;
	ymb  = y-b_para;

    efac = exp(-peak[2]*(xma*xma + ymb*ymb));
	solVals[0] =  x*(x-1.0)*y*(y-1.0)*exp(-peak[2]*(xma*xma + ymb*ymb));  
	solVals[1] = ( (x-1.0)*(y-1.0)*y + x*y*(y-1.0) -
					2.0*peak[2]*(x-1.0)*x*xma*y*(y-1.0) ) * efac;  
	solVals[2] =  ( (x-1.0)*(y-1.0)*x + x*y*(x-1.0) -
					2.0*peak[2]*(x-1.0)*x*ymb*y*(y-1.0) ) * efac;
    return true;  
  }


/*	
    	functions for user problem 2	
        equal to example 2 in tomproblem.c		
*/
static int UserF_2(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {

	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  100.0;		/*	q	*/
	fVals[3] =  0.0;		/*	g	*/

    return true;
  }
 
  
static int UserCauchyF_2(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
    return true;   
  }


static int UserDirichF_2(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] =  ( cosh(10.0*x) + cosh(10.0*y) ) / ( 2.0*cosh(10.0) );
    return true;
  }

static REAL UserSol_2(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	solVals[0] =  ( cosh(10.0*x) + cosh(10.0*y) ) / ( 2.0*cosh(10.0) );    solVals[1] = ( 5.0*sinh(10.0*x) ) / ( cosh(10.0) );    
	solVals[2] = ( 5.0*sinh(10.0*y) ) / ( cosh(10.0) );   
    return true;    
  }

/*		functions for user problem 3			*/

static int UserF_3(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {

	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/
	fVals[3] =  0.0;		/*	g	*/

    return true;
  }
 
  
static int UserCauchyF_3(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int UserDirichF_3(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] =  x;
    return true;
  }

static REAL UserSol_3(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	solVals[0] =  x;		/*		U(x,y)		*/
	solVals[1] =  1.0; 		/*		Ux(x,y)		*/   
	solVals[2] =  0.0; 		/*		Uy(x,y)		*/    
    return true;    
  }

/*		functions for user problem 4			*/

static int UserF_4(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {

	fVals[0] =   1.0;		/*	pX	*/
	fVals[1] =   1.0;		/*	pY	*/
	fVals[2] =   0.0;		/*	q	*/
	fVals[3] =  -2.0;		/*	g	*/

    return true;
  }
 
  
static int UserCauchyF_4(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
    return true;   
  }


static int UserDirichF_4(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] =  x*x;
    return true;
  }

static REAL UserSol_4(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	solVals[0] =  x*x;			/*		U(x,y)		*/
	solVals[1] =  2.0*x; 		/*		Ux(x,y)		*/   
	solVals[2] =  0.0; 			/*		Uy(x,y)		*/    
    return true;    
  }

/*		functions for user problem 5			*/

static int UserF_5(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {

	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/
	fVals[3] =  -4.0;		/*	g	*/

    return true;
  }
 
  
static int UserCauchyF_5(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int UserDirichF_5(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] =  ZERO;
    return true;
  }

static REAL UserSol_5(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	solVals[0] =  x*x + y*y -1.0;			/*		U(x,y)		*/
	solVals[1] =  2.0*x; 			        /*		Ux(x,y)		*/   
	solVals[2] =  2.0*y; 		        	/*		Uy(x,y)		*/    
    return true;    
  }


/********************************************************/
/*	Problem-Command: Select a special example	*/
/********************************************************/

int Problem(cmd)
  COMMAND *cmd;
  {
    int index = 0;
	char *tp;

	if (ParsCheck(cmd,0,1)) return false;

	if ((cmd->noOfPars)==1)
	  {
	    tp = (cmd->pars)[1];
		index = CheckName(&tp, cmd->names, nameClass);
	  }
	if (index==-1)
	  {
	    sprintf(globBuf, "Parameter %s of %s not allowed\n",
				(cmd->pars)[1], (cmd->pars)[0]);
	    ZIBStdOut(globBuf);
		return false;
	  }

/*		 Presets for Solve		*/
	
	if (!CheckPreSets()) return false;
	actSolve->Direct = Direct;
	actSolve->Estimate = MeanValue;
	actSolve->Refine = Refine;
	actSolve->Iterate = Iterate;
	
/*	select a special problem		*/
	switch (index)
	  {
		case 0:				/*	user problem 1	*/
		  if (peak == nil)
		    {
			peak = (REAL*) NewParamList("userpeak",3,sizeof(REAL),1,peakNames,nil,nil);
			peak[0] = 0.5;
			peak[1] = 0.117;
			peak[2] = 100.0;
		    }
		  actProblem->F			= (PROC)UserF_1;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)UserCauchyF_1;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)UserDirichF_1;	
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;
		  actProblem->Sol		= (PROC)UserSol_1;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP 		= SYMMETRIC;
		  break;

		case 1:				/*	user problem 2	*/
	  	  actProblem->F			= (PROC)UserF_2;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)UserCauchyF_2;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)UserDirichF_2;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)UserSol_2;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 2:				/*	user problem 3	*/
	  	  actProblem->F			= (PROC)UserF_3;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)UserCauchyF_3;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)UserDirichF_3;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)UserSol_3;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 3:				/*	user problem 4	*/
	  	  actProblem->F			= (PROC)UserF_4;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)UserCauchyF_4;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)UserDirichF_4;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)UserSol_4;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 4:				/*	user problem 5	*/
	  	  actProblem->F			= (PROC)UserF_5;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)UserCauchyF_5;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)UserDirichF_5;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)UserSol_5;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

	  }
	
	SetBound(R_SOL);
	InitNumAss(N_STD);

	if ((cmd->noOfPars)==1) actProblem->name = (cmd->names)[index];
	return true;
  }
