SizeScreen( [ 70, 24 ] );
#>[ 70, 24 ]

InfoRead1 := Ignore;
#>function (...) internal; end

RequirePackage( "anupq" );

d8 := SolvableGroup( 8, 4 );
#>D8
q8 := SolvableGroup( 8, 5 );
#>Q8

S := StandardPresentation( FpGroup(q8), 2, "Class", 10 );
#>Group( G.1, G.2, G.3 )
S.relators;
#>[ G.1^2*G.3^-1, G.2^2*G.3^-1, G.3^2, G.2^-1*G.1^-1*G.2*G.1*G.3^-1 ]

S := StandardPresentation( FpGroup(d8), 2, "Class", 10 );
#>Group( G.1, G.2, G.3 )
S.relators;
#>[ G.1^2, G.2^2, G.3^2, G.2^-1*G.1^-1*G.2*G.1*G.3^-1 ]

IsIsomorphicPGroup( d8, d8 );
#>true

IsIsomorphicPGroup( d8, q8 );
#>false

a := AbstractGenerator ("a");;
b := AbstractGenerator ("b");; 
F := Group( a, b );
#>Group( a, b )
F.relators := [ a^625,
  Comm(Comm(Comm(Comm(b,a), a), a), a) / Comm(b, a)^5,
  Comm(Comm(b,a), b), b^625 ];;
H := StandardPresentation( F, 5, "Class", 20, "Metabelian" );
#>Group( G.1, G.2, G.3, G.4, G.5, G.6, G.7, G.8, G.9, G.10, G.11, 
#>G.12, G.13, G.14, G.15, G.16, G.17, G.18, G.19, G.20 ) |

a := AbstractGenerator ("a");;
b := AbstractGenerator ("b");;
c := AbstractGenerator ("c");;
d := AbstractGenerator ("d");;
F := Group (a, b, c, d);
#>Group( a, b, c, d )
F.relators := [b^4, b^2 / Comm(Comm (b, a), a), d^16,
 a^16 / (c * d),  b^8 / (d * c^4)];
#>[ b^4, b^2*a^-2*b^-1*a*b*a*b^-1*a^-1*b*a, d^16, a^16*d^-1*c^-1, 
#>  b^8*c^-4*d^-1 ]
G := Pq (F, "Prime", 2, "ClassBound", 1);
#>Group( G.1, G.2 )
G.automorphisms := [];
#>[  ]
A := GroupHomomorphismByImages( G, G, [G.1, G.2], [G.2, G.1 * G.2] );
#>GroupHomomorphismByImages( Group( G.1, G.2 ), Group( G.1, G.2 ), 
#>[ G.1, G.2 ], [ G.2, G.1*G.2 ] )
Add( G.automorphisms, A );
A := GroupHomomorphismByImages( G, G, [G.1, G.2], [G.2, G.1] );
#>GroupHomomorphismByImages( Group( G.1, G.2 ), Group( G.1, G.2 ), 
#>[ G.1, G.2 ], [ G.2, G.1 ] )
Add( G.automorphisms, A );

H := StandardPresentation( F, G, "ClassBound", 14,
 "AgAutomorphisms" );
#>Group( G.1, G.2, G.3, G.4, G.5, G.6, G.7, G.8, G.9, G.10, G.11, 
#>G.12, G.13, G.14, G.15, G.16, G.17, G.18, G.19, G.20, G.21, G.22, 
#>G.23, G.24, G.25, G.26, G.27, G.28, G.29, G.30, G.31, G.32, G.33, 
#>G.34, G.35, G.36, G.37, G.38, G.39, G.40, G.41, G.42, G.43, G.44, 
#>G.45, G.46, G.47, G.48, G.49, G.50, G.51, G.52, G.53 )
H.relators;
#>[ G.1^2*G.4^-1, G.2^2*G.5^-1, 
#>  G.3^2*G.53^-1*G.52^-1*G.49^-1*G.46^-1*G.42^-1*G.41^-1*G.40^-1*G.36\
#>^-1*G.31^-1*G.29^-1*G.26^-1*G.22^-1*G.18^-1*G.11^-1*G.9^-1*G.8^-1*G.\
#>6^-1, G.4^2*G.7^-1, G.5^2, 
#>  G.6^2*G.51^-1*G.40^-1*G.39^-1*G.31^-1*G.21^-1*G.17^-1*G.14^-1*G.12\
#>^-1*G.11^-1*G.9^-1, G.7^2*G.10^-1, 
#>  G.8^2*G.53^-1*G.52^-1*G.50^-1*G.48^-1*G.46^-1*G.44^-1*G.43^-1*G.42\
#>^-1*G.41^-1*G.36^-1*G.35^-1*G.34^-1*G.31^-1*G.30^-1*G.29^-1*G.25^-1*\
#>G.22^-1*G.21^-1*G.17^-1, 
#>  G.9^2*G.53^-1*G.51^-1*G.48^-1*G.47^-1*G.46^-1*G.45^-1*G.44^-1*G.43\
#>^-1*G.37^-1*G.35^-1*G.34^-1*G.29^-1*G.25^-1*G.22^-1*G.21^-1*G.18^-1*\
#>G.17^-1*G.15^-1*G.12^-1, G.10^2*G.13^-1, 
#>  G.11^2*G.52^-1*G.50^-1*G.49^-1*G.48^-1*G.46^-1*G.45^-1*G.44^-1*G.4\
#>3^-1*G.41^-1*G.40^-1*G.37^-1*G.35^-1*G.34^-1*G.30^-1*G.29^-1*G.26^-1\
#>*G.21^-1, 
#>  G.12^2*G.51^-1*G.50^-1*G.49^-1*G.47^-1*G.46^-1*G.44^-1*G.43^-1*G.4\
#>2^-1*G.41^-1*G.39^-1*G.37^-1*G.36^-1*G.35^-1*G.31^-1*G.29^-1*G.26^-1\
#>*G.25^-1*G.21^-1*G.19^-1*G.15^-1, G.13^2*G.16^-1, 
#>  G.14^2*G.52^-1*G.51^-1*G.49^-1*G.48^-1*G.47^-1*G.45^-1*G.43^-1*G.4\
#>2^-1*G.40^-1*G.39^-1*G.36^-1*G.34^-1*G.31^-1*G.25^-1, 
#>  G.15^2*G.52^-1*G.49^-1*G.46^-1*G.43^-1*G.42^-1*G.41^-1*G.40^-1*G.3\
#>9^-1*G.37^-1*G.36^-1*G.35^-1*G.30^-1*G.29^-1*G.23^-1*G.19^-1, 
#>  G.16^2*G.20^-1, 
#>  G.17^2*G.52^-1*G.50^-1*G.49^-1*G.48^-1*G.45^-1*G.43^-1*G.39^-1*G.3\
#>6^-1*G.29^-1, 
#>  G.18^2*G.51^-1*G.50^-1*G.49^-1*G.47^-1*G.44^-1*G.43^-1*G.41^-1*G.3\
#>7^-1*G.30^-1, 
#>  G.19^2*G.53^-1*G.51^-1*G.49^-1*G.47^-1*G.46^-1*G.45^-1*G.41^-1*G.4\
#>0^-1*G.39^-1*G.34^-1*G.27^-1*G.23^-1, G.20^2*G.24^-1, 
#>  G.21^2*G.51^-1*G.48^-1*G.44^-1*G.41^-1*G.34^-1, 
#>  G.22^2*G.53^-1*G.49^-1*G.46^-1*G.42^-1*G.35^-1, 
#>  G.23^2*G.52^-1*G.51^-1*G.49^-1*G.48^-1*G.44^-1*G.43^-1*G.32^-1*G.2\
#>7^-1, G.24^2*G.28^-1, G.25^2*G.49^-1*G.46^-1*G.39^-1, 
#>  G.26^2*G.52^-1*G.47^-1*G.40^-1, G.27^2*G.48^-1*G.38^-1*G.32^-1, 
#>  G.28^2*G.33^-1, G.29^2*G.50^-1*G.43^-1, G.30^2*G.52^-1*G.44^-1, 
#>  G.31^2*G.53^-1*G.45^-1, G.32^2*G.38^-1, G.33^2, G.34^2*G.48^-1, 
#>  G.35^2*G.49^-1, G.36^2*G.50^-1, G.37^2*G.51^-1, G.38^2, G.39^2, 
#>  G.40^2, G.41^2, G.42^2, G.43^2, G.44^2, G.45^2, G.46^2, G.47^2, 
#>  G.48^2, G.49^2, G.50^2, G.51^2, G.52^2, G.53^2, 
#>  G.2^-1*G.1^-1*G.2*G.1*G.3^-1, G.3^-1*G.1^-1*G.3*G.1*G.5^-1, 
#>  G.3^-1*G.2^-1*G.3*G.2*G.6^-1, 
#>  G.4^-1*G.2^-1*G.4*G.2*G.53^-1*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.46\
#>^-1*G.44^-1*G.42^-1*G.40^-1*G.39^-1*G.37^-1*G.36^-1*G.35^-1*G.29^-1*\
#>G.17^-1*G.14^-1*G.8^-1*G.6^-1*G.5^-1, 
#>  G.4^-1*G.3^-1*G.4*G.3*G.53^-1*G.52^-1*G.51^-1*G.46^-1*G.44^-1*G.43\
#>^-1*G.31^-1*G.30^-1*G.25^-1*G.22^-1*G.21^-1*G.17^-1*G.8^-1, 
#>  G.5^-1*G.1^-1*G.5*G.1*G.8^-1, 
#>  G.5^-1*G.3^-1*G.5*G.3*G.53^-1*G.52^-1*G.50^-1*G.48^-1*G.47^-1*G.46\
#>^-1*G.45^-1*G.40^-1*G.37^-1*G.36^-1*G.34^-1*G.31^-1*G.30^-1*G.29^-1*\
#>G.25^-1*G.22^-1*G.18^-1*G.14^-1*G.11^-1, 
#>  G.5^-1*G.4^-1*G.5*G.4*G.52^-1*G.46^-1*G.43^-1*G.42^-1*G.41^-1*G.39\
#>^-1*G.36^-1*G.31^-1*G.30^-1*G.25^-1*G.22^-1*G.18^-1*G.17^-1*G.14^-1,
#>  G.6^-1*G.1^-1*G.6*G.1*G.53^-1*G.49^-1*G.46^-1*G.45^-1*G.41^-1*G.40\
#>^-1*G.36^-1*G.34^-1*G.31^-1*G.29^-1*G.26^-1*G.22^-1*G.21^-1*G.17^-1*\
#>G.11^-1, G.6^-1*G.2^-1*G.6*G.2*G.9^-1, 
#>  G.6^-1*G.3^-1*G.6*G.3*G.52^-1*G.50^-1*G.47^-1*G.46^-1*G.44^-1*G.43\
#>^-1*G.40^-1*G.37^-1*G.35^-1*G.31^-1*G.30^-1*G.29^-1*G.25^-1*G.22^-1*\
#>G.21^-1*G.14^-1, 
#>  G.6^-1*G.4^-1*G.6*G.4*G.53^-1*G.51^-1*G.49^-1*G.47^-1*G.45^-1*G.44\
#>^-1*G.43^-1*G.41^-1*G.39^-1*G.35^-1*G.29^-1*G.26^-1*G.25^-1*G.21^-1*\
#>G.14^-1, 
#>  G.6^-1*G.5^-1*G.6*G.5*G.50^-1*G.48^-1*G.47^-1*G.46^-1*G.43^-1*G.37\
#>^-1*G.35^-1*G.34^-1*G.31^-1*G.30^-1*G.29^-1*G.26^-1*G.22^-1*G.18^-1*\
#>G.17^-1, 
#>  G.7^-1*G.2^-1*G.7*G.2*G.53^-1*G.51^-1*G.48^-1*G.44^-1*G.43^-1*G.42\
#>^-1*G.40^-1*G.39^-1*G.37^-1*G.26^-1*G.21^-1*G.14^-1*G.12^-1*G.11^-1*\
#>G.9^-1, 
#>  G.7^-1*G.3^-1*G.7*G.3*G.53^-1*G.50^-1*G.49^-1*G.48^-1*G.46^-1*G.43\
#>^-1*G.42^-1*G.40^-1*G.37^-1*G.36^-1*G.25^-1*G.21^-1, 
#>  G.7^-1*G.5^-1*G.7*G.5*G.53^-1*G.52^-1*G.50^-1*G.49^-1*G.46^-1*G.45\
#>^-1*G.44^-1*G.43^-1*G.42^-1*G.40^-1*G.39^-1*G.34^-1*G.29^-1*G.25^-1,
#>  G.7^-1*G.6^-1*G.7*G.6*G.53^-1*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48\
#>^-1*G.47^-1*G.44^-1*G.43^-1*G.41^-1*G.40^-1*G.39^-1*G.34^-1*G.30^-1*\
#>G.29^-1, 
#>  G.8^-1*G.1^-1*G.8*G.1*G.53^-1*G.51^-1*G.50^-1*G.43^-1*G.41^-1*G.39\
#>^-1*G.35^-1*G.29^-1*G.21^-1*G.18^-1*G.14^-1, 
#>  G.8^-1*G.2^-1*G.8*G.2*G.11^-1, 
#>  G.8^-1*G.3^-1*G.8*G.3*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.45\
#>^-1*G.41^-1*G.37^-1*G.36^-1*G.35^-1*G.34^-1*G.31^-1*G.30^-1*G.26^-1*\
#>G.14^-1, 
#>  G.8^-1*G.4^-1*G.8*G.4*G.52^-1*G.49^-1*G.48^-1*G.44^-1*G.42^-1*G.40\
#>^-1*G.37^-1*G.36^-1*G.31^-1*G.30^-1*G.22^-1*G.17^-1, 
#>  G.8^-1*G.5^-1*G.8*G.5*G.53^-1*G.52^-1*G.51^-1*G.46^-1*G.44^-1*G.43\
#>^-1*G.31^-1*G.30^-1*G.25^-1*G.22^-1*G.21^-1*G.17^-1, 
#>  G.8^-1*G.6^-1*G.8*G.6*G.52^-1*G.51^-1*G.47^-1*G.45^-1*G.44^-1*G.43\
#>^-1*G.36^-1*G.29^-1*G.26^-1*G.22^-1*G.21^-1, 
#>  G.8^-1*G.7^-1*G.8*G.7*G.49^-1*G.46^-1*G.44^-1*G.29^-1, 
#>  G.9^-1*G.1^-1*G.9*G.1*G.53^-1*G.50^-1*G.49^-1*G.48^-1*G.47^-1*G.44\
#>^-1*G.39^-1*G.34^-1*G.31^-1*G.30^-1*G.29^-1*G.22^-1*G.21^-1*G.17^-1*\
#>G.14^-1, G.9^-1*G.2^-1*G.9*G.2*G.12^-1, 
#>  G.9^-1*G.3^-1*G.9*G.3*G.53^-1*G.51^-1*G.50^-1*G.48^-1*G.47^-1*G.45\
#>^-1*G.44^-1*G.43^-1*G.42^-1*G.41^-1*G.40^-1*G.39^-1*G.37^-1*G.36^-1*\
#>G.35^-1*G.30^-1*G.18^-1, 
#>  G.9^-1*G.4^-1*G.9*G.4*G.53^-1*G.51^-1*G.48^-1*G.47^-1*G.46^-1*G.45\
#>^-1*G.42^-1*G.40^-1*G.39^-1*G.37^-1*G.36^-1*G.35^-1*G.30^-1*G.17^-1,
#>  G.9^-1*G.5^-1*G.9*G.5*G.53^-1*G.50^-1*G.49^-1*G.46^-1*G.45^-1*G.41\
#>^-1*G.39^-1*G.34^-1*G.31^-1*G.30^-1*G.26^-1*G.25^-1*G.21^-1, 
#>  G.9^-1*G.6^-1*G.9*G.6*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.47^-1*G.46\
#>^-1*G.45^-1*G.43^-1*G.40^-1*G.39^-1*G.37^-1*G.35^-1*G.31^-1*G.29^-1*\
#>G.26^-1, 
#>  G.9^-1*G.7^-1*G.9*G.7*G.53^-1*G.52^-1*G.51^-1*G.50^-1*G.48^-1*G.46\
#>^-1*G.45^-1*G.44^-1*G.43^-1*G.39^-1*G.35^-1, 
#>  G.9^-1*G.8^-1*G.9*G.8*G.53^-1*G.48^-1*G.45^-1*G.44^-1*G.41^-1*G.35\
#>^-1*G.34^-1, 
#>  G.10^-1*G.2^-1*G.10*G.2*G.53^-1*G.52^-1*G.51^-1*G.49^-1*G.47^-1*G.\
#>46^-1*G.45^-1*G.44^-1*G.43^-1*G.42^-1*G.41^-1*G.40^-1*G.39^-1*G.35^-\
#>1*G.34^-1*G.25^-1*G.22^-1*G.21^-1*G.18^-1*G.17^-1*G.12^-1, 
#>  G.10^-1*G.3^-1*G.10*G.3*G.50^-1*G.48^-1*G.46^-1*G.44^-1*G.41^-1*G.\
#>39^-1*G.34^-1, 
#>  G.10^-1*G.5^-1*G.10*G.5*G.50^-1*G.49^-1*G.48^-1*G.46^-1*G.43^-1*G.\
#>39^-1, 
#>  G.10^-1*G.6^-1*G.10*G.6*G.52^-1*G.50^-1*G.48^-1*G.44^-1*G.43^-1, 
#>  G.10^-1*G.8^-1*G.10*G.8*G.50^-1*G.43^-1, 
#>  G.10^-1*G.9^-1*G.10*G.9*G.49^-1, G.11^-1*G.1^-1*G.11*G.1*G.14^-1, 
#>  G.11^-1*G.2^-1*G.11*G.2*G.53^-1*G.52^-1*G.47^-1*G.45^-1*G.43^-1*G.\
#>41^-1*G.37^-1*G.35^-1*G.34^-1*G.31^-1*G.29^-1*G.26^-1*G.25^-1*G.22^-\
#>1*G.17^-1, 
#>  G.11^-1*G.3^-1*G.11*G.3*G.51^-1*G.50^-1*G.44^-1*G.36^-1*G.35^-1*G.\
#>34^-1*G.31^-1*G.22^-1*G.21^-1*G.18^-1, 
#>  G.11^-1*G.4^-1*G.11*G.4*G.52^-1*G.51^-1*G.49^-1*G.48^-1*G.47^-1*G.\
#>45^-1*G.43^-1*G.42^-1*G.40^-1*G.39^-1*G.36^-1*G.34^-1*G.31^-1*G.25^-\
#>1*G.17^-1, 
#>  G.11^-1*G.5^-1*G.11*G.5*G.52^-1*G.48^-1*G.47^-1*G.46^-1*G.45^-1*G.\
#>44^-1*G.37^-1*G.35^-1*G.30^-1*G.29^-1*G.26^-1*G.21^-1, 
#>  G.11^-1*G.6^-1*G.11*G.6*G.52^-1*G.51^-1*G.49^-1*G.45^-1*G.44^-1*G.\
#>42^-1*G.41^-1*G.40^-1*G.39^-1*G.35^-1*G.29^-1*G.26^-1, 
#>  G.11^-1*G.7^-1*G.11*G.7*G.53^-1*G.52^-1*G.51^-1*G.45^-1*G.44^-1*G.\
#>35^-1, 
#>  G.11^-1*G.9^-1*G.11*G.9*G.49^-1*G.47^-1*G.46^-1*G.45^-1*G.44^-1*G.\
#>43^-1*G.41^-1*G.40^-1*G.36^-1*G.35^-1*G.34^-1, 
#>  G.11^-1*G.10^-1*G.11*G.10*G.49^-1, 
#>  G.12^-1*G.1^-1*G.12*G.1*G.52^-1*G.49^-1*G.48^-1*G.46^-1*G.45^-1*G.\
#>44^-1*G.43^-1*G.37^-1*G.34^-1*G.31^-1*G.30^-1*G.25^-1*G.22^-1, 
#>  G.12^-1*G.2^-1*G.12*G.2*G.15^-1, 
#>  G.12^-1*G.3^-1*G.12*G.3*G.52^-1*G.49^-1*G.48^-1*G.47^-1*G.45^-1*G.\
#>44^-1*G.36^-1*G.30^-1*G.29^-1*G.26^-1*G.25^-1, 
#>  G.12^-1*G.4^-1*G.12*G.4*G.52^-1*G.51^-1*G.49^-1*G.47^-1*G.46^-1*G.\
#>41^-1*G.40^-1*G.37^-1*G.35^-1*G.34^-1*G.29^-1*G.25^-1, 
#>  G.12^-1*G.5^-1*G.12*G.5*G.53^-1*G.49^-1*G.47^-1*G.45^-1*G.44^-1*G.\
#>42^-1*G.37^-1*G.36^-1*G.35^-1*G.34^-1*G.30^-1*G.29^-1, 
#>  G.12^-1*G.6^-1*G.12*G.6*G.49^-1*G.48^-1*G.46^-1*G.45^-1*G.42^-1*G.\
#>41^-1*G.37^-1*G.36^-1, 
#>  G.12^-1*G.7^-1*G.12*G.7*G.51^-1*G.50^-1*G.45^-1*G.44^-1*G.43^-1, 
#>  G.12^-1*G.8^-1*G.12*G.8*G.52^-1*G.50^-1*G.48^-1*G.47^-1*G.46^-1*G.\
#>45^-1*G.44^-1*G.43^-1*G.40^-1*G.36^-1*G.35^-1*G.34^-1, 
#>  G.12^-1*G.9^-1*G.12*G.9*G.52^-1*G.50^-1*G.48^-1*G.43^-1*G.41^-1*G.\
#>40^-1, 
#>  G.12^-1*G.11^-1*G.12*G.11*G.52^-1*G.51^-1*G.48^-1*G.43^-1*G.41^-1*\
#>G.40^-1, 
#>  G.13^-1*G.2^-1*G.13*G.2*G.53^-1*G.52^-1*G.46^-1*G.45^-1*G.44^-1*G.\
#>41^-1*G.39^-1*G.34^-1*G.31^-1*G.30^-1*G.26^-1*G.25^-1*G.21^-1*G.19^-\
#>1*G.15^-1, G.13^-1*G.3^-1*G.13*G.3*G.48^-1, 
#>  G.14^-1*G.1^-1*G.14*G.1*G.17^-1, G.14^-1*G.2^-1*G.14*G.2*G.18^-1, 
#>  G.14^-1*G.3^-1*G.14*G.3*G.53^-1*G.52^-1*G.51^-1*G.46^-1*G.45^-1*G.\
#>42^-1*G.41^-1*G.39^-1*G.37^-1*G.36^-1*G.34^-1*G.31^-1*G.29^-1*G.26^-\
#>1*G.25^-1*G.22^-1*G.21^-1, 
#>  G.14^-1*G.4^-1*G.14*G.4*G.53^-1*G.52^-1*G.50^-1*G.47^-1*G.45^-1*G.\
#>43^-1*G.42^-1*G.40^-1*G.34^-1*G.31^-1*G.30^-1*G.25^-1, 
#>  G.14^-1*G.5^-1*G.14*G.5*G.53^-1*G.52^-1*G.51^-1*G.50^-1*G.48^-1*G.\
#>47^-1*G.46^-1*G.42^-1*G.41^-1*G.36^-1*G.34^-1*G.31^-1*G.25^-1, 
#>  G.14^-1*G.6^-1*G.14*G.6*G.49^-1*G.47^-1*G.40^-1*G.36^-1*G.35^-1*G.\
#>34^-1*G.31^-1, 
#>  G.14^-1*G.7^-1*G.14*G.7*G.52^-1*G.46^-1*G.45^-1*G.39^-1, 
#>  G.14^-1*G.8^-1*G.14*G.8*G.52^-1*G.47^-1*G.46^-1*G.45^-1*G.44^-1*G.\
#>41^-1*G.36^-1*G.35^-1*G.34^-1, 
#>  G.14^-1*G.9^-1*G.14*G.9*G.51^-1*G.48^-1*G.47^-1*G.46^-1*G.44^-1*G.\
#>43^-1*G.40^-1*G.36^-1*G.35^-1*G.34^-1, 
#>  G.14^-1*G.11^-1*G.14*G.11*G.52^-1*G.50^-1*G.49^-1*G.47^-1*G.46^-1*\
#>G.45^-1*G.44^-1*G.43^-1*G.40^-1*G.36^-1*G.35^-1*G.34^-1, 
#>  G.14^-1*G.12^-1*G.14*G.12*G.50^-1*G.49^-1*G.48^-1, 
#>  G.15^-1*G.1^-1*G.15*G.1*G.52^-1*G.51^-1*G.48^-1*G.46^-1*G.45^-1*G.\
#>44^-1*G.43^-1*G.42^-1*G.36^-1*G.31^-1*G.29^-1*G.25^-1, 
#>  G.15^-1*G.2^-1*G.15*G.2*G.19^-1, 
#>  G.15^-1*G.3^-1*G.15*G.3*G.51^-1*G.48^-1*G.40^-1*G.39^-1*G.37^-1*G.\
#>30^-1, 
#>  G.15^-1*G.4^-1*G.15*G.4*G.51^-1*G.45^-1*G.44^-1*G.43^-1*G.36^-1*G.\
#>29^-1, 
#>  G.15^-1*G.5^-1*G.15*G.5*G.53^-1*G.52^-1*G.47^-1*G.46^-1*G.45^-1*G.\
#>44^-1*G.43^-1*G.41^-1*G.40^-1*G.39^-1*G.34^-1, 
#>  G.15^-1*G.6^-1*G.15*G.6*G.53^-1*G.50^-1*G.49^-1*G.47^-1*G.45^-1*G.\
#>43^-1*G.40^-1, G.15^-1*G.7^-1*G.15*G.7*G.49^-1, 
#>  G.15^-1*G.11^-1*G.15*G.11*G.50^-1*G.49^-1*G.48^-1, 
#>  G.15^-1*G.14^-1*G.15*G.14*G.50^-1*G.49^-1*G.48^-1, 
#>  G.16^-1*G.2^-1*G.16*G.2*G.51^-1*G.48^-1*G.46^-1*G.44^-1*G.42^-1*G.\
#>41^-1*G.40^-1*G.39^-1*G.37^-1*G.36^-1*G.35^-1*G.30^-1*G.29^-1*G.19^-\
#>1, 
#>  G.17^-1*G.1^-1*G.17*G.1*G.53^-1*G.49^-1*G.48^-1*G.47^-1*G.43^-1*G.\
#>42^-1*G.40^-1*G.39^-1*G.36^-1*G.34^-1*G.31^-1*G.30^-1*G.29^-1*G.25^-\
#>1, G.17^-1*G.2^-1*G.17*G.2*G.21^-1, 
#>  G.17^-1*G.3^-1*G.17*G.3*G.52^-1*G.51^-1*G.49^-1*G.47^-1*G.46^-1*G.\
#>45^-1*G.44^-1*G.43^-1*G.42^-1*G.40^-1*G.39^-1*G.37^-1*G.34^-1*G.25^-\
#>1, 
#>  G.17^-1*G.4^-1*G.17*G.4*G.53^-1*G.52^-1*G.51^-1*G.49^-1*G.48^-1*G.\
#>39^-1*G.36^-1*G.35^-1*G.29^-1, 
#>  G.17^-1*G.5^-1*G.17*G.5*G.52^-1*G.51^-1*G.50^-1*G.47^-1*G.45^-1*G.\
#>44^-1*G.41^-1*G.39^-1*G.35^-1*G.34^-1*G.29^-1, 
#>  G.17^-1*G.6^-1*G.17*G.6*G.52^-1*G.50^-1*G.49^-1*G.48^-1*G.47^-1*G.\
#>46^-1*G.45^-1*G.44^-1*G.43^-1*G.40^-1*G.35^-1*G.34^-1, 
#>  G.17^-1*G.7^-1*G.17*G.7*G.43^-1, 
#>  G.17^-1*G.8^-1*G.17*G.8*G.52^-1*G.51^-1, 
#>  G.17^-1*G.9^-1*G.17*G.9*G.52^-1*G.51^-1*G.49^-1*G.48^-1*G.46^-1*G.\
#>45^-1, G.17^-1*G.11^-1*G.17*G.11*G.52^-1*G.51^-1*G.46^-1*G.45^-1, 
#>  G.17^-1*G.12^-1*G.17*G.12*G.50^-1*G.49^-1*G.48^-1, 
#>  G.17^-1*G.14^-1*G.17*G.14*G.50^-1*G.49^-1*G.48^-1, 
#>  G.18^-1*G.1^-1*G.18*G.1*G.22^-1, 
#>  G.18^-1*G.2^-1*G.18*G.2*G.53^-1*G.51^-1*G.49^-1*G.48^-1*G.46^-1*G.\
#>43^-1*G.42^-1*G.37^-1*G.36^-1*G.34^-1*G.31^-1*G.30^-1*G.25^-1, 
#>  G.18^-1*G.3^-1*G.18*G.3*G.53^-1*G.51^-1*G.49^-1*G.48^-1*G.46^-1*G.\
#>45^-1*G.44^-1*G.43^-1*G.39^-1*G.36^-1*G.35^-1*G.31^-1*G.30^-1*G.29^-\
#>1*G.26^-1, 
#>  G.18^-1*G.4^-1*G.18*G.4*G.53^-1*G.50^-1*G.49^-1*G.48^-1*G.47^-1*G.\
#>45^-1*G.44^-1*G.42^-1*G.41^-1*G.40^-1*G.37^-1*G.36^-1*G.34^-1*G.25^-\
#>1, 
#>  G.18^-1*G.5^-1*G.18*G.5*G.52^-1*G.50^-1*G.49^-1*G.47^-1*G.43^-1*G.\
#>41^-1*G.37^-1*G.30^-1, 
#>  G.18^-1*G.6^-1*G.18*G.6*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>47^-1*G.46^-1*G.44^-1*G.43^-1*G.40^-1*G.37^-1*G.36^-1*G.35^-1*G.34^-\
#>1, G.18^-1*G.7^-1*G.18*G.7*G.51^-1*G.45^-1*G.44^-1, 
#>  G.18^-1*G.8^-1*G.18*G.8*G.52^-1*G.50^-1*G.49^-1*G.47^-1*G.46^-1*G.\
#>45^-1*G.44^-1*G.43^-1*G.40^-1*G.36^-1*G.35^-1*G.34^-1, 
#>  G.18^-1*G.9^-1*G.18*G.9*G.52^-1*G.50^-1*G.49^-1*G.43^-1*G.41^-1*G.\
#>40^-1, 
#>  G.18^-1*G.11^-1*G.18*G.11*G.52^-1*G.51^-1*G.48^-1*G.43^-1*G.41^-1*\
#>G.40^-1, G.18^-1*G.12^-1*G.18*G.12*G.50^-1*G.49^-1*G.48^-1, 
#>  G.18^-1*G.17^-1*G.18*G.17*G.50^-1*G.49^-1*G.48^-1, 
#>  G.19^-1*G.1^-1*G.19*G.1*G.53^-1*G.52^-1*G.51^-1*G.49^-1*G.46^-1*G.\
#>44^-1*G.43^-1*G.42^-1*G.35^-1, G.19^-1*G.2^-1*G.19*G.2*G.23^-1, 
#>  G.19^-1*G.3^-1*G.19*G.3*G.52^-1*G.51^-1*G.49^-1*G.47^-1*G.46^-1*G.\
#>43^-1*G.40^-1*G.39^-1, 
#>  G.19^-1*G.4^-1*G.19*G.4*G.51^-1*G.50^-1*G.48^-1*G.46^-1*G.39^-1, 
#>  G.19^-1*G.5^-1*G.19*G.5*G.52^-1*G.51^-1*G.49^-1*G.44^-1*G.43^-1, 
#>  G.19^-1*G.6^-1*G.19*G.6*G.51^-1*G.50^-1, 
#>  G.19^-1*G.8^-1*G.19*G.8*G.50^-1*G.49^-1*G.48^-1, 
#>  G.20^-1*G.2^-1*G.20*G.2*G.53^-1*G.52^-1*G.47^-1*G.46^-1*G.45^-1*G.\
#>44^-1*G.43^-1*G.41^-1*G.40^-1*G.39^-1*G.34^-1*G.27^-1*G.23^-1, 
#>  G.21^-1*G.1^-1*G.21*G.1*G.25^-1, 
#>  G.21^-1*G.2^-1*G.21*G.2*G.52^-1*G.50^-1*G.48^-1*G.47^-1*G.45^-1*G.\
#>39^-1*G.35^-1*G.29^-1, 
#>  G.21^-1*G.3^-1*G.21*G.3*G.53^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>43^-1*G.35^-1*G.34^-1*G.30^-1, 
#>  G.21^-1*G.4^-1*G.21*G.4*G.49^-1*G.46^-1*G.39^-1*G.29^-1, 
#>  G.21^-1*G.5^-1*G.21*G.5*G.51^-1*G.50^-1*G.49^-1*G.44^-1*G.43^-1*G.\
#>40^-1*G.34^-1, 
#>  G.21^-1*G.6^-1*G.21*G.6*G.52^-1*G.51^-1*G.49^-1*G.46^-1*G.45^-1*G.\
#>43^-1*G.40^-1, G.21^-1*G.7^-1*G.21*G.7*G.49^-1, 
#>  G.21^-1*G.8^-1*G.21*G.8*G.46^-1*G.45^-1, 
#>  G.21^-1*G.9^-1*G.21*G.9*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1, 
#>  G.21^-1*G.11^-1*G.21*G.11*G.52^-1*G.51^-1, 
#>  G.21^-1*G.14^-1*G.21*G.14*G.50^-1*G.49^-1*G.48^-1, 
#>  G.22^-1*G.1^-1*G.22*G.1*G.50^-1*G.49^-1*G.48^-1*G.47^-1*G.46^-1*G.\
#>45^-1*G.44^-1*G.41^-1*G.40^-1*G.37^-1*G.36^-1*G.35^-1*G.34^-1*G.25^-\
#>1, G.22^-1*G.2^-1*G.22*G.2*G.26^-1, 
#>  G.22^-1*G.3^-1*G.22*G.3*G.52^-1*G.51^-1*G.47^-1*G.46^-1*G.44^-1*G.\
#>43^-1*G.42^-1*G.40^-1*G.37^-1*G.35^-1*G.34^-1*G.31^-1*G.30^-1, 
#>  G.22^-1*G.4^-1*G.22*G.4*G.52^-1*G.49^-1*G.46^-1*G.45^-1*G.42^-1*G.\
#>39^-1*G.29^-1, 
#>  G.22^-1*G.5^-1*G.22*G.5*G.53^-1*G.51^-1*G.50^-1*G.47^-1*G.46^-1*G.\
#>44^-1*G.43^-1*G.42^-1*G.40^-1*G.36^-1*G.34^-1, 
#>  G.22^-1*G.6^-1*G.22*G.6*G.49^-1*G.43^-1*G.42^-1*G.41^-1*G.40^-1, 
#>  G.22^-1*G.7^-1*G.22*G.7*G.50^-1*G.49^-1, 
#>  G.22^-1*G.8^-1*G.22*G.8*G.52^-1*G.51^-1*G.46^-1*G.45^-1, 
#>  G.22^-1*G.9^-1*G.22*G.9*G.46^-1*G.45^-1, 
#>  G.22^-1*G.11^-1*G.22*G.11*G.50^-1*G.49^-1*G.48^-1*G.46^-1*G.45^-1,
#>  G.22^-1*G.14^-1*G.22*G.14*G.50^-1*G.49^-1*G.48^-1, 
#>  G.23^-1*G.1^-1*G.23*G.1*G.53^-1*G.46^-1*G.45^-1*G.43^-1*G.39^-1, 
#>  G.23^-1*G.2^-1*G.23*G.2*G.27^-1, 
#>  G.23^-1*G.3^-1*G.23*G.3*G.52^-1*G.51^-1*G.44^-1, 
#>  G.23^-1*G.4^-1*G.23*G.4*G.43^-1, G.23^-1*G.5^-1*G.23*G.5*G.48^-1, 
#>  G.24^-1*G.2^-1*G.24*G.2*G.52^-1*G.51^-1*G.49^-1*G.48^-1*G.44^-1*G.\
#>43^-1*G.27^-1, G.25^-1*G.1^-1*G.25*G.1*G.29^-1, 
#>  G.25^-1*G.2^-1*G.25*G.2*G.30^-1, 
#>  G.25^-1*G.3^-1*G.25*G.3*G.51^-1*G.50^-1*G.45^-1*G.43^-1*G.40^-1*G.\
#>39^-1*G.35^-1*G.34^-1, 
#>  G.25^-1*G.4^-1*G.25*G.4*G.52^-1*G.51^-1*G.46^-1*G.44^-1*G.43^-1*G.\
#>39^-1, G.25^-1*G.5^-1*G.25*G.5*G.50^-1*G.48^-1*G.46^-1*G.39^-1, 
#>  G.25^-1*G.6^-1*G.25*G.6*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>45^-1, G.25^-1*G.8^-1*G.25*G.8*G.50^-1*G.49^-1*G.48^-1, 
#>  G.25^-1*G.9^-1*G.25*G.9*G.50^-1*G.49^-1*G.48^-1, 
#>  G.25^-1*G.11^-1*G.25*G.11*G.50^-1*G.49^-1*G.48^-1, 
#>  G.26^-1*G.1^-1*G.26*G.1*G.31^-1, 
#>  G.26^-1*G.2^-1*G.26*G.2*G.53^-1*G.52^-1*G.51^-1*G.50^-1*G.46^-1*G.\
#>44^-1*G.43^-1*G.42^-1*G.36^-1*G.34^-1, 
#>  G.26^-1*G.3^-1*G.26*G.3*G.48^-1*G.44^-1*G.42^-1*G.41^-1*G.39^-1*G.\
#>37^-1, G.26^-1*G.4^-1*G.26*G.4*G.53^-1*G.45^-1*G.36^-1, 
#>  G.26^-1*G.5^-1*G.26*G.5*G.52^-1*G.50^-1*G.49^-1*G.47^-1*G.43^-1*G.\
#>41^-1, 
#>  G.26^-1*G.6^-1*G.26*G.6*G.52^-1*G.51^-1*G.47^-1*G.46^-1*G.45^-1, 
#>  G.26^-1*G.8^-1*G.26*G.8*G.50^-1*G.49^-1*G.48^-1*G.46^-1*G.45^-1, 
#>  G.26^-1*G.9^-1*G.26*G.9*G.52^-1*G.51^-1, 
#>  G.26^-1*G.11^-1*G.26*G.11*G.52^-1*G.51^-1, 
#>  G.27^-1*G.1^-1*G.27*G.1*G.49^-1, G.27^-1*G.2^-1*G.27*G.2*G.32^-1, 
#>  G.28^-1*G.2^-1*G.28*G.2*G.48^-1*G.38^-1*G.32^-1, 
#>  G.29^-1*G.1^-1*G.29*G.1*G.52^-1*G.51^-1*G.50^-1*G.46^-1*G.44^-1*G.\
#>39^-1, G.29^-1*G.2^-1*G.29*G.2*G.34^-1, 
#>  G.29^-1*G.3^-1*G.29*G.3*G.52^-1*G.39^-1, 
#>  G.29^-1*G.4^-1*G.29*G.4*G.50^-1*G.49^-1*G.43^-1, 
#>  G.29^-1*G.5^-1*G.29*G.5*G.49^-1*G.48^-1*G.43^-1, 
#>  G.29^-1*G.6^-1*G.29*G.6*G.49^-1*G.48^-1, 
#>  G.30^-1*G.1^-1*G.30*G.1*G.35^-1, 
#>  G.30^-1*G.2^-1*G.30*G.2*G.52^-1*G.50^-1*G.48^-1*G.46^-1*G.44^-1*G.\
#>39^-1, 
#>  G.30^-1*G.3^-1*G.30*G.3*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.45^-1*G.\
#>44^-1*G.43^-1*G.40^-1, 
#>  G.30^-1*G.4^-1*G.30*G.4*G.52^-1*G.50^-1*G.46^-1*G.45^-1*G.39^-1, 
#>  G.30^-1*G.5^-1*G.30*G.5*G.52^-1*G.44^-1, 
#>  G.30^-1*G.6^-1*G.30*G.6*G.51^-1*G.50^-1*G.49^-1*G.48^-1, 
#>  G.30^-1*G.8^-1*G.30*G.8*G.50^-1*G.49^-1*G.48^-1, 
#>  G.31^-1*G.1^-1*G.31*G.1*G.36^-1, G.31^-1*G.2^-1*G.31*G.2*G.37^-1, 
#>  G.31^-1*G.3^-1*G.31*G.3*G.53^-1*G.50^-1*G.47^-1*G.46^-1*G.42^-1*G.\
#>41^-1, 
#>  G.31^-1*G.4^-1*G.31*G.4*G.53^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>45^-1, 
#>  G.31^-1*G.5^-1*G.31*G.5*G.53^-1*G.50^-1*G.49^-1*G.48^-1*G.45^-1, 
#>  G.31^-1*G.6^-1*G.31*G.6*G.53^-1*G.52^-1*G.51^-1, 
#>  G.32^-1*G.2^-1*G.32*G.2*G.38^-1, G.33^-1*G.2^-1*G.33*G.2*G.38^-1, 
#>  G.34^-1*G.1^-1*G.34*G.1*G.39^-1, 
#>  G.34^-1*G.2^-1*G.34*G.2*G.49^-1*G.43^-1, 
#>  G.34^-1*G.3^-1*G.34*G.3*G.49^-1*G.48^-1*G.44^-1, 
#>  G.34^-1*G.4^-1*G.34*G.4*G.43^-1, G.34^-1*G.5^-1*G.34*G.5*G.48^-1, 
#>  G.35^-1*G.1^-1*G.35*G.1*G.52^-1*G.50^-1*G.49^-1*G.46^-1*G.45^-1*G.\
#>39^-1, G.35^-1*G.2^-1*G.35*G.2*G.40^-1, 
#>  G.35^-1*G.3^-1*G.35*G.3*G.52^-1*G.49^-1*G.48^-1*G.45^-1*G.44^-1, 
#>  G.35^-1*G.4^-1*G.35*G.4*G.43^-1, 
#>  G.35^-1*G.5^-1*G.35*G.5*G.50^-1*G.48^-1, 
#>  G.36^-1*G.1^-1*G.36*G.1*G.53^-1*G.51^-1*G.49^-1*G.48^-1*G.45^-1, 
#>  G.36^-1*G.2^-1*G.36*G.2*G.41^-1, 
#>  G.36^-1*G.3^-1*G.36*G.3*G.52^-1*G.51^-1*G.46^-1, 
#>  G.36^-1*G.4^-1*G.36*G.4*G.50^-1, G.36^-1*G.5^-1*G.36*G.5*G.50^-1, 
#>  G.37^-1*G.1^-1*G.37*G.1*G.42^-1, 
#>  G.37^-1*G.2^-1*G.37*G.2*G.53^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>45^-1, G.37^-1*G.3^-1*G.37*G.3*G.53^-1*G.51^-1*G.50^-1*G.47^-1, 
#>  G.37^-1*G.4^-1*G.37*G.4*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>45^-1, G.37^-1*G.5^-1*G.37*G.5*G.51^-1, 
#>  G.39^-1*G.1^-1*G.39*G.1*G.43^-1, G.39^-1*G.2^-1*G.39*G.2*G.44^-1, 
#>  G.39^-1*G.3^-1*G.39*G.3*G.49^-1*G.48^-1, 
#>  G.40^-1*G.1^-1*G.40*G.1*G.45^-1, 
#>  G.40^-1*G.2^-1*G.40*G.2*G.50^-1*G.48^-1, 
#>  G.40^-1*G.3^-1*G.40*G.3*G.51^-1, G.40^-1*G.4^-1*G.40*G.4*G.50^-1, 
#>  G.41^-1*G.1^-1*G.41*G.1*G.46^-1, G.41^-1*G.2^-1*G.41*G.2*G.50^-1, 
#>  G.41^-1*G.3^-1*G.41*G.3*G.52^-1, G.41^-1*G.4^-1*G.41*G.4*G.50^-1, 
#>  G.42^-1*G.1^-1*G.42*G.1*G.52^-1*G.51^-1*G.50^-1*G.49^-1*G.48^-1*G.\
#>45^-1, G.42^-1*G.2^-1*G.42*G.2*G.47^-1, 
#>  G.42^-1*G.3^-1*G.42*G.3*G.53^-1*G.51^-1, 
#>  G.42^-1*G.4^-1*G.42*G.4*G.50^-1, G.43^-1*G.2^-1*G.43*G.2*G.48^-1, 
#>  G.44^-1*G.1^-1*G.44*G.1*G.49^-1, G.45^-1*G.1^-1*G.45*G.1*G.50^-1, 
#>  G.45^-1*G.2^-1*G.45*G.2*G.51^-1, G.46^-1*G.1^-1*G.46*G.1*G.50^-1, 
#>  G.46^-1*G.2^-1*G.46*G.2*G.52^-1, G.47^-1*G.1^-1*G.47*G.1*G.53^-1 ]
