/* definition file for p-quotient program */

#ifndef __PQ_DEFINES__

#define __PQ_DEFINES__

/* various definitions required by CAYLEY */

#ifdef CAYLEY
#include "defs.h"  /* CAYLEY type definitions */
#define PRINT io_printf
#define CRASH do { error_internal("Bad p-group generation file");} while(0)
#undef A
#undef DEBUG 
#undef WORD
#undef extend
#ifdef df
#undef df
#endif
#define CAYLEY_FP       1
#define CAYLEY_PC       2
#define CAYLEY_FORMAT   3
#define CAYLEY_INTERNAL 4 
#define PQ_MIN_SPACE    10000
#define PQ_MISC_SPACE   5000

#else

#define TRUE	1
#define FALSE	0
#define Logical	int
#define PRINT printf
#define CRASH do { exit(0); } while(0)
#endif

#include <stdio.h>
#include <math.h>
#include <ctype.h> 
#include <string.h>

#if defined (LARGE_INT)
#ifndef GNUINC
#include "/usr/local/include/gmp.h"
#else
#include "gmp.h"
#endif
#endif

/* each of the following header files may be absent from certain systems */
/* #include <limits.h> */
/* #include <stdlib.h> */

#define COMMENT '#'

/*
#include <unistd.h> 
#include <fcntl.h> 
#define PMODE 0644
#define FILE_TYPE int
#define RESET(File) (lseek((File), 0, SEEK_SET))
#define CLOSE(File) (close((File)))
*/

#define FILE_TYPE FILE*
#define RESET(File) (rewind((File)))
#define CLOSE(File) (fclose((File)))

#define and(a, b)	((a) & (b))
#define or(a, b)	((a) | (b))
#define not(a)		(~(a))
#define rshift(a, n)	((a) >> (n))
#define lshift(a, n)	((a) << (n))
#define xor(a, b)	((a) ^ (b))

#ifndef two_to_the_n
#define two_to_the_n(n)  (1 << (n))
#endif
#define MOD(a, b) ((a) % (b))
#ifndef USE_BIT_OPS
#define FIELD1(i) ((i) / two_to_the_n(16))
#define FIELD2(i) ((i) % two_to_the_n(16))
#define INSWT(i) ((i) * two_to_the_n(24))
#define PACK2(i, j) ((i) * two_to_the_n(16) + (j))
#define PACK3(i, j, k) (((i) * two_to_the_n(16) + (j)) * two_to_the_n(8) + (k))
#define PART2(i) (MOD((i) / two_to_the_n(8), two_to_the_n(16)))
#define PART3(i) (MOD((i), two_to_the_n(8)))
#define WT(i) ((i) / two_to_the_n(24))
#else /* USE_BIT_OPS */
#define FIELD1(i) ((i) >> 16)
#define FIELD2(i) ((i) & 0xffff)
#define INSWT(i) ((i) << 24)
#define PACK2(i, j) (((i)<<16) + (j))
#define PACK3(i, j, k) (((((i) << 16) + (j)) << 8) + (k))
#define PART2(i) (((i) >> 8) & 0xffff)
#define PART3(i) ((i) & 0xff)
#define WT(i) ((i) >> 24)
#endif /* USE_BIT_OPS */

#define MIN(A, B) ((A) < (B) ? (A) : (B))
#define MAX(A, B) ((A) > (B) ? (A) : (B))

#endif
