#include "pq_defs.h"
#include "pcp_vars.h"

/* beware - calls to this procedure are context sensitive since 
   it may call compact which moves strings; hence, calls should
   be carefully placed with a suitable upper bound as argument; 

   check if there is room available for required words; 
   if so, return FALSE, otherwise compact the workspace 
   and try again; if there is still no room, report this, 
   set pcp->overflow TRUE, and return TRUE */

Logical is_space_exhausted (required, pcp)
int required;
struct pcp_vars *pcp;   
{
   if (pcp->lused + required - pcp->subgrp <= 0)
      return FALSE;

   /* not enough room currently available, so we compact tables */
   compact (pcp);
   if (pcp->lused + required - pcp->subgrp <= 0)
      return FALSE;
   pcp->overflow = TRUE;
   text (11, pcp->newgen, 0, 0, 0);
   return TRUE;
}
