#include "pq_defs.h"
#if defined (MAC)

int runTime ()
{
   return 0;
}

#else
#if defined (UNIX) && !defined(NO_GETRUSAGE)

#include <sys/time.h>
#include <sys/resource.h>
/*
#include "constants.h"
*/

/* return user time in milliseconds; adapted from code by Werner Nickel */

int runTime () 
{
   struct rusage buf;

   if (getrusage (RUSAGE_SELF, &buf)) {
       perror ("could not obtain timing");
       exit (0);
   }
   return buf.ru_utime.tv_sec * 1000 + buf.ru_utime.tv_usec / 1000;
}

#else
#if defined(UNIX) && defined(NO_GETRUSAGE)

#include <sys/types.h>
#include <sys/times.h>
  
/* compute user time in milliseconds */
  
int runTime () 
{
   struct tms buf;
  
   times (&buf);
   return (buf.tms_utime * 50 / 3); 
} 

#else
#if defined (VMS)

#include <time.h>
int runTime ()
{
   tbuffer_t x;
   times (&x);

   return 10 * (x.proc_user_time + x.child_user_time);
}
#endif
#endif
#endif
#endif
