#############################################################################
##
#A    nq.tst                 January 1993                       Werner Nickel
#A                                                             & Frank Celler
##

## set the size of the screen to a known value ##############################
sizeScreen := SizeScreen();;
SizeScreen( [ 70, 24 ] );;

## construct a few abstract generators ######################################
a := AbstractGenerator("a");;
b := AbstractGenerator("b");;
c := AbstractGenerator("c");;
d := AbstractGenerator("d");;
e := AbstractGenerator("e");;
f := AbstractGenerator("f");;
g := AbstractGenerator("g");;
h := AbstractGenerator("h");;
i := AbstractGenerator("i");;
j := AbstractGenerator("j");;
k := AbstractGenerator("k");;

## examples/G1.fp ###########################################################
G := Group( a, b, c, d, e, f, g, h, i, j, k );;
G.relators := [ b*a/(a*b*c), c*a/(a*c*d), c*b/(b*c*e), d*a/(a*d), 
	        d*b/(b*d*f), e*b/(b*e*g), f*a/(a*f*i), f*b/(b*f*h),
		g*a/(a*g*h^3*i^2*j^3), g*b/(b*g*j^3), h*a/(a*h*i),
                h*b/(b*h*j), i*a/(a*i), i*b/(b*i*k), j*a/(a*j*k^4),
                j*b/(b*j), k*b/(b*k) ];;
NilpotentQuotient( G );
#>[ [ 0, 0 ], [ 0 ], [ 0, 0 ], [ 0, 0 ], [ 0 ], [ 5, 0 ], [ 20 ], 
#>  [  ] ]

## examples/G2.fp ###########################################################
G := Group( a, b );;
G.relators := [
LeftNormedComm(b,a,a,a,a,a,a),
LeftNormedComm(b,a,a,a,a,a,b),
LeftNormedComm(a,a*b,a*b,a*b,a*b,a*b),
LeftNormedComm(a,a*b^-1,a*b^-1,a*b^-1,a*b^-1,a*b^-1),
LeftNormedComm(a,a*Comm(b,a),a*Comm(b,a),a*Comm(b,a),a*Comm(b,a),a*Comm(b,a)),
LeftNormedComm(b,a,b,b),
LeftNormedComm(b,a,a,b,b),
LeftNormedComm(b,a,b,b,b),
LeftNormedComm(b,a,b,Comm(b,a)),
LeftNormedComm(b,a,a,a,b,b),
LeftNormedComm(b,a,a,b,b,b),
LeftNormedComm(b,a,b,b,b,b),
LeftNormedComm(b,a,a,b,Comm(b,a)),
LeftNormedComm(b,a,b,b,Comm(b,a)),
LeftNormedComm(b,a,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,a,a,b,b),
LeftNormedComm(b,a,a,a,b,b,b),
LeftNormedComm(b,a,a,b,b,b,b),
LeftNormedComm(b,a,b,b,b,b,b),
LeftNormedComm(b,a,a,a,b,Comm(b,a)),
LeftNormedComm(b,a,a,b,b,Comm(b,a)),
LeftNormedComm(b,a,b,b,b,Comm(b,a)),
LeftNormedComm(b,a,a,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,b,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,a,a,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,b)) ];;
NilpotentQuotient(G);
#>[ [ 0, 0 ], [ 0 ], [ 0, 0 ], [ 0, 0 ], [ 0, 0, 0 ], [ 2, 0 ], 
#>  [ 0 ], [  ] ]

## examples/G3.fp ###########################################################
G := Group( a, b );;
G.relators := [
LeftNormedComm(a,a*b,a*b,a*b,a*b,a*b,a*b),
LeftNormedComm(a,a*b^-1,a*b^-1,a*b^-1,a*b^-1,a*b^-1,a*b^-1),
LeftNormedComm(a,a*Comm(b,a),a*Comm(b,a),a*Comm(b,a),a*Comm(b,a),
               a*Comm(b,a),a*Comm(b,a)),
LeftNormedComm(b,a,a,a,a,a,a,a),
LeftNormedComm(b,a,a,a,a,a,a,b),
LeftNormedComm(b,a,b,b),
LeftNormedComm(b,a,a,b,b),
LeftNormedComm(b,a,b,b,b),
LeftNormedComm(b,a,b,Comm(b,a)),
LeftNormedComm(b,a,a,a,b,b),
LeftNormedComm(b,a,a,b,b,b),
LeftNormedComm(b,a,b,b,b,b),
LeftNormedComm(b,a,a,b,Comm(b,a)),
LeftNormedComm(b,a,b,b,Comm(b,a)),
LeftNormedComm(b,a,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,a,a,b,b),
LeftNormedComm(b,a,a,a,b,b,b),
LeftNormedComm(b,a,a,b,b,b,b),
LeftNormedComm(b,a,b,b,b,b,b),
LeftNormedComm(b,a,a,a,b,Comm(b,a)),
LeftNormedComm(b,a,a,b,b,Comm(b,a)),
LeftNormedComm(b,a,b,b,b,Comm(b,a)),
LeftNormedComm(b,a,a,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,b,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,a,a,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,a,a,a,b,b),
LeftNormedComm(b,a,a,a,a,b,b,b),
LeftNormedComm(b,a,a,a,b,b,b,b),
LeftNormedComm(b,a,a,b,b,b,b,b),
LeftNormedComm(b,a,b,b,b,b,b,b),
LeftNormedComm(b,a,a,a,a,b,Comm(b,a)),
LeftNormedComm(b,a,a,a,b,b,Comm(b,a)),
LeftNormedComm(b,a,a,b,b,b,Comm(b,a)),
LeftNormedComm(b,a,b,b,b,b,Comm(b,a)),
LeftNormedComm(b,a,a,a,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,a,b,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,b,b,Comm(b,a),Comm(b,a)),
LeftNormedComm(b,a,a,a,a,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,a,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,a,b,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,b,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,b,b,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,b,b,b,LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,b,b,b,LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,Comm(b,a),LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,a,Comm(b,a),LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,a)),
LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,b)),
LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,a,a)),
LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,a,a)),
LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,a,b)) ];;
NilpotentQuotient(G);
#>[ [ 0, 0 ], [ 0 ], [ 0, 0 ], [ 0, 0 ], [ 0, 0, 0 ], [ 0, 0, 0 ], 
#>  [ 2, 0, 0 ], [ 14, 0 ], [ 14 ], [ 2 ], [ 2 ], [  ] ]

## examples/G4.fp ###########################################################
#G := Group( a, b );;
#G.relators := [
#LeftNormedComm(b,a,a,a,a,a,a,a,a,a),
#LeftNormedComm(b,a,a,a,a,a,a,a,a,b),
#LeftNormedComm(b,a,a,a,a,a,a,a,b,b),
#LeftNormedComm(b,a,a,a,a,a,a,b,b,b),
#LeftNormedComm(b,a,a,a,a,a,b,b,b,b),
#LeftNormedComm(b,a,a,a,a,b,b,b,b,b),
#LeftNormedComm(b,a,a,a,b,b,b,b,b,b),
#LeftNormedComm(b,a,a,b,b,b,b,b,b,b),
#LeftNormedComm(b,a,b,b,b,b,b,b,b,b),
#LeftNormedComm(b,a,a,a,a,a,a,a,Comm(b,a)),
#LeftNormedComm(b,a,a,a,a,a,a,b,Comm(b,a)),
#LeftNormedComm(b,a,a,a,a,a,b,b,Comm(b,a)),
#LeftNormedComm(b,a,a,a,a,b,b,b,Comm(b,a)),
#LeftNormedComm(b,a,a,a,b,b,b,b,Comm(b,a)),
#LeftNormedComm(b,a,a,b,b,b,b,b,Comm(b,a)),
#LeftNormedComm(b,a,b,b,b,b,b,b,Comm(b,a)),
#LeftNormedComm(b,a,a,a,a,a,Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,a,a,a,b,Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,a,a,b,b,Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,a,b,b,b,Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,b,b,b,b,Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,a,a,Comm(b,a),Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,a,b,Comm(b,a),Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,b,b,Comm(b,a),Comm(b,a),Comm(b,a)),
#LeftNormedComm(b,a,a,a,a,a,a,LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,a,a,a,LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,a,a,b,LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,a,a,b,LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,a,b,b,LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,a,b,b,LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,b,b,b,LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,b,b,b,LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,b,b,b,b,LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,b,b,b,b,LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,b,b,b,b,b,LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,b,b,b,b,b,LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,a,Comm(b,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,a,Comm(b,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,b,Comm(b,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,b,Comm(b,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,b,b,Comm(b,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,b,b,Comm(b,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,b,b,b,Comm(b,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,b,b,b,Comm(b,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,Comm(b,a),Comm(b,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,Comm(b,a),Comm(b,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,b,Comm(b,a),Comm(b,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,b,Comm(b,a),Comm(b,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,LeftNormedComm(b,a,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,a,LeftNormedComm(b,a,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,LeftNormedComm(b,a,b),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,b,LeftNormedComm(b,a,b),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,a)),
#LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,b,b,LeftNormedComm(b,a,b),LeftNormedComm(b,a,b)),
#LeftNormedComm(b,a,a,a,a,a,LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,a,a,a,a,LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,a,a,a,a,LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,a,a,a,b,LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,a,a,a,b,LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,a,a,a,b,LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,a,a,b,b,LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,a,a,b,b,LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,a,a,b,b,LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,a,b,b,b,LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,a,b,b,b,LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,a,b,b,b,LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,b,b,b,b,LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,b,b,b,b,LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,b,b,b,b,LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,a,a,Comm(b,a),LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,a,a,Comm(b,a),LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,a,a,Comm(b,a),LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,a,b,Comm(b,a),LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,a,b,Comm(b,a),LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,a,b,Comm(b,a),LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,b,b,Comm(b,a),LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,b,b,Comm(b,a),LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,b,b,Comm(b,a),LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,a,a)),
#LeftNormedComm(b,a,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,a,b)),
#LeftNormedComm(b,a,b,LeftNormedComm(b,a,a),LeftNormedComm(b,a,b,b)),
#LeftNormedComm(b,a,a,a,b,LeftNormedComm(b,a,a,a,a)),
#LeftNormedComm(b,a,a,b,b,LeftNormedComm(b,a,a,a,a)),
#LeftNormedComm(b,a,a,b,b,LeftNormedComm(b,a,a,a,b)),
#LeftNormedComm(b,a,b,b,b,LeftNormedComm(b,a,a,a,a)),
#LeftNormedComm(b,a,b,b,b,LeftNormedComm(b,a,a,a,b)),
#LeftNormedComm(b,a,b,b,b,LeftNormedComm(b,a,a,b,b)),
#LeftNormedComm(b,a,a,Comm(b,a),LeftNormedComm(b,a,a,a,a)),
#LeftNormedComm(b,a,a,Comm(b,a),LeftNormedComm(b,a,a,a,b)),
#LeftNormedComm(b,a,a,Comm(b,a),LeftNormedComm(b,a,a,b,b)),
#LeftNormedComm(b,a,a,Comm(b,a),LeftNormedComm(b,a,b,b,b)),
#LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,a,a,a)),
#LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,a,a,b)),
#LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,a,b,b)),
#LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,b,b,b)),
#LeftNormedComm(b,a,b,Comm(b,a),LeftNormedComm(b,a,a,Comm(b,a))) ];;
#NilpotentQuotient(G);
##>[ [ 0, 0 ], [ 0 ], [ 0, 0 ], [ 0, 0, 0 ], [ 0, 0, 0, 0, 0, 0 ], 
##>  [ 0, 0, 0, 0, 0, 0, 0, 0, 0 ], 
##>  [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ], 
##>  [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
##>      0, 0, 0, 0, 0, 0, 0, 0, 0 ], 
##>  [ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
##>      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
##>      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ], [  ] ]

## examples/G5.fp ###########################################################
G := Group( a, b, c );;
G.relators := [ Comm(c,a), Comm(c,b), Comm(b,a) / c^2 ];;
NilpotentQuotient( G );
#>[ [ 2, 0, 0 ], [ 0 ], [  ] ]

## add timings for the GAP part of the nq-stuff (basically MD) ##############
SizeScreen(sizeScreen);;
Print("nq        3.1   17/12/1992  ",QuoInt(900000000,time)," GAPstones\n");
if IsBound( GAPSTONES )  then Add( GAPSTONES, QuoInt(900000000,time) );  fi;
