#!/bin/sh
#############################################################################
##
#A  xgap                       XGAP source                       Frank Celler
##
#H  @(#)$Id: xgap.sh,v 1.6 1993/10/28 15:02:57 fceller Exp $
##
#Y  Copyright (C) 1993,  Lehrstuhl D fuer Mathematik,  RWTH, Aachen,  Germany
##
#H  $Log: xgap.sh,v $
#H  Revision 1.6  1993/10/28  15:02:57  fceller
#H  change paths
#H
#H  Revision 1.5  1993/10/21  18:19:05  fceller
#H  added hp support
#H
#H  Revision 1.4  1993/10/20  10:39:05  fceller
#H  changed exe names
#H
#H  Revision 1.3  1993/10/18  11:26:13  fceller
#H  avoid shell scripts for gap
#H
#H  Revision 1.2  1993/10/18  10:59:37  fceller
#H  added '-G' option
#H
#H  Revision 1.1  1993/08/18  11:09:48  fceller
#H  Initial revision
##


## $DISPLAY variable must be set ############################################
if [ "x$DISPLAY" = "x" ];  then
  echo 'FATAL: you must set $DISPLAY'
  exit 1;
fi;

## determinate type of server ###############################################
if [ "x$DISPLAY" = "x:0.0" ];  then
  server=`hostname | sed 's/\\..*//'`
else
  server=`basename $DISPLAY :0.0`
fi;

## detrmine host and name of the shell script ###############################
host=`hostname | sed 's/\\..*//'`
script=`basename $0`
spath=`echo $0 | sed "s/\/$script\$//"`
spath=/usd/gap/3.3/pkg/xgap/bin

## construct various fonts ##################################################
case $server  in

  # DecStation running DecWindows
  dang01|dang02)
    FONT="-font -*-courier-bold-r-*-*-14-*-*-*-*-*-*-*
          -tiny -*-*-*-*-*-*-8-*-*-*-*-*-*-*
          -small -*-courier-medium-r-*-*-12-*-*-*-*-*-*-*
          -normal -*-courier-medium-r-*-*-14-*-*-*-*-*-*-*
          -large -*-courier-medium-r-*-*-18-*-*-*-*-*-*-*
          -huge -*-courier-medium-r-*-*-24-*-*-*-*-*-*-*"
    GEO="-geometry 750x800"
    ;;

  # 386BSD running XFree 1.2 on a color screen
  waldorf|stadler|fozzy|gonzo|rowlf)
    FONT="-font -misc-fixed-medium-r-semicondensed--13-100-100-100-c-60-iso8859-1
          -tiny -*-fixed-medium-r-*-*-7-*-*-*-*-*-*-* 
          -small -*-courier-medium-r-*-*-12-*-*-*-*-*-*-*
          -normal -*-courier-medium-r-*-*-14-*-*-*-*-*-*-* 
          -large -*-courier-medium-r-*-*-18-*-*-*-*-*-*-* 
          -huge -*-courier-medium-r-*-*-24-*-*-*-*-*-*-*"
    BG="-bg linen"
    GEO="-geometry 502x680"
    ;;

  # NeXT running MouseX
  bjerun)
    FONT="-font -*-clean-medium-*-*-*-13-*-*-*-*-*-*-*"
    GEO="-geometry 502x720"
    ;;
  *)

esac

## get executable ###########################################################
case $host in
  groover)
    EXEC="$spath/xgap-hp-hppa1.1-hpux"
    LIB="$spath/../lib/;/usd/gap/3.3/lib/"
    DOC="/usd/gap/3.3/doc/"
    GAP="/usd/gap/3.3/bin/gap-hp-hppa1.1-hpux"
    ;;
  dang01|dang02|dangan)
    EXEC="$spath/xgap-dec-mips-ultrix"
    LIB="$spath/../lib/;/tpsoftw/gap/3.3/lib/"
    DOC="/tpsoftw/gap/3.3/doc/"
    GAP="/tpsoftw/gap/3.3/bin/gap-dec-mips-ultrix"
    ;;
  waldorf|stadler|gonzo|fozzy|rowlf)
    EXEC="$spath/xgap-ibm-i386-386bsd"
    LIB="$spath/../lib/;/usd/gap/3.3/lib/"
    DOC="/usd/gap/3.3/doc"
    GAP="/usd/gap/3.3/bin/gap-ibm-i386-386bsd"
    ;;
  ernie|tiffy|samson|bert)
    EXEC="$spath/xgap-dec-mips-ultrix"
    LIB="$spath/../lib/;/usd/gap/3.3/lib/"
    DOC="/usd/gap/3.3/doc"
    GAP="/usd/gap/3.3/bin/gap-dec-mips-ultrix"
    ;;
  bjerun)
    EXEC="$spath/xgap-next-m68k-mach"
    LIB="$spath/..lib/;/home/gap/3.3/lib/"
    DOC="/home/gap/3.3/doc"
    GAP="/usr/local/bin/gap"
    ;;
  *)
    echo "FATAL: no executable for your machine"
    exit 1
    ;;
esac

## parse arguments ##########################################################
FILES=""
MEM="4m"
while [ $# -gt 0 ];  do
  case $1 in
    -G)
      shift
      GAP="$1"
      ;;
    -m)
      shift
      MEM="$1"
      ;;
    -l)
      shift
      LIB="$1"
      ;;
    -h)
      shift
      DOC="$1"
      ;;
    -geometry)
      shift
      GEO="$1"
      ;;
    *)
      FILES="${FILES} $1"
      ;;
  esac
  shift
done

## start xgap ###############################################################
$EXEC $FONT $BG $GEO -G $GAP -l $LIB -h $DOC -m $MEM $FILES &

## and return ###############################################################
exit 0
