#############################################################################
##
#A  menu.g                  	XGAP library                     Frank Celler
##
#H  @(#)$Id: menu.g,v 1.5 1993/10/06 16:19:23 fceller Exp $
##
#Y  Copyright (C) 1993,  Lehrstuhl D fuer Mathematik,  RWTH, Aachen,  Germany
##
##  This files contains the menu and text selector  functions.  The low level
##  window functions are  in "window.g", the high  level window  functions in
##  "sheet.g".
##
##
#H  $Log: menu.g,v $
#H  Revision 1.5  1993/10/06  16:19:23  fceller
#H  added 'isAlive'
#H
#H  Revision 1.4  1993/10/05  12:33:26  fceller
#H  added '.isAlive'
#H
#H  Revision 1.3  1993/08/18  11:27:04  fceller
#H  fixed missing 'FILENAME_DIALOG'
#H
#H  Revision 1.2  1993/08/18  10:59:49  fceller
#H  removed emacs variables
#H
#H  Revision 1.1  1993/07/22  11:24:12  fceller
#H  Initial revision
##


#############################################################################
##
#F  Enable( <obj> ) . . . . . . . . . . . . .  enable an object for selection
##
Enable := function( arg )
    return arg[1].operations.Enable(arg);
end;


#############################################################################
##
#F  Disable( <obj> )  . . . . . . . . . . . . disable an object for selection
##
Disable := function( arg )
    return arg[1].operations.Disable(arg);
end;


#############################################################################
##
#F  Check( <menu>, <entry> )  . . . . . . . . . . . . . . .  check menu entry
##
Check := function( menu, entry )
    return menu.operations.Check( menu, entry );
end;


#############################################################################
##
#F  Query( <obj>, ... ) . . . . . . query a dialog/menu and return the result
##
Query := function( arg )
    return arg[1].operations.Query(arg);
end;


#############################################################################
##
#F  Uncheck( <menu>, <entry> )  . . . . . . . . . . . . .  uncheck menu entry
##
Uncheck := function( menu, entry )
    return menu.operations.Uncheck( menu, entry );
end;


#############################################################################
##

#F  Menu( <sheet>, <title>, <lbs>, <func> ) . . . . . . add a menu to a sheet
##
MenuOps := rec( name := "MenuOps" );

Menu := function( sheet, title, lbs, func )
    local   id,  str,  i,  menu;

    # create a string from <lbs>
    str := "";
    for i  in [ 1 .. Length(lbs)-1 ]  do
    	if IsBound(lbs[i])  then
            Append( str, lbs[i] );
            Append( str, "|" );
    	else
    	    Append( str, "-|" );
        fi;
    od;
    Append( str, lbs[Length(lbs)] );

    # create menu in <sheet>
    menu            := WcAddMenu( sheet, title, str );
    menu.title      := title;
    menu.sheet      := sheet;
    menu.labels     := Copy(lbs);
    menu.entries    := Copy( Filtered( lbs, IsBound ) );
    menu.func       := func;
    menu.operations := MenuOps;

    # return menu
    return menu;
    
end;

MenuOps.Print := function( menu )
    Print( "Menu( ", menu.sheet, ", \"", menu.title, "\", ",
           menu.labels, ", function( S, M, E ) ... end )" );
end;


#############################################################################
##
#F  MenuOps.Enable( <menu>, <entry> ) . . . . . . . . . . . enable menu entry
##
MenuOps.Enable := function( args )
    local   pos;

    pos := Position( args[1].entries, args[2] );
    if pos = false  then
        Error( "unknown menu entry \"", args[2], "\"" );
    fi;
    WcEnableMenu( args[1].sheet.id, args[1].id, pos, 1 );
    WindowCmd([ "XEM", args[1].sheet.id, args[1].id, pos, 1 ]);
    
end;


#############################################################################
##
#F  MenuOps.Disable( <menu>, <entry> )  . . . . . . . . .  disable menu entry
##
MenuOps.Disable := function( args )
    local   pos;

    pos := Position( args[1].entries, args[2] );
    if pos = false  then
        Error( "unknown menu entry \"", args[2], "\"" );
    fi;
    WcEnableMenu( args[1].sheet.id, args[1].id, pos, 0 );
    
end;


#############################################################################
##
#F  MenuOps.Check( <menu>, <entry> )  . . . . . . . . . . .  check menu entry
##
MenuOps.Check := function( menu, entry )
    local   pos;

    pos := Position( menu.entries, entry );
    if pos = false  then
        Error( "unknown menu entry \"", entry, "\"" );
    fi;
    WcCheckMenu( menu.sheet.id, menu.id, pos, 1 );
end;


#############################################################################
##
#F  MenuOps.Uncheck( <menu>, <entry> )  . . . . . . . . .  uncheck menu entry
##
MenuOps.Uncheck := function( menu, entry )
    local   pos;

    pos := Position( menu.entries, entry );
    if pos = false  then
        Error( "unknown menu entry \"", entry, "\"" );
    fi;
    WcCheckMenu( menu.sheet.id, menu.id, pos, 0 );
end;


#############################################################################
##

#F  PopupMenu( <name>, <labels> ) . . . . . . . . . . . . create a popup menu
##
PopupMenuOps := rec( name := "PopupMenuOps" );

PopupMenu := function( title, lbs )
    local   pop,  str,  i,  id;

    # create window command
    str := Copy(lbs[1]);
    for i  in [ 2 .. Length(lbs) ]  do
        Append( str, "|" );
        Append( str, lbs[i] );
    od;

    # construct a popup menu record
    pop            := WcPopupMenu( title, str );
    pop.title      := title;
    pop.entries    := Copy(lbs);
    pop.operations := PopupMenuOps;

    # and return
    return pop;

end;

PopupMenuOps.Print := function( pop )
    local   i;

    Print( "PopupMenu( \"", pop.title, " [ " );
    for i  in [ 1 .. Length(pop.entries) ]  do
        if 1 < i  then Print( ", " );  fi;
    	Print( "\"", pop.entries[i], "\"" );
    od;
    Print( " ] )" );

end;


#############################################################################
##
#F  PopupMenuOps.Query( <pop> ) . . . . . . . . . . . . . .  query popup menu
##
PopupMenuOps.Query := function( args )
    local   res,  w,  win;

    # at least one window must be active
    for w  in WINDOWS  do
        if not IsBound(win)  then
            win := w;
        fi;
    od;
    if not IsBound(win)  then
        Error( "at least one window must be active" );
    fi;

    # make sure that the pointer button is still down
    if WcQueryPointer(win.id)[3] = 0  then
        return false;
    fi;
    
    # show popup shell and query user
    res := WcQueryPopup(args[1].id);
    
    # return 'false' or name of entry
    if res = 0  then
    	return false;
    else
    	return args[1].entries[res];
    fi;

end;


#############################################################################
##

#F  TextSelector( <name>, <list>, <buttons> ) . . . .  create a text selector
##
TextSelectorOps := rec( name := "TextSelectorOps" );

TextSelector := function( name, lbs, bts )
    local   str1,  str2,  sel,  i;
    
    # create label string
    str1 := Copy(lbs[1]);
    for i  in [ 2 .. Length(lbs) ]  do
        Append( str1, "|" );
        Append( str1, lbs[i] );
    od;
    
    # create button string
    str2 := Copy(bts[1]);
    for i  in [ 2 .. Length(bts) ]  do
        Append( str2, "|" );
        Append( str2, bts[i] );
    od;
    
    # create text selector record
    sel            := WcTextSelector( name, str1, str2 );
    sel.title      := Copy(name);
    sel.labels     := Copy(lbs);
    sel.buttons    := Copy(bts);
    sel.isAlive    := true;
    sel.selected   := 0;
    sel.operations := TextSelectorOps;

    # force lables to be real strings
    List( sel.labels, IsString );
    
    # add default actions
    sel.buttonPressed := Ignore;
    sel.textSelected  := Ignore;

    # and return
    return sel;
    
end;

TextSelectorOps.Print := function( sel )
    Print( "TextSelector( \"", sel.title, "\", ", sel.labels, ", ",
           sel.buttons, " )" );
end;


#############################################################################
##
#F  TextSelectorOps.ButtonPressed( <sel>, <bt> )  . . . . button <bt> pressed
##
TextSelectorOps.ButtonPressed := function( sel, bt )
    return sel.buttonPressed( sel, bt );
end;


#############################################################################
##
#F  TextSelectorOps.Close( <sel> )  . . . . . . . . . . . . .  close selector
##
TextSelectorOps.Close := function( sel )
    WcTsClose(sel.id);
    sel.isAlive := false;
end;

TextSelectorOps.Destroy := TextSelectorOps.Close;


#############################################################################
##
#F  TextSelectorOps.Disable( <sel>, <bt> )  . . . . . . . . .  disable button
##
TextSelectorOps.Disable := function( args )
    local   pos;

    pos := Position( args[1].buttons, args[2] );
    if pos = false  then
        Error( "unknown button \"", args[2], "\"" );
    fi;
    WcTsEnable( args[1].id, pos, 0 );
    
end;


#############################################################################
##
#F  TextSelectorOps.Enable( <sel>, <bt> ) . . . . . . . . . . . enable button
##
TextSelectorOps.Enable := function( args )
    local   pos;

    pos := Position( args[1].buttons, args[2] );
    if pos = false  then
        Error( "unknown button \"", args[2], "\"" );
    fi;
    WcTsEnable( args[1].id, pos, 1 );
    
end;


#############################################################################
##
#F  TextSelectorOps.Relabel( <sel>, <text> )  . . . . . . . . .  set new text
##
TextSelectorOps.Relabel := function( sel, text )
    local   str,  i;
    
    str := Copy(text[1]);
    for i  in [ 2 .. Length(text) ]  do
        Append( str, "|" );
        Append( str, text[i] );
    od;
    WcTsChangeText( sel.id, str );
    sel.labels := Copy(text);
    List( sel.labels, IsString );
end;


#############################################################################
##
#F  TextSelectorOps.TextSelected( <sel>, <tid> )  . . . . . . . text selected
##
TextSelectorOps.TextSelected := function( sel, tid )
    sel.selected := tid;
    return sel.textSelected( sel, tid );
end;


#############################################################################
##
#F  TextSelectorOps.Unhighlight( <sel> )  . . . . . . . . . . remove highligh
##
TextSelectorOps.Unhighlight := function( sel )
    WcTsUnhighlight(sel.id);
end;


#############################################################################
##

#F  Dialog( <type>, <text> )  . . . . . . . . . . . . . create a popup dialog
##
DialogOps := rec( name := "DialogOps" );

Dialog := function( type, text )
    local   dial;

    # create a dialog record
    dial            := rec( isDialog := true );
    dial.text       := Copy(text);
    dial.operations := DialogOps;

    # check type
    if type = "OKcancel"  then
    	dial.type   := 1;
        dial.cancel := 1;
    else
    	Error( "unknown type \"", type, "\"" );
    fi;
    dial.typeName := Copy(type);

    # return
    return dial;

end;

DialogOps.Print := function( dial )
    Print( "Dialog( \"", dial.typeName, "\", \"", dial.text, "\")" );
end;

    
#############################################################################
##
#F  DialogOps.Query( <dial>, <def> )  . . . . . . query dialog (with default)
##
DialogOps.Query := function( args )
    local   res,  dial;

    # get dialog
    dial := args[1];
    
    # if we have a default use this
    if 1 < Length(args)  then
        res := WcDialog( dial.type, dial.text, String(args[2]) );
    else
        res := WcDialog( dial.type, dial.text, "" );
    fi;
    
    # return the result
    if res[1] = dial.cancel  then
    	return false;
    else
    	return res[2];
    fi;

end;
    

#############################################################################
##
#V  FILENAME_DIALOG . . . . . . . . . . . . . . a dialog asking for filenames
##
FILENAME_DIALOG := Dialog( "OKcancel", "Enter a filename" );
