#############################################################################
##
#A  window.g                  	XGAP library                     Frank Celler
##
#H  @(#)$Id: window.g,v 1.5 1993/10/18 11:06:14 fceller Exp $
##
#Y  Copyright (C) 1993,  Lehrstuhl D fuer Mathematik,  RWTH, Aachen,  Germany
##
##  This files contains  the  low  level window   functions, the  high  level
##  functions are in "sheet.g".  The menu functions are in "menu.g".
##
#H  $Log: window.g,v $
#H  Revision 1.5  1993/10/18  11:06:14  fceller
#H  added fast updated
#H
#H  Revision 1.4  1993/10/05  12:33:26  fceller
#H  added '.isAlive'
#H
#H  Revision 1.4  1993/10/05  12:33:26  fceller
#H  added '.isAlive'
#H
#H  Revision 1.3  1993/08/18  10:59:49  fceller
#H  removed emacs variables
#H
#H  Revision 1.2  1993/07/22  11:24:32  fceller
#H  split files into three: "window.g", "sheet.g", "menu.g"
#H
#H  Revision 1.1  1993/07/21  12:32:42  fceller
#H  Initial revision
##


#############################################################################
##
#V  WINDOWS . . . . . . . . . . . . . .  list of gap garphic sheets, internal
##
#if not IsBound(WINDOWS)  then WINDOWS := [];  fi;


#############################################################################
##
#V  SELECTORS . . . . . . . . . . . . . . .  list of text selectors, internal
##
#if not IsBound(SELECTORS)  then SELECTORS := [];  fi;


#############################################################################
##
#V  TINY_FONT . . . . . . . . . . . . . . . . . . . . dimensions of tiny font
##
TINY_FONT := WindowCmd([ "XFI", 1 ]);


#############################################################################
##
#V  SMALL_FONT	. . . . . . . . . . . . . . . . . .  dimensions of small font
##
SMALL_FONT := WindowCmd([ "XFI", 2 ]);


#############################################################################
##
#V  NORMAL_FONT	. . . . . . . . . . . . . . . . . . dimensions of normal font
##
NORMAL_FONT := WindowCmd([ "XFI", 3 ]);


#############################################################################
##
#V  LARGE_FONT	. . . . . . . . . . . . . . . . . .  dimensions of large font
##
LARGE_FONT := WindowCmd([ "XFI", 4 ]);


#############################################################################
##
#V  HUGE_FONT . . . . . . . . . . . . . . . . . . . . dimensions of huge font
##
HUGE_FONT := WindowCmd([ "XFI", 5 ]);


#############################################################################
##
#V  FONTS . . . . . . . . . . . . . . . . . . . . . . . . . . font dimensions
##
FONTS := [ TINY_FONT, SMALL_FONT, NORMAL_FONT, LARGE_FONT, HUGE_FONT ];


#############################################################################
##
#V  LP_BUTTON . . . . . . . . . . . . . . . . . . . . . . left pointer button
##
LP_BUTTON := 1;


#############################################################################
##
#V  RP_BUTTON . . . . . . . . . . . . . . . . . . . . .  right pointer button
##
RP_BUTTON := 2;


#############################################################################
##

#F  PointerButtonDown( <wid>, <x>, <y>, <bt> )  . . . . button down, internal
##
PointerButtonDown := function( wid, x, y, bt )
    local    win;

    win := WINDOWS[wid+1];
    if bt = 1 then
        return win.operations.LeftPointerButtonDown( win, x, y );
    else
        return win.operations.RightPointerButtonDown( win, x, y );
    fi;
    
end;


#############################################################################
##
#F  MenuSelected( <wid>, <mid>, <eid> ) . . . . . . . menu selector, internal
##
MenuSelected := function( wid, mid, eid )
    local   menu;
    
    menu := WINDOWS[wid+1].menus[mid+1];
    return menu.func( WINDOWS[wid+1], menu, menu.entries[eid] );
    
end;


#############################################################################
##
#F  ButtonSelected( <sid>, <bid> )  . . . . . . . . button selected, internal
##
ButtonSelected := function( sid, bid )
    local   sel;
    
    sel := SELECTORS[sid+1];
    return sel.operations.ButtonPressed( sel, sel.buttons[bid] );
end;


#############################################################################
##
#F  TextSelected( <sid>, <tid> )  . . . . . . . . . . text selected, internal
##
TextSelected := function( sid, tid )
    local   sel;
    
    sel := SELECTORS[sid+1];
    return sel.operations.TextSelected( sel, tid );
end;


#############################################################################
##
#F  Drag( <sheet>, <x>, <y>, <bt>, <func> ) . . . . . . . . .  drag something
##
Drag := function( sheet, x, y, bt, func )
    local   tmp;
    
    # wait for a small movement
    repeat
        tmp := WindowCmd([ "XQP", sheet.id ]);
        if tmp[3] <> bt  then return false;  fi;
    until 5 < AbsInt(x-tmp[1]) or 5 < AbsInt(y-tmp[2]);
    
    # now start dragging
    while true  do
        tmp := WindowCmd([ "XQP", sheet.id ]);
        if tmp[3] <> bt  then return true;  fi;
        if tmp[1] = -1  then tmp[1] := x;  fi;
        if tmp[2] = -1  then tmp[2] := y;  fi;
        if tmp[1] <> x or tmp[2] <> y  then
            func( tmp[1], tmp[2] );
            x := tmp[1];
            y := tmp[2];
        fi;
    od;
    
end;


#############################################################################
##

#F  WcAddMenu( <win>, <title>, <str> )  . . . . . . .  add a menu to a window
##
WcAddMenu := function( win, title, str )
    local   id;

    id := WindowCmd([ "XME", win.id, title, str ])[1];
    win.menus[id+1] := rec( id := id, isMenu := true );
    return win.menus[id+1];
end;


#############################################################################
##
#F  WcCheckMenu( <wid>, <mid>, <pos>, <flag> )  . .  check/uncheck menu entry
##
WcCheckMenu := function( wid, mid, pos, flag )
    WindowCmd([ "XCM", wid, mid, pos, flag ]);
end;


#############################################################################
##
#F  WcCloseWindow( <id> ) . . . . . . . . . . . . . . . . . . .  close window
##
WcCloseWindow := function( id )
    Unbind(WINDOWS[id+1]);
    WindowCmd([ "XCW", id  ]);
end;


#############################################################################
##
#F  WcDestroy( <id>, <obj> )  . . . . . . . . . . destroy <obj> on sheet <id>
##
WcDestroy := function( arg )
    local   cmd;

    cmd := Concatenation( ["XRO"], arg );
    WindowCmd(cmd);
    
end;


#############################################################################
##
#F  WcDialog( <type>, <text>, <def> ) . . . . . . . . . . . . . . . .  dialog
##
WcDialog := function( type, text, def )
    return WindowCmd([ "XSD", type, text, def ]);
end;

#############################################################################
##
#F  WcDrawBox( <id>, <x1>, <y1>, <x2>, <y2> ) . . . . . . . . . .  draw a box
##
WcDrawBox := function( id, x1, y1, x2, y2 )
    return WindowCmd([ "XDB", id, x1, y1, x2, y2 ])[1];
end;


#############################################################################
##
#F  WcDrawCircle( <id>, <x>, <y>, <r> )	. . . . . . . . . . . . draw a circle
##
WcDrawCircle := function( id, x, y, r )
    return WindowCmd([ "XDC", id, x, y, r ])[1];
end;


#############################################################################
##
#F  WcDrawDisc( <id>, <x>, <y>, <r> ) . . . . . . . . . . . . . . draw a disc
##
WcDrawDisc := function( id, x, y, r )
    return WindowCmd([ "XDD", id, x, y, r ])[1];
end;


#############################################################################
##
#F  WcDrawLine( <id>, <x1>, <y1>, <x2>, <y2> )  . . . . . . . . . draw a line
##
WcDrawLine := function( id, x1, y1, x2, y2 )
    return WindowCmd([ "XDL", id, x1, y1, x2, y2 ])[1];
end;


#############################################################################
##
#F  WcDrawText( <id>, <fid>, <x>, <y>, <str> )	. . . . . . . . . draw a text
##
WcDrawText := function( id, fid, x, y, str )
    return WindowCmd([ "XDT", id, fid, x, y, str ])[1];
end;


#############################################################################
##
#F  WcEnableMenu( <wid>, <mid>, <pos>, <flag> ) . . . . en/disable menu entry
##
WcEnableMenu := function( wid, mid, pos, flag )
    WindowCmd([ "XEM", wid, mid, pos, flag ]);
end;


#############################################################################
##
#F  WcFastUpdate( <wid>, <flag> ) . . . . . . . . . .  en/disable fast update
##
WcFastUpdate := function( wid, flag )
    if flag  then
        WindowCmd([ "XFU", wid, 1 ]);
    else
        WindowCmd([ "XFU", wid, 0 ]);
    fi;
end;


#############################################################################
##
#F  WcOpenWindow( <name>, <width>, <height> ) . . . . . . . . . . open window
##
WcOpenWindow := function( name, width, height )
    local   id,  win;
    
    id  := WindowCmd([ "XOW", name, width, height ])[1];
    win := rec( id := id, isWindow := true, menus := [] );
    WINDOWS[id+1] := win;
    return win;

end;


#############################################################################
##
#F  WcPopupMenu( <title>, <str> ) . . . . . . . . . . . . create a popup menu
##
WcPopupMenu := function( title, str )
    local   pop;
    
    pop    := rec( isPopupMenu := true );
    pop.id := WindowCmd([ "XPS", title, str ])[1];
    return pop;
end;


#############################################################################
##
#F  WcQueryPointer( <id> )  . . . . . . . . . . . . . . . . . . query pointer
##
WcQueryPointer := function( id )
    return WindowCmd([ "XQP", id ]);
end;


#############################################################################
##
#F  WcQueryPopup( <id> )  . . . . . . . . . . . . . . . . .  query popup menu
##
WcQueryPopup := function( id )
    return WindowCmd([ "XSP", id ])[1];
end;


#############################################################################
##
#F  WcResizeWindow( <id>, <width>, <height> ) . . . . . . . . . resize window
##
WcResizeWindow := function( id, width, height )
    WindowCmd([ "XRE", id, width, height ]);
end;


#############################################################################
##
#F  WcSetLineWidth( <id>, <w> ) . . . . . . . . . . . . . . .  set line width
##
WcSetLineWidth := function( id, w )
    WindowCmd([ "XLW", id, w ]);
end;


#############################################################################
##
#F  WcSetTitle( <id>, <text> )  . . . . . . . . . . . . . .  set window title
##
WcSetTitle := function( id, text )
    WindowCmd([ "XAT", id, text ]);
end;


#############################################################################
##

#F  WcTextSelector( <name>, <text>, <btn> ) . . . . .  create a text selector
##
WcTextSelector := function( name, text, btn )
    local   sel;
    
    # create text selector
    sel    := rec( isTextSelector := true );
    sel.id := WindowCmd([ "XOS", name, text, btn ])[1];

    # add selector to list of selectors
    SELECTORS[sel.id+1] := sel;

    # and return
    return sel;

end;


#############################################################################
##
#F  WcTsChangeText( <id>, <str> ) . . . . . . .  change text of text selector
##
WcTsChangeText := function( id, str )
    WindowCmd([ "XCL", id, str ]);
end;


#############################################################################
##
#F  WcTsClose( <id> ) . . . . . . . . . . . . . . . . . . close text selector
##
WcTsClose := function( id )
    WindowCmd([ "XCS", id ]);
    Unbind(SELECTORS[id+1]);
end;


#############################################################################
##
#F  WcTsEnable( <id>, <pos>, <flag> ) . . . .  enable button in text selector
##
WcTsEnable := function( id, pos, flag )
    WindowCmd([ "XEB", id, pos, flag ]);
end;


#############################################################################
##
#F  WcTsUnhighlight( <id> ) . . . . . . . . remove highlight in text selector
##
WcTsUnhighlight := function(id)
   WindowCmd([ "XUS", id ]);
end;
