/****************************************************************************
**
*A  utils.c                     XGAP Source                      Frank Celler
**
*H  @(#)$Id: utils.c,v 1.2 1993/10/18 11:04:47 fceller Exp $
**
*Y  Copyright 1993-1995,   Frank Celler,   Lehrstuhl D fuer Mathematik,  RWTH
**
*H  $Log: utils.c,v $
*H  Revision 1.2  1993/10/18  11:04:47  fceller
*H  added fast updated,  fixed timing problem
*H
*H  Revision 1.1  1993/04/13  07:16:39  fceller
*H  added 'SYS_HAS_STDARG
*H
*H  Revision 1.0  1993/04/05  11:42:18  fceller
*H  Initial revision
*H
*/
#include    <stdlib.h>
#include    <stdio.h>
#include    <stdlib.h>
#ifdef      SYS_HAS_STDARG
#include    <stdarg.h>
#endif
#include    <X11/Intrinsic.h>

#define     _utils_c
#include    "utils.h"


/****************************************************************************
**
*V  Debug . . . . . . . . . . . . . . . . . . . . . . . . . . .  debug on/off
*/
int Debug = 0;


/****************************************************************************
**
*F  EnterPointer( <file>, <line>, <ptr> ) . . . . .  trage <ptr> in Liste ein
*/
#if defined(MALLOC_DEBUG_ON) || defined(X11_MALLOC_DEBUG_ON)
static int ListLen = 0;
static int ListSize = 0;
static void ** PtrList = 0;
static char ** FileList = 0;
static int * LineList = 0;

static void EnterPointer ( char * file,  int line,  void * ptr )
{
    if ( ListLen == ListSize )
    {
        ListSize = 2*ListSize + 10;
        PtrList  = realloc( PtrList,  ListSize * sizeof(void*) );
        FileList = realloc( FileList, ListSize * sizeof(char*) );
        LineList = realloc( LineList, ListSize * sizeof(int) );
    }
    PtrList [ListLen] = ptr;
    FileList[ListLen] = file;
    LineList[ListLen] = line;
    ListLen++;
}
#endif


/****************************************************************************
**
*F  FreePointer( <file>, <line>, <ptr> )  . . . . . .  trage <ptr> wieder aus
*/
#if defined(MALLOC_DEBUG_ON) || defined(X11_MALLOC_DEBUG_ON)
static void FreePointer ( char * file,  int line,  void * ptr )
{
    int i;

    for ( i = 0;  i < ListLen;  i++ )
        if ( PtrList[i] == ptr )
            break;
    if ( i == ListLen )
        fprintf( stderr, "MALLOC: unknown 'free(%p)' in %04d:%s\n",
                 ptr, line, file );
    else
        PtrList[i] = 0;
}
#endif


/****************************************************************************
**
*F  TraceCall( <format>, <args> ) . . . . . . . . . . . . . .  gebe Infos aus
*/
#if defined(MALLOC_DEBUG_ON) || defined(X11_MALLOC_DEBUG_ON)
static void TraceCall ( char * format,  ... )
{
    static short    trace = -1;
    va_list         args;

    if ( trace == -1 )
        trace = ( getenv( "MALLOC_TRACE" ) != NULL );
    if ( trace )
    {
        va_start( args, format );
        vfprintf( stderr, format, args );
    }
}
#endif


/****************************************************************************
**
*F  FCmalloc_check_free() . . . . . . . . . . ueberpruefe malloc/free Aufrufe
*/
#if defined(MALLOC_DEBUG_ON) || defined(X11_MALLOC_DEBUG_ON)
void FCmalloc_check_free ( void )
{
    int i;

    for ( i = 0;  i < ListLen;  i++ )
        if ( PtrList[i] != 0 )
            fprintf( stderr, "MALLOC: unfreed '%p' in %04d:%s\n",
                     PtrList[i], LineList[i], FileList[i] );
    free( PtrList );
    free( LineList );
    free( FileList );
    ListLen = ListSize = 0;
    fprintf( stderr, "MALLOC: malloc check finished\n" );
}
#endif


/****************************************************************************
**
*F  FCmalloc( <file>, <line>, <size> )  . . . . . . . . . . . . hole Speicher
*/
#ifdef MALLOC_DEBUG_ON
void * FCmalloc ( char * file,  int line,  size_t size )
{
    void     * ptr;

    ptr = malloc( size );
    EnterPointer( file, line, ptr );
    TraceCall( "%04d:%s:%p=malloc(%lu)\n", line, file, ptr, size );
    return ptr;
}
#endif


/****************************************************************************
**
*F  FCxtmalloc( <file>, <line>, <size> )  . . . . . . . . . . . hole Speicher
*/
#ifdef X11_MALLOC_DEBUG_ON
void * FCxtmalloc ( char * file,  int line,  size_t size )
{
    void     * ptr;

    ptr = XtMalloc( size );
    EnterPointer( file, line, ptr );
    TraceCall( "%04d:%s:%p=XtMalloc(%lu)\n", line, file, ptr, size );
    return ptr;
}
#endif


/****************************************************************************
**
*F  FCfree( <file>, <line>, <ptr> ) . . . . . . . . . . .  gibt Speicher frei
*/
#ifdef MALLOC_DEBUG_ON
void FCfree ( char * file,  int line,  void * ptr )
{
    if ( ptr == 0 )
    {
        fprintf( stderr, "MALLOC: 'free(0)' in %04d:%s\n", line, file );
        return;
    }
    free(ptr);
    FreePointer( file, line, ptr );
    TraceCall( "%04d:%s:free(%p)\n", line, file, ptr );
}
#endif


/****************************************************************************
**
*F  FCxtfree( <file>, <line>, <ptr> ) . . . . . . . . . .  gibt Speicher frei
*/
#ifdef X11_MALLOC_DEBUG_ON
void FCxtfree ( char * file,  int line,  void * ptr )
{
    if ( ptr == 0 )
    {
        fprintf( stderr, "MALLOC: 'free(0)' in %04d:%s\n", line, file );
        return;
    }
    XtFree(ptr);
    FreePointer( file, line, ptr );
    TraceCall( "%04d:%s:XtFree(%p)\n", line, file, ptr );
}
#endif


/****************************************************************************
**
*F  FCrealloc( <file>, <line>, <old>, <size> )  . . . .  vergroesser Speicher
*/
#ifdef MALLOC_DEBUG_ON
void * FCrealloc ( char * file,  int line,  void * old,  size_t size )
{
    void * new;

    new = realloc( old, size );
    FreePointer( file, line, old );
    EnterPointer( file, line, new );
    TraceCall( "%04d:%s:%p=realloc(%p,%lu)\n", line, file, new, old, size );
    return new;
}
#endif


/****************************************************************************
**
*F  FCxtrealloc( <file>, <line>, <old>, <size> )  . . .  vergroesser Speicher
*/
#ifdef X11_MALLOC_DEBUG_ON
void * FCxtrealloc ( char * file,  int line,  void * old,  size_t size )
{
    void * new;

    new = XtRealloc( old, size );
    FreePointer( file, line, old );
    EnterPointer( file, line, new );
    TraceCall("%04d:%s:%p=XtRealloc(%p,%lu)\n", line, file, new, old, size);
    return new;
}
#endif


/****************************************************************************
**

*F  List( <len> )   . . . . . . . . . . . . . . . . . . .   create a new list
*/
#if defined(X11_MALLOC_DEBUG_ON)
TypeList FClist ( file,  line,  len )
    char      * file;
    int         line;
    int         len;
{
    TypeList    list;

    /* <len> must not be negative */
    if ( len < 0 )
	len = 0;

    /* get memory for new list */
    list       = FCxtmalloc( file, line, sizeof( struct _list ) );
    list->len  = len;
    list->size = len+10;
    list->ptr  = FCxtmalloc( file, line, list->size * sizeof(void*) );

    /* return the new list */
    TraceCall("%04d:%s:%p=List(%d)\n", line, file, list, len );
    return list;
}
#else
TypeList List ( len )
    int         len;
{
    TypeList    list;

    /* <len> must not be negative */
    if ( len < 0 )
	len = 0;

    /* get memory for new list */
    list = (TypeList) XtMalloc( sizeof( struct _list ) );
    list->len  = len;
    list->size = len+10;
    list->ptr  = (void*) XtMalloc( list->size * sizeof(void*) );

    /* return the new list */
    DEBUG(( "List(%d)=%p\n", len, (void*)list ))
    return list;
}
#endif


/****************************************************************************
**
*F  AddList( <lst>, <elm> ) . . . . . . . .  add list element <elm> to <list>
*/
void AddList ( lst, elm )
    TypeList  	lst;
    void      * elm;
{
    /* resize <lst> if necessary */
    DEBUG(( "AddList( %p, %p )\n", (void*) lst, (void*) elm ))
    if ( lst->len == lst->size )
    {
        lst->size = lst->size*4/3 + 5;
        lst->ptr  = (void*) XtRealloc( (char*) lst->ptr,
				       lst->size * sizeof(void*) );
    }

    /* and add list element */
    lst->ptr[lst->len++] = elm;
}
