#! /bin/sh
# Copyright (c) 1990-1994 The MITRE Corporation
# 
# Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
#   
# The MITRE Corporation (MITRE) provides this software to you without
# charge to use, copy, modify or enhance for any legitimate purpose
# provided you reproduce MITRE's copyright notice in any copy or
# derivative work of this software.
# 
# This software is the copyright work of MITRE.  No ownership or other
# proprietary interest in this software is granted you other than what
# is granted in this license.
# 
# Any modification or enhancement of this software must identify the
# part of this software that was modified, by whom and when, and must
# inherit this license including its warranty disclaimers.
# 
# MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
# OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
# OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
# FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
# SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGES.
# 
# You, at your expense, hereby indemnify and hold harmless MITRE, its
# Board of Trustees, officers, agents and employees, from any and all
# liability or damages to third parties, including attorneys' fees,
# court costs, and other related costs and expenses, arising out of your
# use of this software irrespective of the cause of said liability.
# 
# The export from the United States or the subsequent reexport of this
# software is subject to compliance with United States export control
# and munitions control restrictions.  You agree that in the event you
# seek to export this software or any derivative work thereof, you
# assume full responsibility for obtaining all necessary export licenses
# and approvals and for assuring compliance with applicable reexport
# restrictions.
# 
# 
# COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994




#! /bin/sh
## Tests IMPS system.

IMPS=${IMPS-`pwd`};			export IMPS
PATH=$PATH:$IMPS/../bin:$IMPS/../bin/`arch`;	export PATH
IMPS_TMP=/tmp;				export IMPS_TMP
THEORIES=$IMPS/theories;		export THEORIES
GENERIC_THEORIES=$THEORIES/generic-theories;	export GENERIC_THEORIES
REALS=$THEORIES/reals;			export REALS
GROUPS=$THEORIES/groups;  		export GROUPS
METRIC_SPACES=$THEORIES/metric-spaces;  export METRIC_SPACES
ALGEBRA=$THEORIES/algebra;              export ALGEBRA
PARTIAL_ORDERS=$THEORIES/partial-orders; export PARTIAL_ORDERS
NORMED_SPACES=$THEORIES/normed-spaces ; export NORMED_SPACES
CARDINALITY=$THEORIES/cardinality      ;export CARDINALITY

logfile=$2
testfile=$1

if test -f $2
   then echo -n "File $2 already exists. Test aborted."
        exit 1
fi

output=/dev/null

export testfile
export logfile 

if test -f $testfile
  then echo Starting IMPS test on `/bin/hostname` ...
  else 
    echo test file $testfile does not exist
    exit 1
fi

if test ! "$EXECUTABLE"
   then EXECUTABLE=$IMPS/../executables/foundation
        echo "Dump = $EXECUTABLE"
fi

if test -f $logfile
 then 
   mv $logfile $logfile.prev
fi

#$IMPS/../bin/shell_server

echo HOST `/bin/hostname` starting IMPS test.  >> $logfile
echo File tested = $testfile  >> $logfile
echo Executable = $EXECUTABLE >> $logfile

date >> $logfile

$EXECUTABLE -h  28000000 < $IMPS/../src/test_imps_script.t 

date >> $logfile

echo IMPS test completed. >> $logfile

