#! /bin/sh
# Copyright (c) 1990-1994 The MITRE Corporation
# 
# Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
#   
# The MITRE Corporation (MITRE) provides this software to you without
# charge to use, copy, modify or enhance for any legitimate purpose
# provided you reproduce MITRE's copyright notice in any copy or
# derivative work of this software.
# 
# This software is the copyright work of MITRE.  No ownership or other
# proprietary interest in this software is granted you other than what
# is granted in this license.
# 
# Any modification or enhancement of this software must identify the
# part of this software that was modified, by whom and when, and must
# inherit this license including its warranty disclaimers.
# 
# MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
# OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
# OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
# FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
# SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGES.
# 
# You, at your expense, hereby indemnify and hold harmless MITRE, its
# Board of Trustees, officers, agents and employees, from any and all
# liability or damages to third parties, including attorneys' fees,
# court costs, and other related costs and expenses, arising out of your
# use of this software irrespective of the cause of said liability.
# 
# The export from the United States or the subsequent reexport of this
# software is subject to compliance with United States export control
# and munitions control restrictions.  You agree that in the event you
# seek to export this software or any derivative work thereof, you
# assume full responsibility for obtaining all necessary export licenses
# and approvals and for assuring compliance with applicable reexport
# restrictions.
# 
# 
# COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



#! /bin/sh

IMPS=/usr/src/local2/imps/sys/tea
IMPS_EMACS=emacs

#IMPS_EMACS=/afs/rcf/src/local/gnu/lemacs/lemacs-19.4/lemacs-19.6/src/lemacs

export IMPS; export IMPS_EMACS


PATH=$PATH:$IMPS/../bin:$IMPS/../bin/`arch`;	export PATH
IMPS_TMP=/tmp;					export IMPS_TMP
EXPRESSIONS=$IMPS/expressions;			export EXPRESSIONS
PRESENTATION=$IMPS/presentation;		export PRESENTATION
SUBSTITUTION=$IMPS/substitution;		export SUBSTITUTION
INFERENCES=$IMPS/inferences;			export INFERENCES
THEORIES=$IMPS/theories;			export THEORIES
GENERIC_THEORIES=$THEORIES/generic-theories;	export GENERIC_THEORIES
THEORY_MECHANISM=$IMPS/theory-mechanism 	export THEORY_MECHANISM
TRANSLATIONS=$IMPS/translations;		export TRANSLATIONS
THEORY_INFERENCE=$IMPS/theory-inference;	export THEORY_INFERENCE
REALS=$THEORIES/reals;				export REALS
RESOURCES=$IMPS/resources;			export RESOURCES
GROUPS=$THEORIES/groups;  			export GROUPS
METRIC_SPACES=$THEORIES/metric-spaces;  	export METRIC_SPACES
ALGEBRA=$THEORIES/algebra;              	export ALGEBRA


if test ! "$EMACS_COMMAND"
   then if test "$DISPLAY"
           then EMACS_COMMAND="$IMPS_EMACS -geometry 80x50+250+20"
           else EMACS_COMMAND=$IMPS_EMACS
        fi
fi

if test ! -d ${HOME}/imps -o  ! -d ${HOME}/imps/theories
   then echo '    Creating missing IMPS directories under your home directory.'
fi


if test ! -d ${HOME}/imps
   then echo  "    Creating directory ${HOME}/imps."
        mkdir ${HOME}/imps
fi

if test -d ${HOME}/imps -a ! -d ${HOME}/imps/theories
   then echo  "    Creating directory ${HOME}/imps/theories."
         mkdir ${HOME}/imps/theories
fi


if test sun4 = `arch`
   then exec $EMACS_COMMAND  -q -l $IMPS/../el/start-imps.el
   else echo "Please re-execute on a Sun 4."
fi



