;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



(herald imps)


;;; Before loading IMPS, you will need the following (UNIX) environment 
;;; variables:  
;;;     
;;;	setenv IMPS /usr/local/src/imps/sys/tea
;;;	setenv EXPRESSIONS $IMPS/expressions
;;;	setenv PRESENTATION $IMPS/presentation
;;;	setenv SUBSTITUTION $IMPS/substitution
;;;	setenv INFERENCES $IMPS/inferences
;;;	setenv THEORY_MECHANISM $IMPS/theory-mechanism
;;;	setenv THEORY_INFERENCE $IMPS/theory-inference
;;;     setenv TRANSLATIONS $IMPS/translations
;;;	setenv THEORIES $IMPS/theories
;;;	setenv REALS $THEORIES/reals
;;;     setenv GENERIC_THEORIES $THEORIES/generic-theories
;;;     setenv MISC_EXAMPLES $IMPS/misc-examples
;;;	setenv RESOURCES $IMPS/resources
;;;     setenv SEMANTICS $THEORIES/denotational-semantics
;;;
;;; Also useful are:  
;;;  
;;;    setenv TSYSTEM /usr/local/lib/tsystem
;;;    setenv TSOURCES $TSYSTEM/sources
;;;
;;; to use the emacs stuff, put one or both of the following in your .emacs:
;;; 
;;; (autoload 'run-imps
;;;   (expand-file-name (substitute-in-file-name "$IMPS/../el/pre-imps")) "" t)
;;; 
;;; (autoload 'run-imps-maybe
;;;   (expand-file-name (substitute-in-file-name "$IMPS/../el/pre-imps"))
;;;   "Run imps with prefix argument, but run tea $IMPS/imps only otherwise."
;;;   t)
;;;   


(with-open-ports ((start (open '(imps copyright-start) 'in)))
  (display (read start) (standard-output))
  repl-wont-print)


(lset *imps-files*
      '((imps def-forms)
	(imps other-forms)
	(expressions sortings)
	(expressions expressions)
	(expressions constructors)
	(expressions quasi-constructors)
	(expressions innards-for-constructors)
	(expressions innards-for-languages)
	(expressions languages)
	(substitution substitutions)
	(substitution substitution-application)
	(substitution alpha-equivalence)
;;;	(substitution simple-jaffar-unification)
;;;	(substitution safe-relative-constructors)
	(substitution naive-matching)
	(substitution sort-substitutions)
	(substitution variable-sorts-matching)
	(expressions some-constructors)
	(expressions some-quasi-constructors)
	(expressions gently)
	(expressions quasi-sorts)
	(expressions schemata-for-quasi-constructors)
	(expressions virtual-paths)
	(presentation read-print)
	(theory_mechanism domain-range)	
	(theory_mechanism definitions)	
	(theory_mechanism recursive-definitions)
	(theory_mechanism sort-definitions)
	(theory_mechanism mc-extensions)
      	(theory_mechanism sort-constructors)
	(theory_mechanism history)
	(theory_mechanism theorem)	
;;	(theory_mechanism convergence-requirements)
	(theory_mechanism restricted-substitution-definedness)
	(theory_mechanism transforms)
	(theory_mechanism theory-transform-interface)
	(theory_mechanism rewrite-rules)
	(theory_mechanism transportable-rewrite-rules)
;;	(theory_mechanism theory-contexts)
	(theory_mechanism elementary-macetes)
	(theory_mechanism transportable-macetes)
	(theory_mechanism theory-subsorting)
	(theory_mechanism theory)
	(theory_mechanism theory-ensembles)
	(theory_mechanism record-theories)
	(theory_mechanism sections)
	(inferences q-classes)
	(inferences context-sequent)			
	(inferences context-entailment)
	(inferences syllogistic-inference)
	(inferences backchain)
;;	(inferences tautology)
	(inferences rules)
	(inferences deduction-graphs)
;;	(inferences proof-graphs)
	(inferences constructor-inferences)
	(inferences special-rules)
	(inferences domain-range-inference)
	(inferences domain-range-rules)
	(inferences commands)
	(inferences dg-primitive-inferences)
	(inferences dg-inferences-interface)
	(inferences relative-position)
	(inferences scripts)
	(presentation dg-emacs)
	(presentation theory-emacs)
	(presentation read-interface)
	(presentation parse)
	(presentation presentation-interface)
	(presentation print)
	(presentation tex-print-methods)
	(presentation xtv-interface)
	(presentation tex-prescriptive-presentation)
	(presentation sexp-print)
	(presentation sexp-syntax)
	(presentation overloading)
	(presentation macete-help)
;;	(presentation fp-print)
;;	(presentation fp-syntax)
	(theory_inference algebraic)
	(theory_inference expand)
	(theory_inference reductions)
	(theory_inference order)
	(theory_inference feasible)
	(theory_inference context-inequalities)
	(theory_inference equality)
	(theory_inference macetes)
	(theory_inference macete-constructors)
	(theory_mechanism the-kernel-theory)
		
;;	(theory_inference simplex-tactic)		;+q (part of IMPS share)
	
	(theory_inference general-macetes)
;;	(theory_inference strategies)
	(theory_inference instantiation-strategies)
	(theory_inference existential-matching)
	(theory_inference general-strategies)
;;	(theory_inference substitutions-at-virtual-occurrences)
	(theory_inference unfolding-strategies)
	(theory_inference induction-strategies)
	;;
	;; (theory_inference fixpoint-induction)
	;;
	(theory_inference strategy-combining-forms)
	(theory_mechanism bnf) 
	(translations translations)
        (translations obligations)
	(translations translation-builders)
	(translations transportations)
	(translations translation-match)
	(translations language-transportation)
	(translations theory-transportation)

	(presentation imps-commands)
	(presentation imps-special-commands)
	(presentation indicator-parse-print)
	(presentation sequence-parse-print)
	(presentation command-display)
	(presentation imps-schemeweb)
	(theories some-sections)

;;;	(reals reals)
;;;
;;;	(reals some-lemmas)
;;; 	(reals some-elementary-macetes)
;;; 	(reals arithmetic-macetes)
;;;	(reals reals-supplements)
;;;	(reals number-theory)
;;; 	(reals arithmetic-strategies)
;;;;; 	(reals some-formulas)
;;; 	(generic_theories pure-generic-theories)
;;;	(generic_theories iota)
;;;	(generic_theories generic-theories)
;;;	(generic_theories indicators)
;;;	(generic_theories indicator-lemmas)
;;;	(generic_theories mappings)
;;;	(generic_theories mapping-lemmas)
;;;	(generic_theories inverse-lemmas)
;;;;;	(generic_theories sequences)

	))


;;;(lset *stable-imps-files* '())
;;;
;;;(define (unstable-imps-files)
;;;  (let ((all *imps-files*)
;;;	(stable *stable-imps-files*))
;;;    (iterate iter ((unstable nil)
;;;		   (remaining all))
;;;      (cond ((null? remaining)(reverse unstable))
;;;	    ((mem? equal? (car remaining) stable) (iter unstable (cdr remaining)))
;;;	    (else (iter (cons (car remaining) unstable)
;;;			(cdr remaining)))))))

(*require nil '(resources emacs-buffers) imps-implementation-env)
(*require nil '(imps def-forms) user-env)
(*require nil '(imps other-forms) user-env)
(*require nil '(resources lisp-supplements) user-env)
(*require nil '(resources sets) user-env)

(define system-signal-error (*value t-implementation-env 'signal-error))

(define imps-signal-error-procedure
  (make-simple-switch
   'signal-error-procedure
   procedure?
   (lambda (error-type f-string f-args)
     (if (emacs-process-filter?)
	 (emacs-error (apply format '#f f-string f-args)))
     (system-signal-error error-type f-string f-args))))

(*define t-implementation-env 'signal-error
 (lambda (error-type f-string f-args)
   ((imps-signal-error-procedure) error-type f-string f-args)))

(define imps-error-continuation
  (make-simple-switch 'imps-error-continuation procedure? identity))

(define imps-error error)

(define (imps-user-error format-string . args)
  (let ((string (apply format '#f format-string args)))
    (if (emacs-process-filter?)
	(emacs-error string))
    (error string)))

(define (imps-error-or-return-false error-kind format-string . args)
  (cond ((eq? error-kind 'return-error)
	 (apply imps-error format-string args))
	((eq? error-kind 'return-false)
	 '#f)
	(else
	 (imps-error "IMPS-ERROR-OR-RETURN-FALSE: bad error kind: ~S." error-kind))))

(define (maybe-imps-error format-string . args)
  (if (imps-raise-error?)
      (apply imps-error-or-return-false 'return-error format-string args)
      (apply imps-error-or-return-false 'return-false format-string args)))

(define imps-raise-error?
  (make-simple-switch 'imps-raise-error? boolean? '#t))      

(define raise-name-error?
  (make-simple-switch 'raise-name-error? boolean? '#f))

(define (imps-warning format-string . args)
  (let ((string (apply format '#f format-string args)))
    (if (emacs-process-filter?)
	(emacs-error (string-append "This is a warning: " string)))
    (newline (standard-output))
    (display "IMPS warning: " (standard-output))
    (display string (standard-output))
    (newline (standard-output))
    (force-output (standard-output))))

(define imps-congratulations-hook
  (make-simple-switch 'imps-congratulations-hook procedure? (always '#f))) 

(define (imps-congratulation format-string . args)
  (let ((string (apply format '#f format-string args)))
    (if (emacs-process-filter?)
	(or ((imps-congratulations-hook))
	    (emacs-error (string-append "Congratulations: " string))))
    (newline (standard-output))
    (display "IMPS congratulations: " (standard-output))
    (display string (standard-output))
    (newline (standard-output))
    (force-output (standard-output))))
      
(define (maybe-imps-warning format-string . args)
  (let ((string (apply format '#f format-string args)))
    (if (and (imps-raise-error?)
	     (emacs-process-filter?))
	(emacs-error (string-append "This is a warning: " string)))
    (newline (standard-output))
    (display "IMPS warning: " (standard-output))
    (display string (standard-output))
    (newline (standard-output))
    (force-output (standard-output))))

(define (imps-enforce predicate argument)
  (let ((ok? (predicate argument)))
    (if ok?
	argument
	(imps-error "ENFORCE failed for (~S ~S)." predicate argument))))

(define imps-ref object-unhash)

(define (walk-some-imps-files proc which proc-string)
  (walk
   proc
   which)    
  (format t "Done ~A imps~%" proc-string))
  
;;;(define (walk-stable-imps-files proc proc-string)
;;;  (walk
;;;   proc
;;;   *stable-imps-files*)    
;;;  (format t "Done ~A imps~%" proc-string))

(define (compile-imps)
  (walk-some-imps-files compile-if-outdated *imps-files* "compiling"))

(define (maybe-compile-imps)
  (walk-some-imps-files maybe-compile-if-outdated *imps-files* "selectively compiling"))

(define (update-imps)
  (walk-some-imps-files 
   (lambda (file)
     (*require nil file imps-implementation-env))
   *imps-files*
   "updating"))

;;;(define (load-stable-imps)
;;;  (walk-some-imps-files load *stable-imps-files* "loading stable"))
;;;  
;;;(define (load-unstable-imps)
;;;  (walk-some-imps-files load (unstable-imps-files) "loading unstable")
;;;  (finish-load nil))

;;;(define (load-imps . arg)
;;;  (walk-some-imps-files load *imps-files* "loading")
;;;  (finish-load arg))
;;;
(define (load-imps . arg)
  (walk-some-imps-files (lambda (x) (load x imps-implementation-env)) *imps-files* "loading")
  (t-e-write-commands)
  (finish-load arg))

(define (load-imps-auxiliary)
  (walk-some-imps-files (lambda (x) (load x imps-implementation-env)) *imps-auxiliary-files* "loading"))
;;;
;;;(define (load-imps-vlisp)
;;;  (walk-some-imps-files (lambda (x) (load x imps-implementation-env)) *imps-vlisp-files* "loading"))
;;;  
;; (lset *imps-string-form-users* '("carlton" "guttman" "jt" "dpr" "farmer" "watro"))
;;;(lset *imps-non-string-form-users* '("ramsdell"))
;;;(lset *xdg-users* '("jgw" "guttman" "ramsdell"))
;;;  
;;;(define (imps-string-form-user?)
;;;  (not (mem? string-equal?
;;;	     (user)	    
;;;	     *imps-non-string-form-users*)))

(define (finish-load arg)
  (ignore arg)
  (let ((coercion-port
	 (maybe-open (format nil "/tmp/~A-imps-coercions"
			     (user))
		     '(out))))
    (if (port? coercion-port)
	(set (coercion-warning-stream) coercion-port)))
  (set (imps-obarray-port)
       (or (maybe-open
	    (format nil "/tmp/~A-imps-obarray" (user))
	    '(out))
	   (open "/dev/null" '(out))))
  (set (use-string-form?) '#t)
  (maybe-start-xdvi-and-xdg)
  (maybe-install-emacs-obarray)
  (set (use-overloaded-names?) '#t)
  (set (maximum-nesting-for-logical-expressions) 2)

  (with-open-ports ((end (open '(imps copyright-end) 'in)))
    (display (read end) (standard-output)))
  (let ((ho (name->theory 'h-o-real-arithmetic)))
    (and ho (set (current-theory) ho)))

  (format t "~%Current theory: ~S~%~%" (current-theory))
  repl-wont-print)


(define (MAYBE-START-XDVI-AND-XDG)
  (and
   (emacs-process-filter?)
   (unix-getenv "DISPLAY")
   (emacs-eval "(imps-xview-maybe-start-xdvi)"))
  ;;  (or
  ;;(unix-getenv "SOLARIS")
  ;;(emacs-eval "(run-xdg))"
  ;;commented this out because there seems to be little interest in it.

  ;;   ))
  )

(define (maybe-install-emacs-obarray)
  (if (emacs-process-filter?)
      (emacs-eval
       (format
	nil 
	"(mapcar 'augment-imps-obarray-from-file (mapcar 'substitute-in-file-name '~S))"
	(currently-loaded-section-aux-files)))))



(define CONTEXT-SIMPLIFICATION-PERSISTENCE
  (make-simple-switch 'context-simplification-persistence integer? 5))

(define CONTEXT-LOW-SIMPLIFICATION-PERSISTENCE
  (make-simple-switch 'context-low-simplification-persistence integer? 3))

(define PROOF-LOG-PORT
  (make-simple-switch 'proof-log-port (lambda (x) (or (false? x) (output-port? x))) '#f))

(define QUICK-LOAD?
  (make-simple-switch 'quick-load? boolean? '#f))

(define (QUICK-LOAD file)
  (bind (((quick-load?) '#t))
    (load file)))

(define (STATUS-OF-THEORY-NETWORK)
  (let ((alist (status-of-theory-network-alist)))
    (format (standard-output)
	    ";; STATUS OF THEORY NETWORK: ~&~A ~S ~&~A ~S ~&~A ~S ~&~A ~S ~&~A ~S"
	    ";;    Theories:                  " (cdr (assq 'theories alist))
	    ";;    Theory-interpretations:    " (cdr (assq 'theory-interpretations alist))
	    ";;    Theorems:                 " (cdr (assq 'theorems alist))
	    ";;    Macetes:                  " (cdr (assq 'macetes alist))
	    ";;    Expressions:            " (cdr (assq 'expressions alist)))))

(define (STATUS-OF-THEORY-NETWORK-ALIST)
  (list (cons 'theories (count-theories))
	(cons 'theory-interpretations (count-theory-interpretations))
	(cons 'theorems (count-theorems))
	(cons 'macetes (count-macetes))
	(cons 'expressions (count-imps-expressions))))

;;;(define (system-please-compress file)
;;;  (= 0 (exec (format nil "compress -f ~A" file))))
;;;
;;;(define (system-please-uncompress file)
;;;  (iterate loop ((n 20))
;;;    (if (file-exists? (string-append file ".Z"))
;;;	(if (< n 0)
;;;	    '#f
;;;	    (if (= 0 (exec (format nil "uncompress ~A" file)))
;;;		'#t
;;;		(loop (subtract1 n))))
;;;	'#t)))
;;;

 

;;;(let ((ev (repl-eval))
;;;      (sp (repl-prompt)))
;;;  (set (repl-eval)
;;;       (lambda (a b)
;;;	 (emacs-eval "(setq tea-process-busy-p t)") (ev a b)))
;;;  (set (repl-prompt)
;;;       (lambda (n)
;;;	 (emacs-eval "(setq tea-process-busy-p nil)") (sp n))))


(return)

