;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(herald constructor-simplifier-patch)

;; A-list, key being a constructor, value being an
;; old-constructor/new-constructor pair.  


(lset constructor-simplifier-pair-alist '())

;; Retrieve the old-constructor value for constr from
;; constructor-simplifier-pair-alist, if any; otherwise, use the current
;; constructor.  

(define (constructor-old-simplifier constr)
  (let ((probe (cadr (assq constr constructor-simplifier-pair-alist))))
    (if (procedure? probe)
	probe
	(constructor-simplifier constr))))


;; Retrieve the new-constructor value for constr from
;; constructor-simplifier-pair-alist, if any; otherwise, use the current
;; constructor. 

(define (constructor-new-simplifier constr)
  (let ((probe (cddr (assq constr constructor-simplifier-pair-alist))))
    (if (procedure? probe)
	probe
	(constructor-simplifier constr))))

;; Install the constructor simplifier for CONSTR and NEW-SIMPLIFIER as an
;; old-constructor/new-constructor pair in constructor-simplifier-pair-alist,
;; and also make new-simplifier be the constructor simplifier for it.  

(define (update-constructor-simplifier constr new-simplifier)
  (let ((old (constructor-simplifier constr)))
    (push constructor-simplifier-pair-alist
	  (cons constr (cons old new-simplifier)))
    (set-constructor-simplifier constr new-simplifier)))

;; The following two procedures toggle between the
;; old-constructor/new-constructor pairs for constructors that have 'em.  

(define (use-new-constructor-simplifiers)
  (walk
   (lambda (c)
     (set-constructor-simplifier
      c
      (constructor-new-simplifier c)))
   (append *constructors* *quasi-constructors*)))

(define (use-old-constructor-simplifiers)
  (walk
   (lambda (c)
     (set-constructor-simplifier
      c
      (constructor-old-simplifier c)))
   (append *constructors* *quasi-constructors*)))

;; This procedure determines whether an expression is a conditional with an
;; undefined limb.  It returns:
;;   '#f if not;
;;   1 if the consequent is an undefined limb; and
;;   2 if the alternative is the undefined limb.
;; 

(define (conditional-with-undefined-limb expr)
  (and
   (conditional? expr)
   (let ((comps (expression-components expr)))
     (cond
      ((necessarily-undefined? (nth comps 1)) 1)
      ((necessarily-undefined? (nth comps 2)) 2)
      (else '#f)))))

;; This procedure determines whether an expression is a conditional with a
;; necessarily defined limb.  It returns:
;;   '#f if not;
;;   1 if the consequent is a necessarily defined limb; and
;;   2 if the alternative is the necessarily defined limb.
;; 


(define (conditional-with-defined-limb expr)
  (and
   (conditional? expr)
   (let ((comps (expression-components expr)))
     (cond
      ((necessarily-defined? (nth comps 1)) 1)
      ((necessarily-defined? (nth comps 2)) 2)
      (else '#f)))))

;; This procedure determines whether an expression is a conditional with a
;; limb necessarily defined with a value in the given sort.  It returns:
;;   '#f if not;
;;   1 if the consequent is a necessarily sort defined limb; and
;;   2 if the alternative is the necessarily sort defined limb.
;; 


(define (conditional-with-sort-defined-limb expr sort)
  (and
   (conditional? expr)
   (let ((comps (expression-components expr)))
     (cond
      ((necessarily-defined-in-sort? (nth comps 1) sort) 1)
      ((necessarily-defined-in-sort? (nth comps 2) sort) 2)
      (else '#f)))))

(define (EQUALITY-SIMPLIFIER-with-conditionals components)
  (let ((lhs (car components))
	(rhs (cadr components)))
    (cond ((or (eq? lhs rhs)
	       (alpha-equivalent? lhs rhs))
	   (is-defined-simplifier-with-conditionals (list lhs)))
	  ((and (constant? lhs)
		(constant? rhs)
		(numerical-object? (name lhs))
		(numerical-object? (name rhs)))
	   (if (numerical-= (name lhs) (name rhs))
	       truth falsehood))
	  ((or (necessarily-undefined? lhs)
	       (necessarily-undefined? rhs))
	   falsehood)
	  ((equality-raise-conditional lhs rhs))
	  (else
	   (equality lhs rhs)))))

(define (equality-raise-conditional lhs rhs)
  (cond
   ((conditional-with-undefined-limb lhs)
    =>
    (lambda (i)
      (xcase i
	((2) (conjunction
	      (conditional-test lhs)
	      (equality (conditional-consequent lhs) rhs)))
	((1) (conjunction
	      (push-not (conditional-test lhs))
	      (equality (conditional-alternative lhs) rhs))))))
   ((conditional-with-undefined-limb rhs)
    =>
    (lambda (i)
      (xcase i
	((2) (conjunction
	      (conditional-test rhs)
	      (equality lhs (conditional-consequent rhs))))
	((1) (conjunction
	      (push-not (conditional-test rhs))
	      (equality lhs (conditional-alternative rhs)))))))
   (else '#f)))


(define (quasi-equality-simplifier-with-conditionals quasi-components)
  (let ((lhs (car  quasi-components))
	(rhs (cadr quasi-components)))
    (cond ((or (eq? lhs rhs)
	       (alpha-equivalent? lhs rhs))
	   truth)
	  ((and (necessarily-undefined? lhs)
		(necessarily-undefined? rhs))
	   truth)
	  ((or (and (necessarily-defined? lhs)
		    (necessarily-undefined? rhs))
	       (and (necessarily-undefined? lhs)
		    (necessarily-defined? rhs)))
	   falsehood)
	  ((or (necessarily-defined? lhs)
	       (necessarily-defined? rhs))
	   (equality-simplifier-with-conditionals quasi-components))
	  ((necessarily-undefined? lhs)
	   (push-not 
	    (is-defined-simplifier-with-conditionals
	     (list rhs))))
	  ((necessarily-undefined? rhs)
	   (push-not 
	    (is-defined-simplifier-with-conditionals
	     (list lhs))))
	  ((quasi-equality-raise-conditional lhs rhs))
	  (else
	   (quasi-equality lhs rhs)))))


(define (quasi-equality-raise-conditional lhs rhs)
  (cond
   ((conditional-with-undefined-limb lhs)
    =>
    (lambda (i)
      (xcase i
	((2) (if-form
	      (conditional-test lhs)
	      (quasi-equality (conditional-consequent lhs) rhs)
	      (negation (is-defined rhs))))
	((1) (if-form
	      (conditional-test lhs)
	      (negation (is-defined rhs))
	      (quasi-equality (conditional-alternative lhs) rhs))))))
   ((conditional-with-defined-limb lhs)
    =>
    (lambda (i)
      (xcase i
	((2) (if-form
	      (conditional-test lhs)
	      (quasi-equality (conditional-consequent lhs) rhs)
	      (equality (conditional-alternative lhs) rhs)))
	((1) (if-form
	      (conditional-test lhs)
	      (equality (conditional-consequent lhs) rhs)
	      (quasi-equality (conditional-alternative lhs) rhs))))))
   ((conditional-with-undefined-limb rhs)
    =>
    (lambda (i)
      (xcase i
	((2) (if-form
	      (conditional-test rhs)
	      (quasi-equality lhs (conditional-consequent rhs))
	      (negation (is-defined lhs))))
	((1) (if-form
	      (conditional-test rhs)
	      (negation (is-defined lhs))
	      (quasi-equality lhs (conditional-alternative rhs)))))))
   ((conditional-with-defined-limb lhs)
    =>
    (lambda (i)
      (xcase i
	((2) (if-form
	      (conditional-test rhs)
	      (quasi-equality lhs (conditional-consequent rhs))
	      (equality lhs (conditional-alternative rhs))))
	((1) (if-form
	      (conditional-test rhs)
	      (equality lhs (conditional-consequent rhs))
	      (quasi-equality lhs (conditional-alternative rhs)))))))
   (else '#f)))


(define (is-defined-simplifier-with-conditionals components)
  (let ((c (car components)))
    (cond ((necessarily-defined?  c)
	   truth)
	  ((necessarily-undefined? c)
	   falsehood)
	  ((is-defined-raise-conditional c))
	  (else
	   (apply is-defined components)))))  

(define (is-defined-raise-conditional c)
  (cond
   ((conditional-with-undefined-limb c)
    =>
    (lambda (i)
      (xcase i
	((2) (conjunction
	      (conditional-test c)
	      (is-defined  (conditional-consequent c))))
	((1) (conjunction
	      (push-not (conditional-test c))
	      (is-defined  (conditional-alternative c)))))))
   ((conditional-with-defined-limb c)
    =>
    (lambda (i)
      (xcase i
	((2) (implication 
	      (conditional-test c)
	      (is-defined (conditional-consequent c))))
	((1) (implication
	      (push-not (conditional-test c))
	      (is-defined (conditional-alternative c)))))))
   (else '#f)))


(define (is-defined-in-sort-simplifier-with-conditionals components)
  (let ((term (car components))
	(term-sorting (expression-sorting (car components)))
	(var-sorting (expression-sorting (cadr components))))
    (cond ((sort-necessarily-included? term-sorting var-sorting)
	   (is-defined-simplifier-with-conditionals (list term)))
	  ((necessarily-undefined? term)
	   falsehood)
	  ((and (constant? term)
		;; (numerical-object? (name term))
		(language-sorting->numerical-type (home-language term) var-sorting))
	   =>
	   (lambda (num-type)
	     (cond ((numerical-type? num-type)
		    (if ((numerical-type-recognizer num-type) (name term))
			truth
			falsehood))
		   ((procedure? num-type)
		    (if (num-type (name term))
			truth
			falsehood))
		   ((is-defined-in-sort-raise-conditional term var-sorting))
		   (else 	  
		    (defined-in term var-sorting)))))
	  ((is-defined-in-sort-raise-conditional term var-sorting))
	  (else 	  
	   (defined-in term var-sorting)))))



(define (is-defined-in-sort-raise-conditional c sort)
  (cond
   ((conditional-with-undefined-limb c)
    =>
    (lambda (i)
      (xcase i
	((2) (conjunction
	      (conditional-test c)
	      (defined-in (conditional-consequent c) sort)))
	((1) (conjunction
	      (push-not (conditional-test c))
	      (defined-in (conditional-alternative c) sort))))))
   ((conditional-with-sort-defined-limb c sort)
    =>
    (lambda (i)
      (xcase i
	((2) (implication 
	      (conditional-test c)
	      (defined-in (conditional-consequent c) sort)))
	((1) (implication
	      (push-not (conditional-test c))
	      (defined-in (conditional-alternative c) sort))))))
   (else '#f)))
     
	
	 

(define (apply-operator-simplifier-with-conditionals components)
  (let ((ps (predicate? (car components)))
	(is (function? (car components)))
	(crude (apply apply-operator components)))       
    (cond
     ((and ps (necessarily-undefined? crude))
      falsehood)
     ((and is (necessarily-undefined? crude))
      (undefined
       (higher-sort-range (expression-sorting (car components)))))
     ((and ps (prop-apply-operator-raise-conditional components)))
     ((and is (ind-apply-operator-raise-conditional components)))
     (else crude))))

(define (prop-apply-operator-raise-conditional components)
  (receive (j i)
    (iterate iter ((components components)
		   (j 0))
      (cond ((null? components) (return '#f '#f))
	    ((conditional-with-undefined-limb (car components))
	     => (lambda (i) (return j i)))
	    (else (iter (cdr components) (1+ j)))))
    (and
     j
     (conjunction
      (xcase i
	((2) (conditional-test (nth components j)))
	((1) (push-not (conditional-test (nth components j)))))
      (apply apply-operator (ap-op-raise-make-args components j i))))))

(define (ind-apply-operator-raise-conditional components)
  (receive (j i)
    (iterate iter ((components components)
		   (j 0))
      (cond ((null? components) (return '#f '#f))
	    ((conditional-with-undefined-limb (car components))
	     => (lambda (i) (return j i)))
	    (else (iter (cdr components) (1+ j)))))
    (and
     j
     (if-term
      (xcase i
	((2) (conditional-test (nth components j)))
	((1) (push-not (conditional-test (nth components j)))))
      (apply apply-operator (ap-op-raise-make-args components j i))
      (undefined (range-sort (car components)))))))


(define (ap-op-raise-make-args components j i)
  (iterate iter ((components components)
		 (new-comps '())
		 (k 0))
    (cond
     ((null? components) (reverse! new-comps))
     ((= k j)
      (iter
       (cdr components)
       (cons 
	(xcase i
	  ((2) (conditional-consequent (car components)))
	  ((1) (conditional-alternative (car components))))
	new-comps)
       (1+ k)))
     (else
      (iter
       (cdr components)
       (cons 
	(car components)
	new-comps)
       (1+ k))))))
      
	 
    
(update-constructor-simplifier
 equality
 equality-simplifier-with-conditionals)
(update-constructor-simplifier
 quasi-equality
 quasi-equality-simplifier-with-conditionals)
(update-constructor-simplifier
 is-defined
 is-defined-simplifier-with-conditionals)
(update-constructor-simplifier
 is-defined-in-sort
 is-defined-in-sort-simplifier-with-conditionals)
(update-constructor-simplifier
 apply-operator
 apply-operator-simplifier-with-conditionals)
