;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald DG-INFERENCES-INTERFACE)


;;; here are the procedures that can be legitimately called by the user in the 
;;; course of building up a deduction-graph.

(define (DEDUCTION-GRAPH-ASSUME-THEOREM sqn name-or-formula)
  (dg-primitive-inference-theorem-assumption sqn (coerce-to-theorem name-or-formula)))

;;; UNFOLDING PROCEDURES

(define (DEDUCTION-GRAPH-UNFOLD-DEFINED-CONSTANT
	 sqn occurrences constant-name)
    (let* ((assertion (sequent-node-assertion sqn))
	   (theory (deduction-graph-theory (sequent-node-graph sqn)))
	   (constant (find-constant-with-warning (theory-language theory) constant-name))
	   (virtual-paths
	    (sorted-virtual-paths-to-occurrences assertion constant -1))
	   (virtual-paths-to-replace
	    (choose-list-entries virtual-paths occurrences)))
      (deduction-graph-unfold-defined-constant-at-virtual-paths
	 sqn virtual-paths-to-replace constant)))
  
(define (DEDUCTION-GRAPH-UNFOLD-DEFINED-CONSTANT-AT-VIRTUAL-PATHS
	 sqn paths constant)
  (let* ((assertion (sequent-node-assertion sqn))
	 (expanded-paths 
	  (apply 
	   append 
	   (map
	    (lambda (path) (expand-virtual-path assertion path))
	    paths))))
    (dg-primitive-inference-defined-constant-unfolding sqn expanded-paths constant)))

(define (DEDUCTION-GRAPH-UNFOLD-DEFINED-CONSTANT-AT-PATH sqn path constant)
  (dg-primitive-inference-defined-constant-unfolding sqn (list path) constant))

(define (DEDUCTION-GRAPH-UNFOLD-DEFINED-CONSTANT-MESSILY sqn nums constant-name);;changed
  (let* ((theory (deduction-graph-theory (sequent-node-graph sqn)))
	 (constant (find-constant-with-warning (theory-language theory) constant-name))
	 (sorted-paths
	  (sorted-paths-to-occurrences (sequent-node-assertion sqn) constant -1))
	 (paths (choose-list-entries sorted-paths nums)))
    (dg-primitive-inference-defined-constant-unfolding sqn paths constant)))

(define (DEDUCTION-GRAPH-UNFOLD-DEFINED-CONSTANT-GLOBALLY sqn constant-name)
  (let* ((theory (deduction-graph-theory (sequent-node-graph sqn)))
	 (constant (find-constant-with-warning (theory-language theory) constant-name))
	 (paths
	  (paths-to-occurrences (sequent-node-assertion sqn) constant -1)))
    (dg-primitive-inference-defined-constant-unfolding sqn paths constant)))


;;; MACETE APPLICATION PROCEDURES

(define (DEDUCTION-GRAPH-APPLY-MACETE sqn name-or-macete)
  (dg-primitive-inference-macete-application-at-paths sqn '(()) (coerce-to-macete name-or-macete)))

(define (DEDUCTION-GRAPH-APPLY-MACETE-WITH-MINOR-PREMISES sqn name-or-macete)
  (dg-primitive-inference-macete-application-with-minor-premises-at-paths sqn '(()) (coerce-to-macete name-or-macete)))

(define (DEDUCTION-GRAPH-APPLY-MACETE-LOCALLY sqn name-or-macete nums expr-str-or-expr)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(virtual-paths-to-occurrences
			 assertion
			 (sqn-coerce-to-expression sqn expr-str-or-expr)
			 -1)))
	 (virtual-paths-to-apply-macete
	  (choose-list-entries sorted-paths nums))
	 (expanded-paths 
	  (apply 
	   append 
	   (map
	    (lambda (path) (expand-virtual-path assertion path))
	    virtual-paths-to-apply-macete))))
    (dg-primitive-inference-macete-application-at-paths sqn expanded-paths (coerce-to-macete name-or-macete))))

(define (DEDUCTION-GRAPH-APPLY-MACETE-LOCALLY-WITH-MINOR-PREMISES sqn name-or-macete nums expr-str-or-expr)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(virtual-paths-to-occurrences
			 assertion
			 (sqn-coerce-to-expression sqn expr-str-or-expr)
			 -1)))
	 (virtual-paths-to-apply-macete
	  (choose-list-entries sorted-paths nums))
	 (expanded-paths 
	  (apply 
	   append 
	   (map
	    (lambda (path) (expand-virtual-path assertion path))
	    virtual-paths-to-apply-macete))))
    (dg-primitive-inference-macete-application-with-minor-premises-at-paths
     sqn expanded-paths (coerce-to-macete name-or-macete))))

;;;The following procedure does not seem to be used anywhere:

(define (DEDUCTION-GRAPH-APPLY-MACETE-LOCALLY-AND-MESSILY sqn name-or-macete nums expr-str-or-expr)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(paths-to-occurrences
			 assertion
			 (sqn-coerce-to-expression sqn expr-str-or-expr)
			 -1)))
	 (paths-to-apply-macete
	    (choose-list-entries sorted-paths nums)))
    (dg-primitive-inference-macete-application-at-paths sqn paths-to-apply-macete (coerce-to-macete name-or-macete))))

;;;(define (DEDUCTION-GRAPH-APPLY-MACETE-AT-SEQUENT macete sqn)
;;;  (deduction-graph-apply-macete sqn macete))
;;;
;;;(define (DEDUCTION-GRAPH-APPLY-MACETE-WITH-MINOR-PREMISES-AT-SEQUENT macete sqn)
;;;  (deduction-graph-apply-macete-with-minor-premises sqn macete))
;;;

;;; FORCE SUBSTITUTION PROCEDURES

;;;(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION
;;;	 sqn target-input replacement-input occurrences)
;;;  (let* ((sequent (sequent-node-sequent sqn)))
;;;       (deduction-graph-force-substitution-aux
;;;	sqn
;;;	(sequent-read sequent target-input)
;;;	(sequent-read sequent replacement-input)
;;;	occurrences)))

(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION
	 sqn target replacement occurrences)
  (let ((target (sqn-coerce-to-expression sqn target))
	(replacement (sqn-coerce-to-expression sqn replacement)))
    (let* ((assertion (sequent-node-assertion sqn))
	   (virtual-paths
	    (sorted-virtual-paths-to-occurrences assertion target -1))
	   (virtual-paths-to-replace
	    (choose-list-entries virtual-paths occurrences)))
      (deduction-graph-force-substitution-at-virtual-paths  
       sqn replacement virtual-paths-to-replace))))

(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION-AT-VIRTUAL-PATHS
	 sqn replacement virtual-paths)
  (let* ((assertion (sequent-node-assertion sqn))
	 (expanded-paths
	  (apply append (map 
			  (lambda (virtual-path)
			    (expand-virtual-path assertion virtual-path))
			  virtual-paths))))
    (dg-primitive-inference-force-substitution
     sqn
     expanded-paths
     (replace-list-entries expanded-paths replacement))))

(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION-AT-PATH sqn path replacement)
  (dg-primitive-inference-force-substitution sqn (list path) (list replacement)))

;;;The following two procedures do not seem to be used anywhere:

(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION-MESSILY sqn target-input replacement-input nums)
     (let* ((sequent (sequent-node-sequent sqn)))
       (deduction-graph-force-substitution-messily-aux
	sqn
	(sequent-read sequent target-input)
	(sequent-read sequent replacement-input)
	nums)))

(define (DEDUCTION-GRAPH-FORCE-SUBSTITUTION-MESSILY-AUX
	 sqn
	 target
	 replacement
	 nums)
  (let* ((sorted-paths (sorted-paths-to-occurrences (sequent-node-assertion sqn)
					    target
					    -1))
	 (paths (choose-list-entries sorted-paths nums))
	 (replacements (replace-list-entries nums replacement)))
    (dg-primitive-inference-force-substitution
     sqn
     paths
     replacements)))


;;; RAISE CONDITIONAL PROCEDURES

(define (DEDUCTION-GRAPH-RAISE-CONDITIONAL sqn)
  (deduction-graph-raise-conditional-inference sqn '(0)))

(define (DEDUCTION-GRAPH-RAISE-CONDITIONAL-INFERENCE sqn nums)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(paths-to-satisfying-virtual-occurrences
			 assertion
			 conditional-term? -1))))
    (if (null? sorted-paths)
	(fail)
	(let* ((paths (choose-list-entries sorted-paths nums))
	       (expanded-paths 
		(apply 
		 append 
		 (map
		  (lambda (path) (expand-virtual-path assertion path))
		  paths))))
	  (dg-primitive-inference-raise-conditional-inference sqn expanded-paths)))))


;;;The following two procedures do not seem to be used anywhere:

(define (DEDUCTION-GRAPH-RAISE-CONDITIONAL-MESSILY sqn)
  (deduction-graph-raise-conditional-messily-inference sqn '(0)))

(define (DEDUCTION-GRAPH-RAISE-CONDITIONAL-MESSILY-INFERENCE sqn nums)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(paths-to-satisfaction
			 assertion
			 conditional-term? -1))))
	 (if (null? sorted-paths)
	     (fail)
	     (let ((paths (choose-list-entries sorted-paths nums)))
	       (dg-primitive-inference-raise-conditional-inference sqn paths)))))


;;; ELIMINATE IOTA PROCEDURES

(define (DEDUCTION-GRAPH-ELIMINATE-IOTA sqn . occurrences)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(paths-to-satisfying-virtual-occurrences
			 assertion
			 iota-expression? -1)))
	 (paths 
	  (if (null? occurrences)
	      sorted-paths
	      (choose-list-entries sorted-paths occurrences))))
    (if paths
	(dg-primitive-inference-iota-elimination sqn (car paths))
	(fail))))

;;;(define (DEDUCTION-GRAPH-ELIMINATE-IOTA-2 sqn . occurrences)
;;;  (let* ((assertion (sequent-node-assertion sqn))
;;;	 (sorted-paths (sort-paths!
;;;			(paths-to-satisfying-virtual-occurrences
;;;			 assertion
;;;			 iota-expression? -1)))
;;;	 (paths 
;;;	  (if (null? occurrences)
;;;	      sorted-paths
;;;	      (choose-list-entries sorted-paths occurrences))))
;;;    (if paths
;;;	(dg-primitive-inference-obsolete-iota-elimination sqn (car paths))
;;;	(fail))))


;;; BETA-REDUCTION PROCEDURES

(define (DEDUCTION-GRAPH-BETA-REDUCE sqn)
  (deduction-graph-apply-macete sqn (name->macete 'beta-reduce)))

(define (DEDUCTION-GRAPH-BETA-REDUCE-INSISTENTLY sqn)
  (bind (((simplify-quasi-constructors-messily?) '#t))
    (deduction-graph-apply-macete sqn (name->macete 'beta-reduce))))

(define (DEDUCTION-GRAPH-BETA-REDUCE-REPEATEDLY sqn)
  (deduction-graph-apply-macete sqn (name->macete 'beta-reduce-repeatedly)))

(define (DEDUCTION-GRAPH-BETA-REDUCE-WITH-MINOR-PREMISES sqn)
  (deduction-graph-apply-macete-with-minor-premises sqn (name->macete 'beta-reduce)))

;;;(define dg-primitive-inference-beta-reduction deduction-graph-beta-reduce)
;;;
;;;(define dg-primitive-inference-insistent-beta-reduction deduction-graph-beta-reduce-insistently)

;;; BACKCHAIN

(define (DEDUCTION-GRAPH-BACKCHAIN sqn formula-formula-string-or-index)
  (dg-primitive-inference-backchain-inference sqn (sqn-coerce-to-assumption sqn formula-formula-string-or-index)))

(define (DEDUCTION-GRAPH-BACKCHAIN-BACKWARDS sqn formula-formula-string-or-index)
  (dg-primitive-inference-backchain-backwards-inference sqn (sqn-coerce-to-assumption sqn formula-formula-string-or-index)))

(define (DEDUCTION-GRAPH-BACKCHAIN-THROUGH-FORMULA sqn formula-formula-string-or-index)
  (dg-primitive-inference-backchain-through-formula-inference sqn (sqn-coerce-to-assumption sqn formula-formula-string-or-index)))

;;; MISC. PROCEDURES

(define (DEDUCTION-GRAPH-ANTECEDENT-INFERENCE sqn formula-formula-string-or-index)
 (dg-primitive-inference-antecedent-inference
  sqn
  (sqn-coerce-to-assumption sqn formula-formula-string-or-index)))

(define (DEDUCTION-GRAPH-INCORPORATE-ANTECEDENT sqn formula-formula-string-or-index)
  (dg-primitive-inference-implication-elimination 
   sqn
   (sqn-coerce-to-assumption sqn formula-formula-string-or-index)))

(define (DEDUCTION-GRAPH-CONTRAPOSE sqn formula-formula-string-or-index)
  (dg-primitive-inference-contraposition
   sqn
   (sqn-coerce-to-assumption sqn formula-formula-string-or-index)))

(define (DEDUCTION-GRAPH-WEAKEN sqn formulas-formula-strings-or-indices)
  (dg-primitive-inference-weakening
   sqn
   (map (lambda (x) (sqn-coerce-to-assumption sqn x)) formulas-formula-strings-or-indices)))

(define (DEDUCTION-GRAPH-CUT-WITH-SINGLE-FORMULA sqn formula-or-formula-string)
  (let ((formula (sqn-coerce-to-expression sqn formula-or-formula-string)))
    (let ((new-sqn 
	   (post (build-sequent
		  (context-add-assumptions (sequent-node-context sqn) (list formula))
		  (sequent-node-assertion sqn))
		 (sequent-node-graph sqn))))
      (dg-primitive-inference-cut sqn new-sqn))))

(define (DEDUCTION-GRAPH-GENERALIZE-SEQUENT sqn vars)
  (let ((graph (sequent-node-graph sqn)))
    (dg-primitive-inference-universal-instantiation
     sqn
     (post (universal-instantiation-build-major-premise
	    (sequent-node-sequent sqn)
	    vars)
	   graph))))

(define (DEDUCTION-GRAPH-GENERALIZE-USING-SEQUENT sqn major-sqn-or-number)
  (let ((major (dg-coerce-to-sequent-node (sequent-node-graph sqn) major-sqn-or-number)))
    (dg-primitive-inference-universal-instantiation sqn major)))

(define (DEDUCTION-GRAPH-CUT-USING-SEQUENT sqn major-sqn-or-number)
  (let ((major (dg-coerce-to-sequent-node (sequent-node-graph sqn) major-sqn-or-number)))
    (dg-primitive-inference-cut sqn major)))

(define (IMPS-EDIT-AND-POST-SQN sqn context-string assertion-string)
  (let* ((graph (sequent-node-graph sqn))
	 (theory (deduction-graph-theory graph))
	 (language (theory-language theory))
	 (sequent
	  (build-sequent
	   (build-context theory
			  (string->assumptions language context-string))
	   (qr assertion-string language))))
    (dg-register-node 'newly-posted (post sequent graph)))
  '())

(define (DEDUCTION-GRAPH-DISABLE-QUASI-CONSTRUCTOR sqn qc-name)
  (ignore sqn)
  (let ((qc (name->quasi-constructor qc-name)))
    (or (quasi-constructor? qc)
	(imps-error "DEDUCTION-GRAPH-DISABLE-QUASI-CONSTRUCTOR: ~A is not the name of a quasi-constructor" qc-name))
   (disable-quasi-constructor qc)))

(define (DEDUCTION-GRAPH-ENABLE-QUASI-CONSTRUCTOR sqn qc-name)
  (ignore sqn)
  (let ((qc (name->quasi-constructor qc-name)))
    (or (quasi-constructor? qc)
	(imps-error "DEDUCTION-GRAPH-ENABLE-QUASI-CONSTRUCTOR: ~A is not the name of a quasi-constructor" qc-name))
   (enable-quasi-constructor qc)))

(comment
 (define (IMPS-POST-COMPUTATION-NODE sqn)
  (let ((dg (sequent-node-graph sqn)))
    (post-computation-node sqn dg))))

(define (ANNOTATE-DG-HISTORY sqn keyword . rest)
  (cond ((not (sequent-node? sqn)) 'ignore)
	((eq? keyword 'begin-block)
	 (increment
	  (deduction-graph-unended-block-count
	   (sequent-node-graph sqn))))
	((eq? keyword 'end-block)
	 (if (positive?
	      (deduction-graph-unended-block-count
	       (sequent-node-graph sqn)))
	     (decrement
	      (deduction-graph-unended-block-count
	       (sequent-node-graph sqn)))
	     (imps-error
	      "annotate-dg-history: Attempt to end block with none open.")))
	;;
	;; In the case of let-script and let-macete, no action is needed,
	;; because the command applierwill ensure that the arguments are
	;; recorded in the command history (if needed).
	;; 
	((eq? keyword 'let-script) 'dont-do-anything)
	((eq? keyword 'let-macete) 'dont-do-anything))
  
  sqn)

;;; COMMANDS


(build-universal-command
 dg-primitive-inference-direct-inference
 'direct-inference
 (always '#t))

(build-universal-command
 dg-primitive-inference-insistent-direct-inference
 'insistent-direct-inference
 (always '#t))

(build-universal-command
 deduction-graph-antecedent-inference
 'antecedent-inference
 (always '#t)
 'antececent-inference-retrieval-protocol)

(build-universal-command
 deduction-graph-contrapose
 'contrapose
 (always '#t)
 'single-formula-retrieval-protocol)

(build-universal-command
 dg-primitive-inference-simplification
 'simplify
 (always '#t))

(build-universal-command
 dg-primitive-inference-insistent-simplification
 'simplify-insistently
 (always '#t))

(build-universal-command
 dg-primitive-inference-weak-simplification
 'simplify-weakly
 (always '#t))

(build-universal-command
 dg-primitive-inference-simplification-with-minor-premises
 'simplify-with-minor-premises
 (always '#t))

(build-universal-command
 deduction-graph-beta-reduce
 'beta-reduce
 (always '#t))

(build-universal-command
 deduction-graph-beta-reduce-insistently
 'beta-reduce-insistently
 (always '#t))

(build-universal-command
 deduction-graph-beta-reduce-repeatedly
 'beta-reduce-repeatedly
 (always '#t))

(build-universal-command
 deduction-graph-beta-reduce-with-minor-premises
 'beta-reduce-with-minor-premises
 (always '#t))

(build-universal-command
 dg-primitive-inference-extensionality
 'extensionality
 (always '#t))

(build-universal-command
 deduction-graph-weaken
 'weaken
 (always '#t)
 'formula-list-by-index-retrieval-protocol)

(build-universal-command
 deduction-graph-force-substitution
 'force-substitution
 (always '#t)
 'force-substitution-retrieval-protocol)

(build-universal-command
 deduction-graph-apply-macete
 'apply-macete
 (always '#t)
 'macete-retrieval-protocol)

(build-universal-command
 deduction-graph-apply-macete-with-minor-premises
 'apply-macete-with-minor-premises
 (always '#t)
 'macete-retrieval-protocol)

(build-universal-command
 deduction-graph-apply-macete-locally
 'apply-macete-locally
 (always '#t)
 'macete-and-expressions-in-formula-retrieval-protocol)

(build-universal-command
 deduction-graph-apply-macete-locally-with-minor-premises
 'apply-macete-locally-with-minor-premises
 (always '#t)
 'macete-and-expressions-in-formula-retrieval-protocol)

(build-universal-command
 deduction-graph-raise-conditional-inference
 'raise-conditional
 (always '#t)
 'locations-in-formula-retrieval-protocol)

(build-universal-command
 deduction-graph-eliminate-iota
 'eliminate-iota
 (always '#t)
 'eliminate-iota-retrieval-protocol)

;;;(build-universal-command
;;; deduction-graph-eliminate-iota-2
;;; 'eliminate-iota-2
;;; (always '#t)
;;; 'eliminate-iota-retrieval-protocol)

(build-universal-command
 deduction-graph-backchain
 'backchain
 (always '#t)
 'backchain-inference-rp)

(build-universal-command
 deduction-graph-backchain-backwards
 'backchain-backwards
 (always '#t)
 'backchain-backwards-inference-rp)

(build-universal-command
 deduction-graph-backchain-through-formula
 'backchain-through-formula
 (always '#t)
 'single-formula-retrieval-protocol)

(build-universal-command
 deduction-graph-incorporate-antecedent
 'incorporate-antecedent
 (always '#t)
 'single-formula-retrieval-protocol)

(build-universal-command
 deduction-graph-cut-using-sequent
 'cut-using-sequent
 (always '#t)
 'cut-retrieval-protocol)

(build-universal-command
 deduction-graph-cut-with-single-formula
 'cut-with-single-formula
 (always '#t)
 'cut-with-single-formula-retrieval-protocol)

(build-universal-command
 dg-primitive-inference-universal-instantiation
 'generalize-using-sequent
 (always '#t)
 'one-sequent-retrieval-protocol)

(build-universal-command
 deduction-graph-assume-theorem	
 'assume-theorem
 (always '#t)
 'theorem-retrieval-protocol)

(build-universal-command
 dg-primitive-inference-choice
 'choice-principle
 (always '#t))

;;;(build-universal-command
;;; dg-primitive-inference-existential-generalization
;;; 'instantiate-existential-using-sequent
;;; (always '#t)
;;; 'one-sequent-retrieval-protocol)
;;;
;;;(build-universal-command
;;; dg-primitive-inference-tautology
;;; 'tautology
;;; (always '#t))

(build-universal-command
 dg-primitive-inference-definedness
 'definedness
 (always '#t))

(build-universal-command
 dg-primitive-inference-sort-definedness
 'sort-definedness
 (always '#t))

(build-universal-command
 imps-edit-and-post-sqn
 'edit-and-post-sequent-node
 (always '#t)
 'sequent-edit-and-post-retrieval-protocol)

(build-universal-command
 deduction-graph-disable-quasi-constructor
 'disable-quasi-constructor
 (always '#t)
 'disable-quasi-constructor-retrieval-protocol)

(build-universal-command
 deduction-graph-enable-quasi-constructor
 'enable-quasi-constructor
 (always '#t)
 'enable-quasi-constructor-retrieval-protocol)


(comment
 (build-universal-command
  IMPS-POST-COMPUTATION-NODE
  'post-computation-node
  (always '#t)))

(build-universal-command
 annotate-dg-history
 'annotate
 (always '#t)
 'annotate-protocol)

;;; MESSY COMMANDS

;;;(build-universal-command
;;; deduction-graph-unfold-defined-constant-messily
;;; 'unfold-single-defined-constant-messily
;;; (always '#t)
;;; 'symbol-locations-in-formula-retrieval-protocol)
;;;
;;;(build-universal-command
;;; deduction-graph-force-substitution-messily
;;; 'force-substitution-messily
;;; (always '#t)
;;; 'force-substitution-retrieval-protocol)
;;;
;;;(build-universal-command
;;; deduction-graph-apply-macete-locally-and-messily
;;; 'apply-macete-locally-and-messily
;;; (always '#t)
;;; 'macete-and-expressions-in-formula-retrieval-protocol)
;;;
;;;(build-universal-command
;;; deduction-graph-raise-conditional-messily-inference
;;; 'raise-conditional-messily
;;; (always '#t)
;;; 'locations-in-formula-retrieval-protocol)





;;; OBSOLETE PROCEDURES
 
;;;(define deduction-graph-apply-primitive-inference apply)
;;;
;;;(define DEDUCTION-GRAPH-DIRECT-INFERENCE 
;;;  dg-primitive-inference-direct-inference)
;;;
;;;(define DEDUCTION-GRAPH-INSISTENT-DIRECT-INFERENCE
;;;  dg-primitive-inference-insistent-direct-inference)
;;;
;;;(define DEDUCTION-GRAPH-ANTECEDENT-INFERENCE 
;;;  dg-primitive-inference-antecedent-inference)
;;;
;;;(define DEDUCTION-GRAPH-CONTRAPOSITION 
;;;  dg-primitive-inference-contraposition)
;;;
;;;(define DEDUCTION-GRAPH-SIMPLIFY 
;;;  dg-primitive-inference-simplification)
;;;
;;;(define DEDUCTION-GRAPH-SIMPLIFICATION 
;;;  dg-primitive-inference-simplification)
;;;
;;;(define DEDUCTION-GRAPH-INSISTENT-SIMPLIFICATION 
;;;  dg-primitive-inference-insistent-simplification)
;;;
;;;(define DEDUCTION-GRAPH-WEAK-SIMPLIFICATION 
;;;  dg-primitive-inference-weak-simplification)
;;;
;;;(define DEDUCTION-GRAPH-SIMPLIFY-WITH-MINOR-PREMISES
;;;  dg-primitive-inference-simplification-with-minor-premises)
;;;
;;;(define DEDUCTION-GRAPH-SIMPLIFICATION-WITH-MINOR-PREMISES
;;;  dg-primitive-inference-simplification-with-minor-premises)
;;;
;;;(define DEDUCTION-GRAPH-BETA-REDUCTION
;;;  dg-primitive-inference-beta-reduction)
;;;
;;;(define DEDUCTION-GRAPH-INSISTENT-BETA-REDUCTION
;;;  dg-primitive-inference-insistent-beta-reduction)
;;;
;;;(define DEDUCTION-GRAPH-EXTENSIONALITY
;;;  dg-primitive-inference-extensionality)
;;;
;;;(define DEDUCTION-GRAPH-WEAKEN 
;;;  dg-primitive-inference-weakening)
;;;
;;;(define DEDUCTION-GRAPH-UNFOLD-CONSTANT-DEFINITION-AT-PATHS
;;;  dg-primitive-inference-defined-constant-unfolding)
;;;
;;;(define DEDUCTION-GRAPH-MACETE-APPLICATION deduction-graph-apply-macete)
;;;
;;;(define DEDUCTION-GRAPH-FORCE-BACKWARD-SUBSTITUTION-AT-PATHS
;;;  dg-primitive-inference-force-substitution)
;;;
;;;(define DEDUCTION-GRAPH-BACKCHAIN 
;;;  dg-primitive-inference-backchain-inference)
;;;
;;;(define DEDUCTION-GRAPH-BACKCHAIN-INFERENCE 
;;;  dg-primitive-inference-backchain-inference)
;;;
;;;(define DEDUCTION-GRAPH-BACKCHAIN-BACKWARDS-INFERENCE
;;;  dg-primitive-inference-backchain-backwards-through-expression)
;;;
;;;(define DEDUCTION-GRAPH-IMPLICATION-ELIMINATION
;;;  dg-primitive-inference-implication-elimination)
;;;
;;;(define DEDUCTION-GRAPH-CUT 
;;;  dg-primitive-inference-cut)
;;;
;;;(define DEDUCTION-GRAPH-EXISTENTIAL-GENERALIZATION
;;;  dg-primitive-inference-existential-generalization)
;;;
;;;(define DEDUCTION-GRAPH-DEFINEDNESS 
;;;  dg-primitive-inference-definedness)
;;;
;;;(define DEDUCTION-GRAPH-SORT-DEFINEDNESS
;;;  dg-primitive-inference-sort-definedness)
;;;
;;;(define DEDUCTION-GRAPH-THEOREM-ASSUMPTION 
;;;  dg-primitive-inference-theorem-assumption) 
;;;
;;;(define DEDUCTION-GRAPH-UNORDERED-CONJUNCTION-DIRECT-INFERENCE
;;;  dg-primitive-inference-unordered-conjunction-direct-inference)
;;;
;;;(define DEDUCTION-GRAPH-TAUTOLOGY dg-primitive-inference-tautology)
;;;
;;;(define DEDUCTION-GRAPH-UNIVERSAL-INSTANTIATION
;;;  dg-primitive-inference-universal-instantiation)
;;;
;;;(define DEDUCTION-GRAPH-APPLY-MACETE-AT-PATHS 
;;;  dg-primitive-inference-macete-application-at-paths)
