;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald (resources robust-table))

;;; Must redefine all of the procedures exported from t-implementation-env to
;;; user-env.  These are (from $TSOURCES /sys/exports.t)
;;; 
;;;    ;; TABLE
;;;    make-hash-table
;;;    hash-table?
;;;    table-entry
;;;    find-table-entry
;;;    table-walk
;;;    walk-table            
;;; 
;;;    make-table
;;;    table?
;;;    make-string-table
;;;    string-table?
;;;    make-symbol-table
;;;    symbol-table?
;;; 


(define (make-table . maybe-id)
  (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                 0 t true descriptor-hash eq?))

(define (make-table-of-size start-size . maybe-id)
  (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                 start-size t true descriptor-hash eq?))

(define make-table-with-size make-table-of-size)

(define (make-string-table . maybe-id)
  (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                 0 nil string? string-hash string-equal?))

(define (make-string-table-of-size start-size . maybe-id)
  (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                 start-size nil string? string-hash string-equal?))

(define make-string-table-with-size make-string-table-of-size)

(define (make-symbol-table . maybe-id)
  (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                 0 nil symbol? symbol-hash eq?))

(define (make-symbol-table-of-size start-size . maybe-id)
  (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                 start-size nil symbol? symbol-hash eq?))

(define make-symbol-table-with-size make-symbol-table-of-size)

(define (make-hash-table type hash comparison gc-sensitive? . maybe-id)
  (let ((type       (enforce procedure? type))
        (hash       (enforce procedure? hash))
        (comparison (enforce procedure? comparison)))
    (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                   0
                   gc-sensitive?
                   type
                   hash
                   comparison)))

(define (make-hash-table-of-size start-size type hash
                                 comparison gc-sensitive? . maybe-id)
  (let ((start-size (enforce nonnegative-fixnum? start-size))
        (type       (enforce procedure? type))
        (hash       (enforce procedure? hash))
        (comparison (enforce procedure? comparison)))
    (create-%walkproof-table (if maybe-id (car maybe-id) nil)
                   start-size
                   gc-sensitive?
                   type
                   hash
                   comparison)))

(define (hash-table? x)
  (%walkproof-table? x))

;;; The following predicates are not very exact.

(define (table? x)
  (and (%walkproof-table? x)
       (eq? ((*value t-implementation-env '%table-type)
	     (%walkproof-table-%table x))
	    true)
       (eq? ((*value t-implementation-env '%table-compare)
	     (%walkproof-table-%table x))
	    eq?)))

(define (string-table? x)
  (and (%walkproof-table? x)
       (eq? ((*value t-implementation-env '%table-type)
	     (%walkproof-table-%table x))
	    string?)
       (eq? ((*value t-implementation-env '%table-compare)
	     (%walkproof-table-%table x))
	    string-equal?)))

(define (symbol-table? x)
  (and (%walkproof-table? x)
       (eq? ((*value t-implementation-env '%table-type)
	     (%walkproof-table-%table x))
	    symbol?)
       (eq? ((*value t-implementation-env '%table-compare)
	     (%walkproof-table-%table x))
	    eq?)))


(define (%walkproof-table-id wp-table)
  ((*value t-implementation-env '%table-id)
   (%walkproof-table-%table wp-table)))
  

(define-structure-type %walkproof-table
  %table
  deferred	; list of key-value pairs which have not yet been added to the
		; table because it is currently being walked
  active-walker? ;true if table-walking is currently going on for this table

  ((((*value t-implementation-env 'recycle) self)
    (return-table-to-pool (%walkproof-table-%table self)))
   ((print self port)
    (format port "#{Table~_~S~_~S}"
	    (object-hash self)
	    (%walkproof-table-id self)))
   ((identification self) (%walkproof-table-id self))
   (((*value t-implementation-env 'set-identification) self id)
    (if (not (%walkproof-table-id self))
	(set ((*value t-implementation-env '%table-id) self) id)))))

(lset table-count-total 0)

(define (create-%walkproof-table id size gc? type hash compare)
  (let ((wpt (make-%walkproof-table)))
    (increment table-count-total)
    ;;    (if (fx= (fx-rem table-count-total 100) 0)
    ;;	;; (write-char (standard-output) #\^)
    ;;	(crawl (the-environment)))
    (set (%walkproof-table-%table wpt)
	 ((*value t-implementation-env 'create-%table)
	  id size gc? type hash compare))
    (set (%walkproof-table-deferred wpt) '())
    (set (%walkproof-table-active-walker? wpt) '#f)
    wpt))
  
(define table-entry
  (object (lambda (table key)
            (if (%walkproof-table? table)
		(cond (((*value t-implementation-env 'table-entry)
			(%walkproof-table-%table table) key))
		      ((ass ((*value t-implementation-env '%table-compare)
			     (%walkproof-table-%table table))
			    key
			    (%walkproof-table-deferred table))
		       => cdr)
		      (else  '#f))
		((*value t-implementation-env 'table-entry) table key)))
		    
    ((setter self)
     (lambda (table key value)
       (cond ((not (%walkproof-table? table))
	      (set ((*value t-implementation-env 'table-entry) table key) value))
	     ((or 
	       ;;harmless new value for existing key
	       ;;
	       ((*value t-implementation-env 'table-entry)
		(%walkproof-table-%table table) key)
	       ;;
	       ;;or no walking going on
	       ;;
	       (not (%walkproof-table-active-walker? table)))
	      ;; So just do addition
	      ((*value t-implementation-env '%set-table-entry)
	       (%walkproof-table-%table table) key value))
	     ;;
	     ;; Is the key already in the deferred list?
	     ;; 
	     ((ass ((*value t-implementation-env '%table-compare)
		    (%walkproof-table-%table table))
		   key
		   (%walkproof-table-deferred table))
	      => (lambda (pair)
		   (set (cdr pair) value)))
	     ;;
	     ;;otherwise defer adding it.
	     ;;
	     (else 
	      (push (%walkproof-table-deferred table)		  
		    (cons key value))))))))

(define (table-walk table proc)
  (cond ((not (%walkproof-table? table))
	 ((*value t-implementation-env 'table-walk) table proc))
	((%walkproof-table-active-walker? table)
	 (walk
	  (lambda (pair)
	    (proc (car pair) (cdr pair)))
	  (%walkproof-table-deferred table))
	 ((*value t-implementation-env 'table-walk)
	  (%walkproof-table-%table table)
	  proc))
	(else
	 (unwind-protect
	  (block (set (%walkproof-table-active-walker? table) '#t)
		 (table-walk table proc))
	  (let ((deferred (%walkproof-table-deferred table))
		(real-table (%walkproof-table-%table table))
		(real-table-entry (*value t-implementation-env 'table-entry)))
	    (set (%walkproof-table-active-walker? table) '#f)
	    (set (%walkproof-table-deferred table) '())
	    (walk
	     (lambda (pair)
	       (set (real-table-entry real-table (car pair)) (cdr pair)))
	     deferred)
	    (return))))))

(define-integrable (walk-table proc table)
    (table-walk table proc))

(define (find-table-entry table pred)
  (if (%walkproof-table? table)
      (receive (key val)
	((*value t-implementation-env 'find-table-entry)
	 (%walkproof-table-%table table))
	(if (or key val)
	    (return key val)
	    (iterate loop ((deferred (%walkproof-table-deferred table)))
	      (cond ((null? deferred) (return nil nil))
		    ((pred (caar deferred) (cdar deferred))
		     (return (caar deferred) (cdar deferred)))
		    (else (loop (cdr deferred)))))))
      ((*value t-implementation-env 'find-table-entry) table key)))

(define (copy-table table id . copy-proc)
  (cond ((and (%walkproof-table? table)
	      (not (null? (%walkproof-table-deferred table))))
	 (let ((deferred (%walkproof-table-deferred table))
	       (new (make-%walkproof-table)))
	   (set (%walkproof-table-%table new)
		(apply (*value t-implementation-env 'copy-table)
		       (%walkproof-table-%table table) id copy-proc))
	   (set (%walkproof-table-deferred new) '())
	   (set (%walkproof-table-active-walker? new) '#f)
	   (walk
	    (lambda (pair)
	      (set (table-entry new (car pair)) (cdr pair)))
	    deferred)
	   new))
	((%walkproof-table? table)
	 (let ((new (make-%walkproof-table)))
	   (set (%walkproof-table-%table new)
		(apply (*value t-implementation-env 'copy-table)
		       (%walkproof-table-%table table)
		       id copy-proc))
	   (set (%walkproof-table-deferred new) '())
	   (set (%walkproof-table-active-walker? new) '#f)
	   new))
	(else
	 (apply (*value t-implementation-env 'copy-table) table id copy-proc))))
