;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald svector)

(define-settable-operation (SVREF vect n))

(define-structure-type SVECTOR
  vector
  scatter-function
  length
  (((svref vect n)
    (or (< n (svector-length vect))
	(error "(HREF ~a ~a) index out of range" vect n))
    (vref (svector-vector vect) ((svector-scatter-function vect) n)))
   
;;(set (svref  vect n) new-val)
   (((setter svref) vect n new-val)
    (set (vref (svector-vector vect) ((svector-scatter-function vect) n))
	 new-val))
   ((print soi port) (format port "#(~a" (svref soi 0))
		     (walk-svector
		      (lambda (ind val)
			(ignore ind)
			(format port " ~a" val))
		      soi
		      1)
		     (format port ")"))))


(define (SVECTOR-=? a b)
  (let ((l1 (svector-length a)))
    (and
     (= l1 (svector-length b))
     (iterate loop ((n 0))
       (cond ((>= n l1) '#t)
	     ((not (= (svref a n) (svref b n))) '#f)
	     (else (loop (1+ n))))))))


(define (MAKE-LINEAR-SVECTOR length)
  (let ((new-vect (make-svector)))
    (set (svector-scatter-function new-vect) identity)
    (set (svector-length new-vect) length)
    (set (svector-vector new-vect) (make-vector length))
    new-vect))

(define (LIST->SVECTOR  args)
  (let ((new-vect (make-linear-svector (length args))))
    (walk-svector! (lambda (ind val)
		     (ignore ind)
		     (ignore val)
		     (pop args))
		   new-vect)
    new-vect))

(define (SVECTOR->LIST svect)
  (let ((accum '()))
    (walk-svector (lambda (ind val)
		    (ignore ind)
		    (push accum val)) svect)
    (reverse! accum)))

(define (*SVREF! vect n proc)
  ;;;PROC is a procedure of arguments N VAL; 
  ;;;N is the location, VAL the value at N.
  ;;;returns (proc n (svref vect n)) and replaces this value in n.
  (let ((displacement ((svector-scatter-function vect) n)))
    (set (vref (svector-vector vect) displacement)
	 (proc n (vref (svector-vector vect) displacement)))))

(define (*SVREF vect n proc)
  ;;;returns (proc n (svref vect n))
  (let ((displacement ((svector-scatter-function vect) n)))
    (proc n (vref (svector-vector vect) displacement))))

(define (WALK-SVECTOR! proc svector . limits)
  ;;proc is a procedure of arg INDEX VAL
  ;;replaces entry at INDEX with (proc index)
  ;;limits are beg (default 0) end (default (svector-length svector))
  (let ((beg (car limits))
	(end (cadr limits)))
    (if beg (enforce number? beg) (set beg 0))
    (if end (enforce number? end) (set end (svector-length svector)))
    (iterate loop ((ind beg))
      (cond ((>= ind end) (return))
	    (else (*svref! svector ind proc)
		  (loop (1+ ind)))))))

(define (WALK-SVECTOR proc svector . limits)
  (let ((beg (car limits))
	(end (cadr limits)))
    (if beg (enforce number? beg) (set beg 0))
    (if end (enforce number? end) (set end (svector-length svector)))
    (iterate loop ((ind beg))
      (cond ((>= ind end) (return))
	    (else (*svref svector ind proc)
		  (loop (1+ ind)))))))

(define-integrable (SVECTOR-TIMES a b)
  (let ((l1 (svector-length a)))
  (iterate loop ((n 0) (sum 0))
    (cond ((>= n l1) sum)
	  (else (loop (1+ n) (+ sum (* (svref a n) (svref b n)))))))))

(define-integrable (SVECTOR-PLUS a b)
  (let* ((l1 (svector-length a))
	 (v (make-linear-svector l1)))
    (iterate loop ((n 0))
    (cond ((>= n l1) v)
	  (else (set (svref v n) (+ (svref a n) (svref b n)))
		(loop (1+ n)))))))

(define (INTERCHANGE-SVECTORS v1 v2)
  (iterate loop ((ind 0))
      (cond ((>= ind (svector-length v1)) (return))
	    (else (let ((a2 (svref v2 ind))
			(a1 (svref v1 ind)))

		    (set (svref v2 ind) a1)
		    (set (svref v1 ind) a2))
		  (loop (1+ ind))))))


(define (NORMALIZE-SVECTOR-AT-INDEX svect ind)
  ;;;Assumption: the first non-zero entry of MATRIX in ROW occurs at COLUMN
  (let ((scale (svref svect ind)))
    (walk-svector! (lambda (ind val) (ignore ind) (/ val scale)) svect ind)))

(define (RETRACT-VECTOR sv1 sv2 ind)
  ;;;assumes SV1 has entry 1 in IND and all preceding entries are zero
  (let ((scale (svref sv2 ind)))
    (walk-svector!
     (lambda (n val)
       (- val (* scale (svref sv1 n))))
     sv2))) 
