;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald HEURISTIC-MATCHERS)



;;The purpose of the machinery here is to develop a notion of partial matching
;;between an EXPR and HOST.
;;Formally a PARTIAL MATCH is a list of pairs
;;(subexpr . subst) with subexpr a subexpression of expr and 
;;subst a substitution which instantiates subexpr as a subexpression of host
;;Each one of these pairs is called a LOCAL MATCH.

(define-integrable LOCAL-MATCH-SUBSTITUTION cdr)
(define-integrable LOCAL-MATCH-INSTANCE car)

(define-structure-type MATCHING-HEURISTIC
  context
  generality-evaluator
  partial-match-evaluator)


(define (BUILD-MATCHING-HEURISTIC)
  (let ((heur (make-matching-heuristic)))
    (set (matching-heuristic-context heur)  (build-context the-kernel-theory '()))
    (set (matching-heuristic-generality-evaluator heur)
	 (lambda (subst)
	   (apply + (map (lambda (x) (expression-height (replacement x))) subst))))
    (set (matching-heuristic-partial-match-evaluator heur)
	 (let ((div (lambda (x y) (if (< 0 y) (/ x y) x))))
	   (lambda (partial-match)
	     (apply
	      +
	      (map (lambda (x) (div (expression-height (local-match-instance x))
				    ((matching-heuristic-generality-evaluator heur)
				     (local-match-substitution x))))
		   partial-match)))))


    heur))

(define (SUBSTITUTION-HEURISTICALLY-DEFINED? heuristic subst)
  ;;a heuristic for determining when a substitution is defined assuming all the replacements are
  ;;defined.
  (every?
   (lambda (comp)
     (or (eq? (expression-sorting (target comp))
	      (expression-sorting (replacement comp)))
	 (theory-context-entails-defined-in-sort?
	  (matching-heuristic-context heuristic)
	  (replacement comp)
	  (expression-sorting (target comp))
	  2)))
   subst))

(define (SUBSTITUTION-HEURISTICALLY-MORE-GENERAL? heuristic subst1 subst2)
  (< ((matching-heuristic-generality-evaluator heuristic)  subst1)
     ((matching-heuristic-generality-evaluator heuristic)  subst2)))


(define (SUBSTITUTION-GENERALITY-SELECTOR heuristic substs)
  (iterate loop ((substs substs) (most-general-so-far '()))
    (cond ((null? substs) most-general-so-far)
	  ((or (null? most-general-so-far)
	       (substitution-heuristically-more-general?
		heuristic 
		(car substs)
		most-general-so-far))
	   (loop (cdr substs)
		 (car substs)))

	  (else (loop (cdr substs) most-general-so-far)))))


(define (COMPUTE-EXOSCOPES-ALONG-PATH host path exoscopes)
  (iterate iter ((host host)
		 (path path)
		 (pbvs exoscopes))
    (if (null? path)
	pbvs
	(receive (new-host new-path)
	  (host-and-path-after-step host path)
	  (iter
	   new-host
	   new-path
	   (if (universal? host)
	       (set-difference pbvs (expression-newly-bound-variables host))
	       (set-union pbvs (expression-newly-bound-variables host))))))))

(define (HEURISTIC-MATCH-PATTERNS-POSITIVELY-WITHIN-HOST heuristic expr host exoscopes depth)
  (let ((paths (paths-to-satisfaction
		host
		(lambda (subexpr)
		  (and (not (variable? subexpr))
		       (match-by-leading-constants? expr subexpr)))
		depth)))

    (iterate loop ((paths paths) (substs '()))
      (if (null? paths)
	  substs
	  (let ((path (car paths)))
	    (if (< (parity-at-path host path) 0)
		(loop (cdr paths) substs)
		(let* ((new-pattern (follow-path host path))

		       (exoscopes (compute-exoscopes-along-path host path exoscopes))
;;;			(set-union
;;;			 (non-universally-bound-variables-on-path host path) exoscopes)
		       (subst (match-under-exoscopes expr new-pattern exoscopes)))
		  (if (and (succeed? subst)
			   (substitution-heuristically-defined? heuristic subst))
		      (loop (cdr paths) (cons subst substs))
		      (loop (cdr paths) substs)))))))))


(define (LOCAL-MATCHES-WITHIN-EXPRESSION-AND-HOST heuristic expr host exoscopes depth)

  ;;returns a list of pairs 
  ;;(expr1 . subst) with expr1 a subexpression of expr and subst
  ;;a substitution which instantiates expr as a subexpression of host

  (remove-duplicates
   equal?
   (iterate loop ((expr expr)
		  (depth depth)
		  (exoscopes exoscopes))

    
     (cond ((= depth 0) '())
	   ((formal-symbol? expr) '())
	   ((substitution-generality-selector
	     heuristic
	     (heuristic-match-patterns-positively-within-host heuristic expr host exoscopes depth))
	    =>
	    (lambda (x) (list (cons expr x))))
	   ((quantification? expr)
	    (loop (binding-body expr)
		  (subtract1 depth)
		  (append exoscopes (binding-variables expr))))

	   (else 
	    (apply append (map (lambda (x) (loop x (subtract1 depth) exoscopes))
			       (expression-components expr))))))))
			
	   
(define (LOCAL-MATCHES-WITHIN-EXPRESSION-AND-CONTEXT-ASSUMPTIONS
	 heuristic
	 expr
	 context
	 depth
	 avoid)

  ;;;returns an alist made up of pairs (assum1 . partial-match)

  (bind (((matching-heuristic-context heuristic) context))

    (let ((exoscopes (context-free-variables context)))
      (iterate loop ((assums (set-difference (context-assumptions context) avoid)) (accum '()))
	(cond ((null? assums) accum)
	      ((local-matches-within-expression-and-host
		heuristic expr (car assums) exoscopes depth)
	       =>
	       (lambda (x)
		 (loop (cdr assums)
		       (cons (cons (car assums) x) accum))))
	      (else (loop (cdr assums) accum)))))))

(define (CONTEXT-ASSUMPTION-PARTIAL-MATCH-EVALUATIONS heuristic context expr depth avoid)
  (map (lambda (x) (cons
		    (car x)
		    ((matching-heuristic-partial-match-evaluator heuristic) (cdr x))))
       (local-matches-within-expression-and-context-assumptions heuristic expr context depth avoid)))

(define (FIND-BEST-MATCHING-ASSUMPTIONS heuristic context expr depth avoid)

  (let* ((local-matches
	  (context-assumption-partial-match-evaluations
	   heuristic
	   context
	   expr
	   depth
	   avoid))
	 (highest (if (null? local-matches) 0
		      (apply max (map (lambda (c) (cdr c)) local-matches)))))


    (iterate loop ((local-matches local-matches) (accum '()))
      (cond ((null? local-matches) accum)
	    ((= (cdar local-matches) highest)
	     (loop (cdr local-matches) (cons (car local-matches) accum)))
	    (else (loop (cdr local-matches) accum))))))



