;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald NAIVE-MATCHING)


;;;; Suppose EXPRESSION is one and BASE-LIST is a set of expressions, none of
;;;; which is a subexpression of another expression in BASE-LIST.  Then
;;;; RELATIVE-CONSTRUCTOR returns a function.  If the function is called on an
;;;; alist A that assigns expressions as values to the members of BASE-LIST (i.e.,
;;;; such that BASE-LIST is included (as a set) in (MAP CAR A)), then it will
;;;; return an expression like EXPRESSION, except that occurrences of expressions
;;;; in BASE-LIST are replaced by their associates in A.  In particular, if A
;;;; pairs each member of BASE-LIST with itself, the resulting expression is just
;;;; EXPRESSION.  Note that bound variables are not distinguished from free
;;;; variables (nor from constants) in the procedures.   
;;;
;;;; For efficiency, we cache these values in a table when we compute them. 
;;;
;;;(define (RELATIVE-CONSTRUCTOR expression base-list)
;;;  (let ((entry (table-entry *relative-constructors* expression)))
;;;    (cond ((ass set-equal? base-list entry)
;;;	   => cdr)
;;;	  (else
;;;	   (let ((rel-constr (compute-relative-constructor expression base-list)))
;;;	     (set 
;;;	      (table-entry *relative-constructors* expression)
;;;	      (cons
;;;	       (cons base-list rel-constr)
;;;	       entry))
;;;	     rel-constr)))))
;;;
;;;(define-operation relative-constructor-pattern)
;;;(define-operation relative-constructor-base-list)
;;;(define-predicate relative-constructor?)
;;;; The procedure to compute the relative constructor.  
;;;
;;;(define (COMPUTE-RELATIVE-CONSTRUCTOR expression base-list)
;;;  (let ((proc
;;;	 (cond
;;;	  ((memq? expression base-list)			;reached a base--
;;;	   (lambda (subst)				;function must return
;;;	     (cond ((fail? subst)(fail))
;;;		   ((substitution-find-replacement subst expression))
;;;		   (else
;;;		    expression))))
;;;	  ((and (any?
;;;		 (lambda (base)
;;;		   (proper-subexpression? base expression))
;;;		 base-list)				;base occurs, and
;;;		(expression-components expression))	;compound expr--
;;;	   =>						;get the rcs
;;;	   (lambda (components)				;for the 
;;;	     (let ((constructor				;components.
;;;		    (expression-constructor expression)) 
;;;		   (relatives (map
;;;			       (lambda (c) (relative-constructor c base-list))
;;;			       components)))
;;;	       (lambda (subst)
;;;		 (if (fail? subst)			;either fail or 
;;;		     (fail)				;fn must apply the
;;;		 (apply					;constructor after 
;;;		  constructor 				;the component rcs
;;;		  (map-fns relatives subst)))))))
;;;	  (else
;;;	   (lambda (()) expression)))))			;no occurrence--return
;;;							;constant fn.
;;;    (object proc
;;;      ((relative-constructor? self) '#t)
;;;      ((relative-constructor-pattern self) expression)
;;;      ((relative-constructor-base-list self) base-list))))
;;;      
;;;    
;;;
;;;(lset *RELATIVE-CONSTRUCTORS* (make-table '*relative-constructors*))
;;;; 
;;;; Returns a function which if called on an expr, either fails or returns 
;;;; a substitution which, when the relative constructor is applied, returns expr.
;;;; Thus, it's a kind of partial right inverse to rc, in that
;;;; ((rc e b)((rcm e b) e')) = e'
;;;; whenever ((rcm e b) e') does not fail.  
;;;; 
;;;
;;;(define-predicate rcm?)
;;;(define-operation (rcm-expression self)
;;;  (imps-error "RCM-EXPRESSION:  Non-rcm ~S" self))
;;;(define-operation (rcm-baselist self)
;;;  (imps-error "RCM-BASELIST:  Non-rcm ~S" self))
;;;
;;;(define (RELATIVE-CONSTRUCTOR-MATCHER expression base-list)
;;;  (let ((entry (table-entry *relative-constructor-matchers* expression)))
;;;    (cond ((ass set-equal? base-list entry)
;;;	   => cdr)
;;;	  (else
;;;	   (let ((matcher (compute-relative-constructor-matcher expression base-list)))
;;;	     (set 
;;;	      (table-entry *relative-constructor-matchers* expression)
;;;	      (cons
;;;	       (cons base-list matcher)
;;;	       entry))
;;;	       
;;;	     matcher)))))
;;;
;;;
;;;; We cache the values for this too.
;;;
;;;(define (COMPUTE-RELATIVE-CONSTRUCTOR-MATCHER expression base-list)
;;;  (let ((proc 
;;;	 (cond
;;;	  ((memq? expression base-list)
;;;	   (lambda (replacement)
;;;	     (if (sortings-compatible? expression replacement)
;;;		 (one-component-subst expression replacement)
;;;		 (fail))))
;;;	  ((expression-components expression)
;;;	   =>
;;;	   (lambda (components)
;;;	     (let ((constructor (expression-constructor expression))
;;;		   (relative-matchers
;;;		    (map
;;;		     (lambda (c) (relative-constructor-matcher c base-list))
;;;		     components)))
;;;	       (lambda (expr)
;;;
;;;		 (if (and (eq? constructor (expression-constructor expr))
;;;			  (= (length components)
;;;			     (length (expression-components expr))))
;;;;;;This is not right. If one of the substitutions contains a component 
;;;;;;(target . replacement) where replacement contains a free variable which is trapped.
;;;		     (let ((subst (apply
;;;				   join-substitutions
;;;				   (map-application relative-matchers
;;;						    (expression-components expr)))))
;;;
;;;		       subst)
;;;		     (fail))))))
;;;	  ((constant? expression)			; a constant matches only itself.
;;;	   (lambda (expr)
;;;	     (if (eq? expr expression)
;;;		 the-empty-substitution
;;;		 (fail))))
;;;	  (else
;;;	   (lambda (expr)
;;;	     (ignore expr)
;;;	     the-empty-substitution)))))
;;;    (object proc
;;;      ((rcm? self) '#t)
;;;      ((rcm-expression self) expression)
;;;      ((rcm-baselist self)   base-list))))
;;;
;;;(lset *RELATIVE-CONSTRUCTOR-MATCHERS* (make-table '*relative-constructor-matchers*))
;;;
;;;
;;;    
;;;
;;;
;;;; CURRENTLY UNUSED.
;;;;This function returns a function which constructs EXPRESSION
;;;;from the list of expressions BASE-LIST,
;;;;which should be a list of expressions none of which is (equal to or)
;;;;a subexpression of another expression in BASE-LIST
;;;;
;;;;
;;;;(define (POSITIONAL-RELATIVE-CONSTRUCTOR expression base-list)
;;;;  (cond
;;;;   ((find-position-in-list base-list expression)
;;;;    =>
;;;;    (lambda (n)
;;;;      (lambda (bases) (nth bases n))))
;;;;   ((expression-components expression)
;;;;    =>
;;;;    (lambda (components)
;;;;      (let ((constructor (expression-constructor expression))
;;;;	    (relatives (map
;;;;			(lambda (c) (positional-relative-constructor c base-list))
;;;;			components)))
;;;;	(lambda (bases)
;;;;	  (compound-expression
;;;;	   constructor
;;;;	   (map-fns relatives bases))))))
;;;;   (else
;;;;    (lambda (()) expression))))
;;;

(define (THEORY-TRIVIALLY-ENTAILS-SUBSTITUTION-DEFINED? theory subst)
  (and (succeed? subst)
       (every?
	(lambda (component)
	  (destructure (((target . repl) component))
	    (null?
	     (theory-critical-subterms-and-sorts
	      theory
	      repl
	     (expression-sorting target)))))
	subst)))

(define-operation (EXPRESSION-MATCHES? matcher expr strict?)

  ;;strict? can be #f , #t or a theory. This allows for using semantic information.

  (let ((subst (matcher expr)))
    (and (succeed? subst)
	 (or (not strict?)
	     (if (theory? strict?)
		 (theory-trivially-entails-substitution-defined? strict? subst)
		 (substitution-preserves-sort-inclusions? subst))))))

(define-operation (MATCHING-SUBEXPRESSION? matcher expr strict?)
  (if (expression-matches? matcher expr strict?)
      '#t
      (any? (lambda (x) (matching-subexpression? matcher x strict?))
	    (expression-components expr))))


(define-operation (PATHS-TO-MATCHES matcher expr depth-bound strict?)
  (ignore strict?)
  (paths-to-satisfaction expr (lambda (x) (succeed? (matcher x))) depth-bound))


(define (UNSAFE-MATCH expr pattern)
  (cond ((variable? pattern)
	 (if (sorts-may-overlap? (expression-sorting expr) (expression-sorting pattern))
	     (one-component-subst pattern expr)
	     (fail)))
	((constant? pattern) (if (eq? expr pattern) the-empty-substitution (fail)))
	((and (eq? (expression-constructor pattern)
		   (expression-constructor expr))
	      (= (length (expression-components pattern))
		 (length (expression-components expr))))
	 (apply join-substitutions
		(map (lambda (x y) (unsafe-match x y))
		     (expression-components expr)
		     (expression-components pattern))))
	(else (fail))))


(define-operation (matcher-expression self)
  (imps-error "MATCHER-EXPRESSION:  Non-matcher ~S" self))

(define (BUILD-EXPRESSION-MATCHER pattern)
  (object
      (lambda (expr)
	(match expr pattern))
    ((matcher-expression soi) pattern)))

(define (BUILD-EXPRESSION-MATCHER-UNSAFE pattern)
  (object
      (lambda (expr)
	(unsafe-match expr pattern))
    ((matcher-expression soi) pattern)))

