;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SUBSTITUTIONS)


;;; Presupposes '(resources sets) and '(expressions expressions).


;;; SUBSTITUTION COMPONENTS
;;;
;;; A "substitution component" is composed of two expressions 
;;; (a "target" and a "replacement") with identical sortings.

(lset *substitution-component-count* 0)

(define (MAKE-SUBST-COMPONENT targ repl)		;interfaced
  (increment *substitution-component-count*)
  (cons targ repl))
   

(define-constant TARGET					;interfaced
  car)

(define-constant REPLACEMENT				;interfaced
  cdr)

(define-integrable (SUBST-COMPONENT? candidate)		;interfaced
  (and (pair? candidate)
       (variable? (target candidate))
       (expression? (replacement candidate))))

;;; Used to contain:
;;;	  (same-sorted? (target candidate)
;;;		     (replacement candidate))


(define-constant SUBST-COMPONENTS-EQUAL?		;interfaced
  equal?)
       

;;; SUBSTITUTIONS

;;; A "substitution" is either (fail) or a list of substitution components no
;;; two of which have the same target.  A substitution component c is
;;; "compatible" with a substitution s if either c is already a component of s,
;;; or else the target of c is not equal to the target of any member of s.

(define-constant THE-EMPTY-SUBSTITUTION the-empty-set)	;interfaced

(define-constant EMPTY-SUBSTITUTION? empty-set?)

(define (SUBSTITUTION-FIND-COMPONENT sub target)                           ;interfaced
  (cond ((fail? sub) '#f)
	((assq target sub))
	(else '#f)))

(define (SUBSTITUTION-FIND-REPLACEMENT sub target)  
  (let ((sub-comp (substitution-find-component sub target)))
    (if sub-comp
	(replacement sub-comp)
	'#f)))

(define (ADD-SUBST-COMPONENT sub-comp sub)		;interfaced
  (if
   (sorting-skeletons-match? (expression-sorting (replacement sub-comp))
			     (expression-sorting (target sub-comp)))
   (let ((component
	  (substitution-find-component sub (target sub-comp))))
     (cond ((false? component)
	    (cons sub-comp sub))
	   ((alpha-equivalent? (replacement sub-comp)
		 (replacement component))
	    sub)
	   (else (fail))))
   (fail)))

(define-constant ADD-SUBSTITUTION-COMPONENT add-subst-component)

(define (IDENTITY-SUBSTITUTION vars)
  (let ((vars (imps-enforce
	       (object (lambda (vars)
			 (every? variable? vars))
		 ((print self port)
		  (format port "#{(lambda (vars) (every? variable? vars))}")))
	       (make-set vars))))
    (map
     (lambda (v)
       (make-subst-component v v))
     vars)))

(define (IDENTITY-SUBSTITUTION? subst)
  (every-subst-component?
   (lambda (comp)
     (eq? (target comp) (replacement comp)))
   subst))

(define (SUBSTITUTION-EXTEND main-subst default-subst)
  (if (or (fail? main-subst)
	  (fail? default-subst))
      (fail)
      (iterate iter ((main-subst main-subst)
		     (default-subst default-subst))
	(if (null? default-subst)
	    main-subst
	    (let ((new (add-subst-component
			(first-subst-component default-subst)
			main-subst)))
	      (iter
	       (if (fail? new)
		   main-subst
		   new)
	       (rest-of-subst default-subst)))))))

(define (SUBSTITUTION-EXTEND-WITH-IDENTITY main-subst identity-vars)
  (substitution-extend main-subst (identity-substitution identity-vars)))

(define (TARGETS-AND-REPLACEMENTS->SUBST targets replacements)
  (iterate iter ((subst the-empty-substitution)
		 (tars targets)
		 (replaces replacements))
    (cond ((fail? subst)(fail))
	  ((and (null? replaces)
		(null? tars))
	   subst)
	  ((null? replaces)
	   (imps-error "targets-and-replacements->subst: too many targets ~S~%~S"
		       targets replacements))
	  ((null? tars)
	   (imps-error "targets-and-replacements->subst: too many replacements ~S~%~S"
		       replacements targets))
	  (else
	   (iter
	    (add-subst-component
	     (make-subst-component (car tars)(car replaces))
	     subst)
	    (cdr tars)
	    (cdr replaces))))))	

(define-integrable (FIRST-SUBST-COMPONENT sub)		;interfaced
  (if (fail? sub)
      (imps-error "FIRST-SUBST-COMPONENT: failing substitution.")
      (car sub)))

(define (REST-OF-SUBST sub)				;interfaced
  (if (fail? sub)
      (imps-error "REST-OF-SUBST: failing substitution.")
      (cdr sub)))

(define (SUBST-DOMAIN sub)				;interfaced
  (if (fail? sub)
      nil
      (map target sub)))

(define (SUBST-RANGE sub)				;interfaced
  (if (fail? sub)
      nil
      (map replacement sub)))

(define (COMPONENT-OF-SUBST? sub-comp sub)		;interfaced
  (let ((component
	 (substitution-find-component sub (target sub-comp))))
    (and component
	 (eq? (replacement component)
	      (replacement sub-comp)))))

(define (DELETE-SUBST-COMPONENT sub-comp sub)		;interfaced
  (del equal? sub-comp sub))
  
;;; (SUBSTITUTION? candidate) is true if candidate is a non-failing
;;; substitution.  

(define (SUBSTITUTION? candidate)			;interfaced
  (or (empty-substitution? candidate)
      (let ((first (first-subst-component candidate))
	    (rest  (rest-of-subst candidate)))
	(and (subst-component? first)
	     (not (substitution-find-replacement rest (target first)))
	     (substitution? rest)))))

(define (SUB-SUBSTITUTION? sub1 sub2)
  (every-subst-component?
   (lambda (sub-comp)
     (let ((the-target (target sub-comp))
	   (the-replacement (replacement sub-comp)))
       (eq? the-replacement
	    (substitution-find-replacement sub2 the-target))))
   sub1))

(define (SUBSTITUTIONS-EQUAL? sub1 sub2)
  (and (sub-substitution? sub1 sub2)
       (sub-substitution? sub2 sub1)))

(define (SUBSTITUTION-COMPONENT-COMPATIBLE? sub-comp sub)
  (let ((the-target (target sub-comp))
	(the-replacement (replacement sub-comp)))
    (let ((the-existing-replacement
	   (substitution-find-replacement sub the-target))) 
      (or (false? the-existing-replacement)
	  (eq? the-replacement the-existing-replacement)))))

(define (ONE-COMPONENT-SUBST target replacement)
  (add-subst-component
   (make-subst-component target replacement)
   the-empty-substitution))

(define (JOIN-SUBSTITUTIONS . subs)			;interfaced
  (cond ((null? subs) the-empty-substitution)
	((null? (cdr subs)) (car subs))
	(else
	 (iterate iter ((so-far (join-two-substitutions (car subs) (cadr subs)))
			(rest (cddr subs)))
	   (cond ((null? rest) so-far)
		 ((fail? so-far) (fail))
		 (else (iter (join-two-substitutions (car rest) so-far)
			     (cdr rest))))))))

(define (JOIN-TWO-SUBSTITUTIONS sub1 sub2)
  (if
   (empty-substitution? sub2)
   sub1
   (iterate iter ((sub1 sub1)
		  (sub2 sub2))
     (cond ((or (fail? sub1)
		(fail? sub2))
	    (fail))
	   ((empty-substitution? sub1) sub2)
	   (else 
	    (iter (rest-of-subst sub1)
		  (add-substitution-component (first-subst-component sub1) sub2)))))))
      

(define (JOINABLE? sub1 sub2)
  (every-subst-component?
   (lambda (x)
     (substitution-component-compatible? x sub2))
   sub1))
  
(define EVERY-SUBST-COMPONENT? every?)                              ;interfaced

(define MAP-SUBSTITUTION map)					    ;interfaced

;;; Note that the following proposition holds:
;;;
;;; PROP.  If (and (subst-component? sub-comp)  
;;;                (substitution? sub)
;;;                (substitution-component-compatible? sub-comp sub)),
;;;        then (substitution? (add-subst-component sub-comp sub)).


;;; SUBST-INCLUSION? means that subst1 extends to subst2


(define SUBST-INCLUSION?
  sub-substitution?)

(define SUBST-EQUAL?
  substitutions-equal?)


(define (SUBSTITUTION-PRESERVES-SORTS? substitution)
  (every? (lambda (x)
	    (or (not (variable? (replacement x)))
		     (eq? (expression-sorting (target x))
			  (expression-sorting (replacement x)))))
	    substitution))


(define (SUBSTITUTION-PRESERVES-SORT-INCLUSIONS? substitution)
  (every? (lambda (x)
	    (sorting-leq (expression-sorting (replacement x))
			 (expression-sorting (target x))))
	    substitution))
