;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



;; Next comes the crucial security relevant fact that get%read%access
;; preserves simple security.  The proof goes as follows:  
;;
;; 1.  Unfold the definition of simply%secure.
;; 2.  Simplify
;; 3.  Unfold the definition of get%read%access.
;; 4.  Type capital D, for direct-and-antecedent-inference-strategy.
;; 5.  At the NEXT TO LAST node, do case-split-on-conditionals 0.
;; 6.  At the ungrounded subgoal, do case-split-on-conditionals 0 again.
;;
;; At step 5., the last node has the conditional in the context, rather
;; than in the assertion, where we can't exploit it as easily.


(def-script simply%secure-preserved 0			; Argument list for the script.
  ((unfold-single-defined-constant-globally simply%secure)
   simplify
   (unfold-defined-constants)
   (unfold-defined-constants)
   (prove-by-logic-and-simplification 0))
  (retrieval-protocol ())
  )

(def-script unfold-with-preference-to 1		; Argument list for the script.
  ((unfold-single-defined-constant-globally $1)
   simplify
   (unfold-defined-constants)
   (unfold-defined-constants)
   (prove-by-logic-and-simplification 0))
  (retrieval-protocol symbol-retrieval-protocol)
  )

(def-theorem get%read-preserves-simple-security
  "forall(s:state,u:user,o:object, 
   simply%secure(s) 
  implies
  simply%secure(get%read%access(s,u,o)));" 
  (theory access_records)
  (usages )
  (proof (
	  simply%secure-preserved))) 

(comment (proof ((unfold-single-defined-constant-globally simply%secure)
		 simplify
		 (unfold-single-defined-constant-globally get%read%access)
		 (prove-by-logic-and-simplification 0)
		 )))


;; Here are the corresponding theorems for del%read%access.  Proofs are
;; similar.  You will probably want to skip the proofs and simply evaluate
;; the forms.

(def-theorem del%read-preserves-simply%secure
  "forall(s:state, u:user, o:object, 
	simply%secure(s)
       implies
 	simply%secure(del%read%access(s,u,o)))" 
  (theory access_records)
  (usages )
  (proof (
	  simply%secure-preserved)))

(comment (proof (
		 (unfold-single-defined-constant-globally simply%secure)
		 simplify
		 (unfold-single-defined-constant-globally del%read%access)
		 (raise-conditional (0))
		 (unfold-single-defined-constant-globally without%read%access)
		 simplify)))

(def-theorem del%read-leaves-write-unchanged
  "forall(s:state,u,u_0:user, o,o_0:object,
	 access_write(del%read%access(s,u_0,o_0)(u,o))=access_write(s(u,o)))" 
  (theory access_records)
  (usages )
  ;; eliminate-definitions-and-simplify, d, case-split-on-conditionals.
  (proof (
	  simply%secure-preserved)))

(comment (proof ((unfold-single-defined-constant-globally del%read%access)
		 (unfold-single-defined-constant-globally without%read%access)
		 (raise-conditional (0))
		 simplify)))

;; Lo!  A Hack!  The following procedure does renaming to apply our
;; symmetry interpretation to all the new constants.  It will rename
;; someting SIMPLE to something STAR, etc.  

(define second-bl-renamer
  (compose (replace-substring-renamer "SIMPLE" "STAR")
	   (replace-substring-renamer "SIMPLY" "STAR")
	   (replace-substring-renamer "READ" "WRITE")))

;; Apply the renamer to the symmetry.  This creates the constants
;; with%WRITE%access, etc, down to STAR%secure.   

(def-transported-symbols
  (with%read%access
   without%read%access 
   del%read%access get%read%access simply%secure)
  (translation access_records-symmetry)
  (renamer second-bl-renamer))

;; Make the images of all of our convergence theorems and rewrites available in
;; the names-changed, dual versions.   This will cause Imps to beep twice,
;; which you can safely ignore.   

(transport-convergence-and-rewrite-theorems (name->translation 'access_records-symmetry))

;; Nothing to prove in the next three theorems: We just reap the benefits
;; of symmetry.  A def-theorem form with a TRANSLATION slot will check that
;; the translation is in fact an interpretation.  Then it checks that the
;; mentioned theorem is really a theorem of the source theory.  Finally, it
;; applies the translation to get a new formula, which it installs into the
;; target theory.

(def-theorem get%write-preserves-star-security
  get%read-preserves-simple-security
  (theory access_records)
  (translation access_records-symmetry)
  (proof existing-theorem))

(def-theorem get%write-leaves-read-unchanged
  get%read-leaves-write-unchanged
  (theory access_records)
  (translation access_records-symmetry)
  (theory access_records)
  (proof existing-theorem))

(def-theorem star%security-depends-on-write
  simple%security-depends-on-read
  (translation access_records-symmetry)
  (macete beta-reduce)
  (theory access_records)
  (proof existing-theorem))

;; Now here's the explicit definition of when a state is secure.  

(def-constant secure%state
 "lambda(f:state, simply%secure(f) and star%secure(f))"
  (theory access_records))

;; Call the image of secure%state under the symmetry 'state%secure. 


(def-transported-symbols secure%state
  (translation access_records-symmetry)
  (renamer (lambda (a) 'state%secure)))

;; Prove that state%secure and secure%state mean just the same.  To prove
;; it, use extensionality, unfold-defined-constants and simplify; then type
;; capital D.

(def-theorem state%secure-reverse
  "state%secure=secure%state" 
  (theory access_records)
  (proof (extensionality
	  unfold-defined-constants
	  (prove-by-logic-and-simplification 3))))

(def-compound-macete state-secure-and-simplify
  (series (repeat state%secure-reverse)
	  simplify))

;; Here's the main security lemma, asserting that get%read preserves the
;; secure%state property.  To prove it:
;;
;; 1.  Unfold secure%state and simplify.
;; 2.  Apply macete get%read-preserves-simple-security.
;; 3.  Type capital D.
;; 4.  Instantiate the theorem star%security-depends-on-write for the before
;;     state s and the after state get%read%access(s,u,o).
;; 5.  Contrapose, so you can prove the negation of assumption 0.
;; 6.  Now use macete get%read-leaves-write-unchanged .

(def-theorem get%read-preserves-security
  "forall(s:state, u:user, o:object, 
	  secure%state(s)
	 implies
	  secure%state(get%read%access(s,u,o)))" 
  (theory access_records)
  (usages )
  (proof ((unfold-single-defined-constant-globally secure%state)
	  simplify
	  (apply-macete-with-minor-premises get%read-preserves-simple-security)
	  direct-and-antecedent-inference-strategy
	  (instantiate-theorem star%security-depends-on-write ("s" "get%read%access (s,u,o)"))
	  (contrapose "with(o:object,u:user,o_$0:object,u_$0:user,s:state,
  not(access_write(s(u_$0,o_$0))
      =access_write(get%read%access(s,u,o)(u_$0,o_$0))));")
	  (apply-macete-with-minor-premises get%read-leaves-write-unchanged)
	  simplify-insistently)))

;; The dual is free:  

(def-theorem get%write-preserves-security
   get%read-preserves-security
  (theory access_records)
  (translation access_records-symmetry)
  (macete state-secure-and-simplify)
  (usages )
  (proof existing-theorem))

;; And here is the corresponding lemma for del%read, with its dual.  The proof
;; is very similar to the proof of get%read-preserves-security.  

(def-theorem del%read-preserves-security
  "forall(s:state, u:user, o:object, 
	secure%state(s)
       implies
 	secure%state(del%read%access(s,u,o)))" 
  (theory access_records)
  (usages )
  (proof ((unfold-single-defined-constant-globally secure%state)
	  simplify
	  direct-and-antecedent-inference-strategy
	  (apply-macete-with-minor-premises del%read-preserves-simply%secure)
	  (instantiate-theorem star%security-depends-on-write ("s" "(del%read%access(s,u,o))"))
	  (contrapose "with(o:object,u:user,o_$0:object,u_$0:user,s:state,
  not(access_write(s(u_$0,o_$0))
      =access_write(del%read%access(s,u,o)(u_$0,o_$0))));")
	  (apply-macete-with-minor-premises del%read-leaves-write-unchanged)
	  simplify-insistently
	  )))

(def-theorem del%write-preserves-security
  del%read-preserves-security
  (theory access_records)
  (translation access_records-symmetry)
  (macete state-secure-and-simplify)
  (usages )
  (proof existing-theorem))

;; One final piddling fact about typings.  Not worth proving in the exercise
;; (though it's easy to prove).  Just evaluate.  

(def-theorem get%read-typing 
  "#(get%read%access,[state,user,object,state])"
  (theory access_records)
  (usages rewrite)
  (proof (sort-definedness-and-conditionals
	  simplify-insistently)))

;; At this point we can introduce a sort containing the commands to the state
;; machine that we will define in a minute.  These commands are just the four
;; functions we've been examining, namely get%read%access, get%write%access,
;; del%read%access and del%write%access.  

(def-atomic-sort command
  "lambda(f:[state,user,object,state], 
		f=get%read%access or f=get%write%access
	     or f=del%read%access or f=del%write%access )" 
  (theory access_records)
  (witness "get%read%access"))

;; Here's a macete to use what we know about all the possible command cases.  

(def-compound-macete command-security-cases
  (series
   simplify
   del%read-preserves-security
   del%write-preserves-security
   get%read-preserves-security
   get%write-preserves-security
   simplify))



(def-theorem command-cases 
  "forall(f:command, f=get%read%access or f=get%write%access
	        or f=del%read%access or f=del%write%access)"
  (theory access_records)
  (proof (direct-inference
	  (instantiate-theorem command-defining-axiom_access_records ("f"))
	  simplify)))

;;  Introduce arithmetic, which is needed for the state machine instantiation,
;;  because state machine histories are functions defined on (some) natural
;;  numbers.   

(def-theory access_records-1 
  (component-theories access_records h-o-real-arithmetic))

;; We now introduce one more record type.  The inputs to our state machine will
;; be records consisting of a command, a user, and an object.  The user and the
;; object are in effect the parameters to the command.  We call these input
;; records "actions". 

(define action_records
  (make-record-theory-with-sortnames
   (name->theory 'access_records-1)
   'action
   '((command "command")
     (user    "user")
     (object  "object"))))

(set (current-theory) action_records)

;; The transition function on our state machine takes an action, destructuring
;; it to apply the command to the two parameters.  

(def-constant next
 "lambda(f:state, a:action,
	action_command(a)(f,action_user(a),action_object(a)))"
  (theory action_records))

;; "Next" is a total function returning a state.  To prove this, unfold next
;; and simplify.  Then do a direct inference, and instantiate the theorem
;; "command-in-quasi-sort_access_records" where the instance of interest is
;; action_command(a).  Four top-most nodes will be left, corresponding to the
;; four cases.  Simplification proves each.

(def-theorem action_records-next-definedness
  "forall(a:action,s:state,#(next(s,a),state))"
  (theory action_records)
  (usages d-r-convergence)
  (proof ((unfold-single-defined-constant-globally next)
	  simplify
	  (instantiate-theorem
	   command-in-quasi-sort_access_records
	   ("action_command(a)"))
	  simplify-insistently
	  simplify-insistently
	  simplify-insistently
	  simplify-insistently)))

;; This theory interpretation formalizes the sense in which the action_records
;; theory describes a state machine.  The fact that we needed to define *both*
;; tr and next is an artifact of the way the deterministic state machine theory
;; is built up, starting from a sub-theory where the transition is a
;; non-deterministic relation, and later considering the deterministic case, in
;; which tr is the graph of a function next.   The presence of both s_init and
;; the initial predicate is similar.  

(def-theory-ensemble-instances
  det-state-machines-with-start
  (target-theories action_records)
  (sorts (state state) (action action))
  (multiples 1)
  (theory-interpretation-check using-simplification)
  (constants
   (tr "lambda(s:state, a:action, s_1:state, next(s,a)=s_1)")
   (next next)
   (initial "lambda(f:state, f=s_init)")
   (s_init s_init)
   (accepting "lambda(f:state, falsehood)")))

;; The next translation formalizes the fact that action_records is an instance
;; of the theory used for the fundamental security theorem.  It has one boring
;; obligation which can also be found in the file
;; $IMPS/theories/state-machines/bl-exercise-obligations.t

(def-translation fts->action_records
  force
  (source fts-theory)
  (target action_records)
  (core-translation det-state-machines-with-start-to-action_records)
  (constant-pairs
   (secure%state secure%state))
  (theory-interpretation-check using-simplification))

;; The next two theorems are interpretation obligations, but they are in fact
;; the main content of the assertion that our state machine is secure.  The
;; first asserts that the initial state is secure.  To prove it,
;; eliminate-definitions and simplify; then simplify insistently.

;; Use macete "eliminate-definitions-and-simplify", and then insistent
;; simplification (on both subgoals).  

(def-theorem fts+invariant->actions-ob1
  "secure%state(s_init);"
  (theory action_records)
  (proof ((apply-macete-with-minor-premises eliminate-definitions-and-simplify)
	  simplify-insistently
	  simplify-insistently)))

;; Unfold next; type capital D; then instantiate theorem
;; command-defining-axiom_access_records with instance action_command(a).  Four
;; subgoals (the four cases) will be left.  Use macete command-cases on each
;; one.
;;
;; NB:  This is almost the only case in which the macete you need DOES NOT
;; appear on the macete menu.  This is because it begins with a  "simplify." 

(def-theorem fts+invariant->actions-ob2
  "forall(s:state, 
    secure%state(s) 
   implies
    forall(a:action, 
     secure%state(next(s,a))));"
  (theory action_records)
  (proof ((unfold-single-defined-constant-globally next)
	  direct-and-antecedent-inference-strategy
	  (instantiate-theorem command-cases ("action_command(a)"))
	  (apply-macete-with-minor-premises command-security-cases)
	  (apply-macete-with-minor-premises command-security-cases)
	  (apply-macete-with-minor-premises command-security-cases)
	  (apply-macete-with-minor-premises command-security-cases)
	  )))

(def-translation fts+invariant->action_records
  (source fts+invariant)
  (target action_records)
  (core-translation fts->action_records)
  (theory-interpretation-check using-simplification))

;; Here is the assertion that the state machine is secure:  Every accessible
;; state is a secure%state.  To prove it, just get tr%fts+secure off the macete
;; menu.

(def-theorem bell_lapadula-security 
  "forall(s:state, accessible(s) implies secure%state(s))"
  (theory action_records)
  (proof ((apply-macete-with-minor-premises tr%fts+secure))))


