;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald CONTEXT-INEQUALITIES)


;;Provides a test for INFEASIBILITY a set of linear inequalities.
;;That is if the test succeeds, then the set is inconsistent.

(define (fully-instantiated-in-context? context expr)
  (null? (set-difference (free-variables expr) (context-free-variables context))))

(define (CONTEXT-WALK-INEQUALITIES processor proc params)
  (let ((context (processor-parameters-context params)))
    (if (<r processor)
	(context-walk-entries-constructor-and-first-lead  
	 (lambda (expr)
	   (if (eq? (<r processor) (operator expr))
	       (proc expr)))
	 context 
	 apply-operator
	 (<r processor)))
    (if (<=r processor)
	(context-walk-entries-constructor-and-first-lead  
	 (lambda (expr)
	   (if (eq? (<=r processor) (operator expr))
	       (proc expr)))
	 context 
	 apply-operator
	 (<=r processor)))
    (return)))
	
(define (CONTEXT-WALK-NEGATED-INEQUALITIES processor proc params)
  (let ((context (processor-parameters-context params)))
    (if (<r processor)
	(context-walk-entries-constructor-and-first-lead  
	 (lambda (expr)
	   (let ((unnegated (car (expression-components expr))))
	     (if (and (application? unnegated)
		      (eq? (<r processor) (operator unnegated)))
		 (proc expr))))
	 context 
	 negation
	 (<r processor)))
    (if (<=r processor)
	(context-walk-entries-constructor-and-first-lead  
	 (lambda (expr)
	   (let ((unnegated (car (expression-components expr))))
	     (if (and (application? unnegated)
		      (eq? (<=r processor) (operator unnegated)))
		 (proc expr))))
	 context 
	 negation
	 (<=r processor)))
    (return)))

(define (CONTEXT-WALK-IMPLICIT-INEQUALITIES processor proc params)

  ;;walks through inequalities, negated inequalities and equalities.

  (let ((context (processor-parameters-context params))
	(persist (-1+ (processor-parameters-persistence params))))
    (let* ((checker (lambda (term)
		      ((prune-simplification context-entails-defined-in-sort?)
		       context
		       term
		       (base-sort processor)
		       persist))))	;Too much?


      (context-walk-inequalities processor proc params)


      (context-walk-negated-inequalities
       processor
       (lambda (expr)
	 (let ((applic (car (expression-components expr))))
	   (let ((lhs (1starg applic))
		 (rhs (2ndarg applic)))
	     (if  (and (checker lhs)
		       (checker rhs))
		  (cond ((and (eq? (operator applic) (<=r processor))
			      (not (null? (<r processor))))
			 (proc (apply-operator (<r processor) rhs lhs)))
			((and (eq? (operator applic) (<r processor))
			      (not (null? (<=r processor))))
			 (proc (apply-operator (<=r processor) rhs lhs)))
			(else '#f))))))
       params)

      (if (<=r processor)
	  (context-walk-equalities
	   (lambda (expr)
	     (let ((lhs (expression-lhs expr))
		   (rhs (expression-rhs expr)))
	       (if  (and (checker lhs)
			 (checker rhs))
		    (block (proc (apply-operator (<=r processor) lhs rhs))
			   (proc (apply-operator (<=r processor) rhs lhs))))))
	   context))
      (return))))


;;SOME inequality disjunctions (negated equalities and implications of inequalities)

(define (CONTEXT-WALK-NEGATED-EQUALITIES processor proc params)
  (let ((context (processor-parameters-context params))
	(persist (-1+ (processor-parameters-persistence params))))
    (let* ((checker (lambda (term)
		      ((prune-simplification context-entails-defined-in-sort?)
		       context
		       term
		       (base-sort processor)
		       persist))))
      (context-walk-negated-equalities-or-quasi-equalities
       (lambda (expr)
	 (let ((unnegated (car (expression-components expr))))
	   (if (and (checker (equivalence-lhs unnegated))
		    (checker (equivalence-rhs unnegated)))
	       (proc expr))))
       context))))

(define (CONTEXT-ADD-FULLY-INSTANTIATED-NEGATED-EQUALITIES
	 processor params inequalities)
  
  ;;;given a (conjunction) of inequalities returns a disjunction of conjunction of
  ;;;inequalities.

  (if (<r processor)
      (let ((context (processor-parameters-context params))
	    (persist (-1+ (processor-parameters-persistence params))))
	(let* ((disjunctions '())
	       (simplify (lambda (expr)
			   ((prune-simplification context-simplify) context expr persist))))
	       
	  (context-walk-negated-equalities
	   processor
	   (lambda (expr)
	     (if (fully-instantiated-in-context? context expr)
		 (let ((lhs (simplify (equivalence-lhs (car (expression-components expr)))))
		       (rhs (simplify (equivalence-rhs (car (expression-components expr))))))
		   (push disjunctions (list (apply-operator (<r processor) lhs rhs)
				 (apply-operator (<r processor) rhs lhs))))))
	   params)
	  (iterate loop ((disjunctions-of-conjuncts (list inequalities)) (disjunctions disjunctions))

	    (if (null? disjunctions)
		disjunctions-of-conjuncts
		(loop (append (map (lambda (conjunct)
				     (cons (caar disjunctions) conjunct))
				   disjunctions-of-conjuncts)
			      (map (lambda (conjunct)
				     (cons (cadar disjunctions) conjunct))
				   disjunctions-of-conjuncts))
		      (cdr disjunctions))))))
      disjunctions-of-conjuncts))

(define (CONTEXT-EXTRACT-FULLY-INSTANTIATED-INEQUALITIES processor params)
  (let ((context (processor-parameters-context params))
	(persist (-1+ (processor-parameters-persistence params))))
    (let* ((ineqs '())
	   (checker (lambda (term)
		      ((prune-simplification context-entails-defined-in-sort?)
		       context
		       term
		       (base-sort processor)
		       persist)))
	   (simplify (lambda (expr)
		       ((prune-simplification context-simplify) context expr persist))))

      
	    ;;;in following our heuristic technique of using instances of universally quantified
	    ;;;inequalities which occur in the target inequality
      
      (context-walk-inequalities
       processor
       (lambda (expr)
	 (if (fully-instantiated-in-context? context expr)
	     (let ((lhs (simplify (1starg expr)))
		   (rhs (simplify (2ndarg expr))))
	       (push ineqs (apply-operator (operator expr) lhs rhs)))))
       params)
      
      
      (context-walk-negated-inequalities
       processor
       (lambda (expr)
	 (if (fully-instantiated-in-context? context expr)
	     (let ((applic (car (expression-components expr))))
	       (let ((lhs (simplify (1starg applic)))
		     (rhs (simplify (2ndarg applic))))
		 (if  (and (checker lhs)
			   (checker rhs))
		      (cond ((and (eq? (operator applic) (<=r processor))
				  (not (null? (<r processor))))
			     (push ineqs (apply-operator (<r processor) rhs lhs)))
			    ((and (eq? (operator applic) (<r processor))
				  (not (null? (<=r processor))))
			     (push ineqs (apply-operator (<=r processor) rhs lhs)))
			    (else '#f)))))))
       params)
      
      (if (<=r processor)
	  (context-walk-equalities
	   (lambda (expr)
	     (if (fully-instantiated-in-context? context expr)
		 (let ((lhs (expression-lhs expr))
		       (rhs (expression-rhs expr)))
		   (if  (and (checker lhs)
			     (checker rhs))
			(let ((lhs (simplify lhs))
			      (rhs (simplify rhs)))
			  (block (push ineqs (apply-operator (<=r processor) lhs rhs))
				 (push ineqs (apply-operator (<=r processor) rhs lhs))))))))
	   context))
      (make-set ineqs))))	     

(define (CONTEXT-ADD-FULLY-INSTANTIATED-INEQUALITIES-AND-NEGATED-EQUALITIES
	 processor params inequalities)

  ;;;returns a disjunction of conjunctions of inequalities in the form
  ;;;((ineq11 ... ineq1k) ... (ineqj1 ... ineqjk) ... )

  (context-add-fully-instantiated-negated-equalities
   processor
   params
   (append (context-extract-fully-instantiated-inequalities processor params)
	   inequalities)))

(define (FILTER-DISCRETIZABLE-INEQUALITIES processor context ineqs)
  (map (lambda (x) (discretize-inequality processor context x)) ineqs))

(define (DISCRETIZE-INEQUALITY processor context ineq)
  (if (and (less-than? processor ineq)
	   (any?
	    (lambda (x)
	      (and ((prune-simplification context-immediately-entails-defined-in-sort?)
		    context (1starg ineq) x)
		   ((prune-simplification context-immediately-entails-defined-in-sort?)
		    context (2ndarg ineq) x)))
	    (processor-discrete-sorts processor))
	   (<=r processor))
      (apply-operator (<=r processor)
		      (apply-operator
		       (+r processor)
		       (1starg ineq)
		       (number->scalar-constant processor 1))
		      (2ndarg ineq))
      ineq))
  
;;;(define (COERCE-TO-MONOMIAL processor expr)
;;;  (cond ((and (multiplication? processor expr)
;;;	      (scalar-constant? processor (1starg expr)))
;;;	 (cons (2ndarg expr)
;;;	       (scalar-constant->numerical-object processor (1starg expr))))
;;;	(else (cons expr 1))))

(define (COERCE-TO-MONOMIAL processor expr)
  (cond ((and (multiplication? processor expr)
	      (let ((args (associative-arguments expr)))
		(if (scalar-constant? processor (car args))
		    args
		    '#f)))
	 =>
	 (lambda (args)
	   (cons (expression-alpha-root (form-product-expression processor (cdr args)))
		 (scalar-constant->numerical-object processor (car args)))))
	(else (cons expr 1))))

(define (COERCE-TO-MONOMIAL-OR-FIND-AND-INSTALL processor form expr)
  ;;;form is a list of monomials.
  ;;;coerces expr to monomial and installs in form.
  (let* ((monom (coerce-to-monomial processor (expression-alpha-root expr)))
	 ;;;see if a similar monomial (i.e., one with the same base)
	 ;;;already exists in the list form.
	 (find (assq (car monom) form)))
    (if find
	(block
	  (set (cdr find) (numerical-+ (cdr find) (cdr monom)))
	  form)
	(cons monom form))))


(define (COMPUTE-CONSTANT-TERM-FOR-EXPRESSION processor expr)
  (cond ((addition? processor expr)
	 (let ((args (associative-arguments expr)))
	   (iterate loop ((args args) (constants '()))
	     (cond ((null? args) (apply numerical-+ constants))
		   ((scalar-constant? processor (car args))
		    (loop (cdr args)
			  (cons (scalar-constant->numerical-object processor (car args))
				constants)))
		   (else (loop (cdr args) constants))))))
	((scalar-constant? processor expr)
	 (scalar-constant->numerical-object processor expr))
	(else 0)))
      

(define (COMPUTE-LINEAR-FORM-FOR-EXPRESSION processor expr)
  (cond ((addition? processor expr)
	 (let ((args (associative-arguments expr)))
	   (iterate loop ((args args) (form '()))
	     (cond ((null? args) form) 
		   ((scalar-constant? processor (car args))
		    (loop (cdr args) form))
		   (else

		    (loop (cdr args)
			  (coerce-to-monomial-or-find-and-install processor form (car args))))))))

;;;This was wrong.
;;;			       (cons (coerce-to-monomial processor (car args))
;;;				     form)

	((scalar-constant? processor expr)
	 '())
	(else (list (coerce-to-monomial processor (expression-alpha-root expr))))))

(define (COMPUTE-LINEAR-INEQUALITY-FOR-EXPRESSION processor expr)
  (cond ((or (less-than? processor expr)
	     (less-than-or-equals? processor expr))
	 ;;(let ((expr (replace-negatives-in-expression processor expr))))
	     
	 (let* ((op (if (less-than? processor expr) <
			<=))
		(lhs-form (compute-linear-form-for-expression processor (1starg expr)))
		(rhs-form (compute-linear-form-for-expression processor (2ndarg expr)))
		(lhs-constant
		 (compute-constant-term-for-expression processor (1starg expr)))
		(rhs-constant
		 (compute-constant-term-for-expression processor (2ndarg expr)))
		(lhs (build-linear-inequality
		      lhs-form
		      lhs-constant
		      op))
		(rhs (build-linear-inequality
		      rhs-form
		      rhs-constant
		      op)))
	   (inequality-subtract rhs lhs)))

	(else '#f)))

;;; LESS-THAN? returns #T if EXPR is an application and indicates
;;; a less-than comparison.

(define (LESS-THAN? processor expr)
  (and (application? expr) (eq? (operator expr) (<r processor))))

(define (LESS-THAN-OR-EQUALS? processor expr)
  (and (application? expr) (eq? (operator expr) (<=r processor))))

(define (INFEASIBLE-SET? processor exprs)
  (let ((ineqs (map (lambda (x)
		      (compute-linear-inequality-for-expression processor x))
		    (make-set exprs))))
    (linear-inequality-set-infeasible? ineqs)))

(define (CONTEXT-ENTAILS-LINEAR-INEQUALITY? processor expr params)
  (if (and (<r processor) (<=r processor)
	   (or (less-than? processor expr) (less-than-or-equals? processor expr)))


      (let ((context (processor-parameters-context params)))

  ;;;if expr is a linear relation
  
	(let* ((disjunction-ineqs
		(context-add-fully-instantiated-inequalities-and-negated-equalities
		 processor
		 params
		 (context-and-theory-inequality-instances-containing-hot-subterms
		  processor
		  expr
		  params))))

	   ;;;There is no need to check for the definedness of the arguments of expr
	   ;;;because if the reversed inequality neg-expr is infeasible then its arguments have to
	  ;;be defined.
	  (let ((neg-expr
		 (if (less-than? processor expr)
		     (apply-operator (<=r processor) (2ndarg expr) (1starg expr))
		     (apply-operator (<r processor) (2ndarg expr) (1starg expr)))))
	    (every?
	     (lambda (ineqs)
	       (infeasible-set?
		processor
		(filter-discretizable-inequalities
		 processor
		 context
		 (cons neg-expr ineqs))))
	     disjunction-ineqs))))

      '#f))


(define (CONTEXT-ENTAILS-LINEAR-EQUALITY? processor expr params)
  (let ((context (processor-parameters-context params)))
    (if (and (<r processor) (equation? expr))
	(let ((disjunction-ineqs
	       (map (lambda (ineqs)
		      (filter-discretizable-inequalities
		       processor
		       context
		       ineqs))
		    (context-add-fully-instantiated-inequalities-and-negated-equalities
		     processor
		     params
		     (context-and-theory-inequality-instances-containing-hot-subterms
		      processor
		      expr
		      params)))))

	  ;;There is no need to check for the definedness of the arguments of expr
	  ;;because if either inequality neg-1 or neg-2 is infeasible then the components
	  ;;of expr have to be defined.
	  (let ((neg-1 (discretize-inequality
			processor
			context
			(apply-operator (<r processor)
					(cadr (expression-components expr))
					(car (expression-components expr)))))
		(neg-2 (discretize-inequality
			processor
			context
			(apply-operator (<r processor)
					(car (expression-components expr))
					(cadr (expression-components expr))))))
	    (and (every? (lambda (ineqs)
			   (infeasible-set? processor
					    (cons neg-1 ineqs)))
			 disjunction-ineqs)
		 (every? (lambda (ineqs)
			   (infeasible-set? processor
					    (cons neg-2 ineqs)))
			 disjunction-ineqs))))


	'#f)))

(define (EQUALITY-OR-INEQUALITY-HOT-SUBTERMS processor expr)
  (cond ((or (less-than? processor expr)
	     (less-than-or-equals? processor expr))
	 (set-union (term-hot-subterms processor (1starg expr))
		    (term-hot-subterms processor (2ndarg expr))))
	
	 
	((equation? expr)
	 (set-union (term-hot-subterms processor (expression-lhs expr))
		    (term-hot-subterms processor (expression-rhs expr))))
	(else '())))

(define (TERM-HOT-SUBTERMS processor expr)
  (let ((MONOMIAL-HOT-SUBTERM
	 (lambda (expr)
	   (cond ((and (multiplication? processor expr)
		       (scalar-constant? processor (1starg expr)))
		  (2ndarg expr))
		 (else  expr)))))
    (cond ((addition? processor expr)
	   (let ((args (associative-arguments expr)))
	     (iterate loop ((args args) (form '()))
	       (cond ((null? args) form) 
		     ((scalar-constant? processor (car args))
		      (loop (cdr args) form))
		     (else (loop (cdr args)
				 (add-set-element
				  (monomial-hot-subterm (car args))
				  form)))))))
	  ((scalar-constant? processor expr) '())
	  (else (list (monomial-hot-subterm expr))))))

(define CONSULT-THEORY-INEQUALITIES?
  (make-simple-switch 'consult-theory-inequalities? boolean? '#t))

(define (CONTEXT-AND-THEORY-INEQUALITY-INSTANCES-CONTAINING-HOT-SUBTERMS
	 processor
	 expr
	 params)
  (if (< 0 (processor-parameters-persistence params))
      (let ((hot-terms (equality-or-inequality-hot-subterms processor expr)))
	(append
	 (context-inequality-instances-containing-hot-subterms processor hot-terms params)
	 (if (consult-theory-inequalities?)
	     (theory-inequality-instances-containing-hot-subterms
	      processor hot-terms params)
	     '())))
      '()))

(define (THEORY-WALK-INEQUALITIES processor proc theory)
  (if (<r processor)
      (walk-theory-theorems-matching-constructor-and-first-lead
       (lambda (thm)
	 (let ((expr (universal-matrix (theorem-formula thm) '())))
	   (if (eq? (<r processor) (operator expr))
	       (proc expr))))
       theory 
       apply-operator
       (<r processor)))
  (if (<=r processor)
      (walk-theory-theorems-matching-constructor-and-first-lead
       (lambda (thm)
	 (let ((expr (universal-matrix (theorem-formula thm) '())))
	   (if (eq? (<=r processor) (operator expr))
	       (proc expr))))
       theory 
       apply-operator
       (<=r processor)))
  (return))

(define (CONTEXT-INEQUALITY-INSTANCES-CONTAINING-HOT-SUBTERMS
	 processor
	 hot-terms
	 params)
  (if hot-terms
      (let ((persist (processor-parameters-persistence params))
	    (context (processor-parameters-context params))
	    (new-instances nil))
	(context-walk-implicit-inequalities
	 processor
	 (lambda (ineq)
	   (let ((ineq-hot-terms (equality-or-inequality-hot-subterms processor ineq)))
	     (walk (lambda (ineq-hot-term)
		     (walk (lambda (y)
			     (if (fully-instantiated-in-context? context y)

				 (let ((try ((prune-simplification context-match) context y ineq-hot-term persist)))
				   (if (succeed? try)
				       (let ((new (apply-substitution try ineq)))
					 (if (fully-instantiated-in-context? context new)
					     (push new-instances new)))))))
			   hot-terms))
		   ineq-hot-terms)))
	 params)
	(make-set new-instances))))

(define (THEORY-INEQUALITY-INSTANCES-CONTAINING-HOT-SUBTERMS
	 processor
	 hot-terms
	 params)
  (let ((context (processor-parameters-context params)))
    (if hot-terms
	(let ((new-instances nil))
	  (theory-walk-inequalities
	   processor
	   (lambda (ineq)

	     (let ((ineq-hot-terms (equality-or-inequality-hot-subterms processor ineq)))

	       (walk (lambda (x)

		       (if (subset? (free-variables ineq) (free-variables x))

			   ;;;This means the hot term x already contains all free
			   ;;;variables in the inequality ineq.
			   

			   (walk (lambda (y)
				   (let ((try (match y x)))

				     ;;;used to be ((prune-simplification context-match) context y x 1)
				     ;;;But in fact we only want to check
				     ;;;the definedness of the substitution in
				     ;;;the context. The matching is done
				     ;;;with null exoscopes.

				     (if (and (succeed? try)
					      ((prune-simplification context-strongly-entails-substitution-defined?)
					       context
					       try
					       0))
					
					 ;;this is put in to insure that the substitution
					 ;;makes some relevant substitution for each
					 ;;variable
					 (let ((new (apply-substitution try ineq)))

					   (push new-instances new)))))
				 hot-terms)))
		     ineq-hot-terms)))
	   (context-theory context))
	  (make-set new-instances)))))

