;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald instantiate-theorem)

(define (INSTANTIATE-THEOREM sqn theorem terms . no-antecedent-infs)
  (let ((formula (theorem-formula theorem)))
    (if (universal? formula)
	(instantiate-theorem-1 sqn formula terms no-antecedent-infs)
	(dg-primitive-inference-theorem-assumption sqn formula))))

(define (instantiate-theorem-1 sqn formula terms no-antecedent-infs)
  (let* ((subst (map cons (binding-variables formula) terms))
	 (instance (apply-substitution subst (binding-body formula)))
	 (sqn (precede-by-direct-or-antecedent-inferences sqn subst))
	 (context (sequent-node-context sqn))
	 (assertion (sequent-node-assertion sqn))
	 (subgoal
	  (post
	   (build-sequent
	    (context-add-assumption context instance)
	    assertion)
	   (sequent-node-graph sqn))))
    (invoke-if-necessary
     (dg-primitive-inference-cut sqn subgoal)
     (lambda (cut-infn)
       (or no-antecedent-infs
	   (selective-antecedent-inferences-strategy
	    (major-premise cut-infn)
	    (list instance)))
       (invoke-if-necessary
	(dg-primitive-inference-universal-instantiation
	 (inference-node-2nd-hypothesis cut-infn)
	 (post
	  (build-sequent context formula)
	  (sequent-node-graph sqn)))
	(lambda (inst-infn)
	  (let ((theorem-discharge
		 (dg-primitive-inference-theorem-assumption
		  (major-premise inst-infn)
		  formula)))
	    (cond ((inference-node? theorem-discharge)
		   (walk (deduction-graph-strategy-simplification-procedure)
			 (cdr (inference-node-hypotheses inst-infn)))
		   ((deduction-graph-strategy-simplification-procedure)
		    (car (inference-node-hypotheses theorem-discharge)))
		   cut-infn)
		  (else (imps-warning
			 "instantiate-theorem: discharge of \"theorem\" ~S failed:  what gives?"
			 formula)
			(fail))))))))))

(define (instantiate-universal-antecedent-once sqn assumption terms)
  (instantiate-universal-antecedent-multiply sqn assumption (list terms)))

(define (instantiate-universal-antecedent-multiply sqn assumption terms-s)
  (let ((givens (sequent-node-assumptions sqn)))
    (iterate iter ((sqn sqn)
		   (infn (fail))
		   (terms-s terms-s))
      (if (null? terms-s)
	  (invoke-if-necessary
	   infn
	   (lambda (infn)
	     (invoke-if-necessary
	      (dg-primitive-inference-weakening
	       (major-premise infn)
	       (list assumption))
	      (lambda (weak-infn)
		(let ((major (major-premise weak-infn)))
		  (selective-antecedent-inferences-strategy
		   major
		   (set-difference (sequent-node-assumptions major) givens)))))))
	  (let ((infn
		 (instantiate-universal-antecedent sqn assumption (car terms-s))))
	    (cond ((fail? infn) (iter sqn retn-infn (cdr terms-s)))
		  ((null? (inference-node-hypotheses infn)) infn)
		  (else (iter (major-premise infn) infn (cdr terms-s)))))))))
       
  
(define (INSTANTIATE-UNIVERSAL-ANTECEDENT sqn assumption terms)
  (let ((graph (sequent-node-graph sqn))
	(subst (targets-and-replacements->subst
		(binding-variables assumption)
		terms)))
    (if
     (fail? subst)
     (imps-error "instantiate-universal-antecedent: type mismatch between terms and bound variables.")
     (let ((instance
	    (apply-substitution-fastidiously
	     subst 
	     (binding-body assumption)))
	   (sqn (precede-by-direct-or-antecedent-inferences sqn subst)))
       (invoke-if-necessary
	(dg-primitive-inference-cut
	 sqn 
	 (post (build-sequent
		(context-add-assumption
		 (sequent-node-context sqn)
		 instance)
		(sequent-node-assertion sqn))
	       graph))
	(lambda (cut-infn)
	  (invoke-if-necessary
	   (dg-primitive-inference-universal-instantiation
	    (inference-node-2nd-hypothesis cut-infn)
	    (post
	     (build-sequent (sequent-node-context sqn) assumption)
	     graph))
	   (lambda (ui-infn)
	     ;;
	     ;; First simplify the sort-definedness conditions.
	     ;; 
	     (map (deduction-graph-strategy-simplification-procedure)
		  (cdr (inference-node-hypotheses ui-infn)))
	     ;;
	     ;; Then knock off the universal assertion, which should belong to the context
	     ;;
	     (dg-primitive-inference-simplification (major-premise ui-infn))
	     ;(dg-primitive-inference-weak-simplification (major-premise ui-infn))
	     cut-infn))))))))

(define (instantiate-existential sqn terms)
  (let* ((assertion (imps-enforce existential? (sequent-node-assertion sqn)))
	 (subst (targets-and-replacements->subst (binding-variables assertion) terms)))
    (if (fail? subst) 
	(fail)
	(let ((sqn (precede-by-direct-or-antecedent-inferences sqn subst)))
	  (invoke-if-necessary
	   (dg-primitive-inference-existential-generalization
	    sqn
	    (post
	     (build-sequent
	      (sequent-node-context sqn)
	      (apply-substitution-fastidiously
	       (targets-and-replacements->subst (binding-variables assertion) terms)
	       (binding-body assertion)))
	     (sequent-node-graph sqn)))
	   (lambda (gen-inf)
	     (walk (lambda (x)
		     ((deduction-graph-strategy-simplification-procedure) x))
		   (cdr (inference-node-hypotheses gen-inf)))
	     (prove-by-direct-inference (major-premise gen-inf) (make-strategy-parameters))
	     gen-inf))))))
