;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald ELEMENTARY-MACETES)


(define-operation (MACETE-REQUIREMENTS soi))


;;(define-operation (MACETE-MATCHER soi))
(define-operation (ELEMENTARY-MACETE-LHS soi))
(define-operation (ELEMENTARY-MACETE-RHS soi))
(define-operation (MACETE->FORMULA soi))
(define ELEMENTARY-MACETE->FORMULA macete->formula)
(define-operation (MACETE-REPLACEMENT-CONSTRUCTOR soi))
(define-predicate ELEMENTARY-MACETE?)
(define-predicate SAFE-ELEMENTARY-MACETE?)

(lset *elementary-macetes* (make-table '*elementary-macetes*))

(define (RETRIEVE-MACETE-FROM-FORMULA formula)
  (table-entry *elementary-macetes* formula))


;;;In the case of a theorem: "BLAH implies t_1=t_2", if t_2 contains free
;;;variables not in t_1, instead of trying to replace (match of) t_1 with t_2 (almost
;;;always a disaster) try to replace (match of) t_2 with (match of) t_1,
;;;unless t_1 contains free variables not in t_2. In that case, backchain
;;;from "t_1=t_2" to BLAH.

(define (fstrb-for-equivalence body lhs rhs reqs)
  (if (set-diff (free-variables rhs) (free-variables lhs))
      (if (set-diff (free-variables lhs) (free-variables rhs))
	  (return body (conjunction-simplifier reqs) '() '#f)
	  (return rhs lhs reqs '#t))
      (return lhs rhs reqs '#t)))

(define (FORMULA-SOURCE-TARGET-REQUIREMENTS-BIDIRECTIONAL formula)
  (let ((body (universal-matrix-respecting-qcs (expression-alpha-root formula) '())))
    (receive (source target requirements bidirectional?)
      (cond ((quasi-equation? body)
	     (fstrb-for-equivalence
	      body
	      (quasi-equation-lhs body)
	      (quasi-equation-rhs body)
	      '()))
	    ((quasi-constructor?
	      (expression-quasi-constructor-if-enabled-or-constructor body))
	     (return body
		     (the-true)
		     '()
		     '#t))
	    ((equation? body)
	     (fstrb-for-equivalence
	      body
	      (expression-lhs body)
	      (expression-rhs body)
	      '()))
	    ((biconditional? body)
	     (return (expression-lhs body)
		     (expression-rhs body)
		     '()
		     '#t))
	    ((implication? body)
	     (iterate loop  ((rhs (expression-rhs body))
			     (reqs (ultimate-conjuncts (list (expression-lhs body)))))
	       (cond ((quasi-equation? rhs)
		      (fstrb-for-equivalence
		       rhs
		       (quasi-equation-lhs rhs)
		       (quasi-equation-rhs rhs)
		       reqs))
		     ((quasi-constructor?
		       (expression-quasi-constructor-or-constructor rhs))
		      (return rhs
			      (conjunction-simplifier reqs)
			      '()
			      '#f))
		     ((equation? rhs)
		      (fstrb-for-equivalence
		       rhs
		       (expression-lhs rhs)
		       (expression-rhs rhs)
		       reqs))
		     ((biconditional? rhs)
		      (return (expression-lhs rhs)
			      (expression-rhs rhs)
			      reqs
			      '#t))
;;;		   ((negation? rhs)
;;;		    (return (negation-body rhs)
;;;			    falsehood
;;;			    reqs
;;;			    '#t))
		     ((implication? rhs)
		      (loop (expression-rhs rhs)
			    (set-union reqs
				       (ultimate-conjuncts
					(list (expression-lhs rhs))))))

		     ((and (universal? rhs)
			   (empty-set? (set-intersection
					(big-u (set-map free-variables reqs))
					(newly-bound-variables rhs))))
		      (loop (universal-matrix-respecting-qcs rhs '()) reqs))
		     (else (return rhs
				   (conjunction-simplifier reqs)
				   '()
				   '#f)))))
	    ((negation? body)
	     (return (negation-body body)
		     falsehood
		     '()
		     '#t))
	    (else (return body
			  (the-true)
			  '()
			  '#t)))
      (let* ((dangling-vars 
	      (and (formula? target)
		   (set-diff (free-variables target) (free-variables source))))
	     (proper-dangling-vars  (and dangling-vars 
					 (or (not bidirectional?)
					     (every?
					      (lambda (x) (null? (intersection dangling-vars (free-variables x))))
					      requirements)))))

	;;if there is a dangling variable v and the macete is bidirectional
	;;we want to make sure that v does not occur freely in any requirement.
	;;

	(if proper-dangling-vars
	    (return source (apply forsome target dangling-vars) requirements bidirectional?)
	    (return source target requirements bidirectional?))))))


(define (BUILD-ELEMENTARY-MACETE formula the-name safe?)

  (cond ((table-entry *elementary-macetes* formula)
	 =>
	 (lambda (mac) (set (macete-name mac) the-name) mac))
	(else
	 (receive (source target requirements bidirectional?)
	   (formula-source-target-requirements-bidirectional formula)
	   (let ((macete
		  (build-elementary-macete-internal
		   source
		   target
		   requirements
		   formula
		   the-name
		   safe?
		   bidirectional?)))
	     (set (table-entry *elementary-macetes* formula) macete)

	     macete)))))

(define (APPLY-SUBSTITUTION-UNSAFE sub exp)
  (cond ((constant? exp) exp)
	((variable? exp)				
	 (let ((repl (substitution-find-replacement sub exp)))
	   (or repl exp)))
	(else (apply (expression-constructor exp)
		     (map (lambda (x) (apply-substitution-unsafe sub x))
			  (expression-components exp))))))

(define (BUILD-ELEMENTARY-MACETE-INTERNAL
	 source
	 target
	 requirements
	 formula
	 the-name
	 safe?
	 bidirectional?)
  (let* ((jointly-exposed-vars
	  (if bidirectional?
	      (jointly-exposed-variables source target)
	      (exposed-variables target)))
	 
	 ;;if the macete is a backchaining macete and a variable is exposed in the target
	 ;;then if this substituted by an undefined term, the resulting formula is
	 ;;falsehood. However, it is legitimate to backchain to falsehood.
	 
	 (matcher (if safe?
		      (build-expression-matcher source)
		      (build-expression-matcher-unsafe source)))

	 ;;a function which if called on  EXPR, either fails or returns 
	 ;;a substitution which, says how to construct EXPR from source
	 ;;by the relative-constructor

	 (replacement-constructor
	  (lambda (theory context expr)		;returns two values
	    (ignore context theory)
	     (let ((subst (matcher expr)))
	       ;;fail if SUBST is fail.
	       (if (fail? subst)
		   (return (fail) '())
		   (let ((substed (if safe?
				      (apply-substitution subst target)
				      (apply-substitution-unsafe subst target)))
		     ;;try making substitutions for target.
			 (req-substed
			  (map (lambda (x) (apply-substitution subst x)) requirements)))
		   ;;try making substitutions for requirements.
		     (if (or (null? substed) (any? null? req-substed))
			 (return (fail) '())
			 (return substed
				 (if safe?
				     (append
				      (restricted-substitution-definedness-conditions
				       subst jointly-exposed-vars)
					;the definedness of the substitution produced by
					;the matcher has to be checked!
				      req-substed)
				     req-substed))))))))
	 (local-macete
	  (syntactic-procedure->macete
	   replacement-constructor
	   bidirectional?
	   the-name)))
    
    (join
      (object nil
	
	((elementary-macete? soi) '#t)
	((macete->formula soi) formula)
;;	((macete-matcher soi) matcher)
	((elementary-macete-lhs soi) source)
	((elementary-macete-rhs soi) target)
	((macete-requirements soi) requirements)
	((macete-replacement-constructor soi) replacement-constructor)
	((paths-to-matches macete expr depth-bound strict?)
	 (paths-to-matches matcher expr depth-bound strict?))
	((expression-matches? macete expr strict?)
	 (expression-matches? matcher expr strict?))

	((matching-subexpression? macete expr strict?)
	 (matching-subexpression? matcher expr strict?))
	((safe-elementary-macete? soi) safe?)
	((macete-sound-in-theory? soi theory) 
	 (and safe? (theory-theorem? theory formula)))

	((macete-name soi) (macete-name local-macete))

	((print soi port) (format port "#{Elementary-macete ~a ~a}"
				  (object-hash soi)
				  (macete-name soi))))
	
      local-macete)))

(define ELEMENTARY-MACETE->THEOREM elementary-macete->formula)

(define (SYNTACTIC-PROCEDURE->MACETE proc bidirectional? the-name)
  ;;proc should be a procedure of A THEORY, a CONTEXT and an imps expression EXPR
  ;;which returns two values 
  ;; either
  ;;  [1] an expr
  ;;  [2] a list of assertions
  ;;  (or validity requirements, similar to convergence requirements)
  ;;or
  ;;  [1] (fail)
  ;;  [2] ()

  (labels
      
      ((attempt-macete-at-path
	(lambda (path context subexpr host)
	  ;;subexpr should be subexpression of expr pointed to by path
	  ;;Explicitly including subexpr as an argument avoids recomputation.
	  (let ((new-host
		 (apply-procedure-at-virtual-path proc context host path bidirectional?)))
	    (cond ((eq? new-host host) (delve-deeper path context subexpr host))
		  ;;if host does not change plunge further down
		  (else new-host)))))
       ;;don't make any additional changes in
       ;;subexpressions of host at path.
	      
       (delve-deeper
	
	(lambda (path context subexpr host)
	  (iterate loop
	      ((components (expression-quasi-components-if-enabled-or-components subexpr))
	       (host host)
	       (index 0))
	    (if (null? components)
		host
		(let ((new-host 
		       (attempt-macete-at-path (append path (list index))
					       context
					       (car components)
					       host)))
		  (loop (cdr components)  new-host (1+ index)))))))
	      
       (macete-builder-proc
	(lambda (context expr) (attempt-macete-at-path '() context expr expr))))
	      	 
    (build-macete macete-builder-proc bidirectional? the-name)))

;;;(define (THEORY-BUILD-MACETE theory the-name formula) ;;is now obsolete
;;;  (ignore theory)
;;;  (add-macete the-name formula))

;;;(define (THEORY-BUILD-UNSAFE-MACETE theory the-name formula);;is now obsolete
;;;  (ignore theory)
;;;  (add-unsafe-macete the-name formula))

(define (THEORY-INSTALL-ELEMENTARY-MACETE theory theorem);;is now obsolete
  (ignore theory)
  (install-elementary-macete theorem))


(define (ADD-ELEMENTARY-MACETE the-name formula)
  (add-macete (build-elementary-macete formula the-name '#t)))

(define (ADD-UNSAFE-ELEMENTARY-MACETE the-name formula)
  (add-macete (build-elementary-macete formula the-name '#f)))

(define (INSTALL-ELEMENTARY-MACETE theorem)
  (let ((the-name (theorem-name theorem))
	(formula (theorem-formula theorem)))
    (add-elementary-macete the-name formula)))


(define (THEOREM->ELEMENTARY-MACETE theorem)
  (table-entry *elementary-macetes* (theorem-formula theorem)))

(define (APPLY-PROCEDURE-AT-PATH proc context expr path bidirectional?)
  (if (not (or bidirectional? (path-to-positive-location? expr path)))
      expr
      (let ((subexpr (follow-path expr path))
	    (context (local-context-at-path context expr path)))
	(receive (pass reqs)
	  (proc (context-theory context) context subexpr)
	  ;;apply matching routines to subexpr.
	  (cond ((fail? pass) expr);; don't change expr
		;;even if matching succeeds,
		;;check that all requirements hold in local context
		((tc-vigorously-prove-requirements context reqs)
		 (substitution-at-path expr pass path))
		(else expr))))))

(define (APPLY-PROCEDURE-AT-PATHS proc context expr paths bidirectional?)
  (let ((paths (extract-minimal-disjoint-paths paths)))
    (iterate loop ((expr expr) (paths paths))
      (if (null? paths)
	  expr
	  (loop (apply-procedure-at-path proc context expr (car paths) bidirectional?)
		(cdr paths))))))

(define (APPLY-PROCEDURE-AT-VIRTUAL-PATH proc context expr path bidirectional?)
  (if (not (or bidirectional?
	       (every? (lambda (p) (path-to-positive-location? expr p))
		       (expand-virtual-path expr path))))
      expr
      (let ((subexpr (follow-virtual-path-safely expr path)))
	(if subexpr
	   (let ((context (local-context-at-virtual-path context expr path)))
	     (receive (pass reqs)
	       (proc (context-theory context) context subexpr)
	       ;;apply matching routines to subexpr.
	       (cond ((fail? pass) expr);; don't change expr
		     ;;even if matching succeeds,
		     ;;check that all requirements hold in local context
		     ((tc-vigorously-prove-requirements context reqs)
		      (substitution-at-virtual-path expr pass path))
		     (else expr))))
	   expr))))
    
					  
					   
