;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald RESTRICTED-SUBSTITUTION-DEFINEDNESS)


(define (EXPOSED-VARIABLES expr)
  (if (expression-of-category-prop? expr)
      (apply append (map exposed-variables-for-atomic-formula
			 (ultimate-conjuncts (list expr))))
      (exposed-variables-for-expression-of-kind-ind expr)))

(define (exposed-variables-for-atomic-formula expr)
  (if (or (equation? expr)
	  (application? expr)
	  (conjunction? expr)
	  (convergence? expr)
	  (convergence-in-sort? expr))
      (apply append (map exposed-variables-for-expression-of-kind-ind
			 (expression-components expr)))
      '()))

(define (exposed-variables-for-expression-of-kind-ind expr)
  (if (expression-of-category-ind? expr)
      (if (variable? expr)
	  (list expr)
	  (if (application? expr)
	      (apply append (map exposed-variables-for-expression-of-kind-ind
				 (expression-components expr)))
	      '()))
      '()))

(define (JOINTLY-EXPOSED-VARIABLES expr1 expr2)
  (intersection (exposed-variables expr1) (exposed-variables expr2)))

(define (RESTRICTED-SUBSTITUTION-DEFINEDNESS-CONDITIONS subst exposed-vars)
  (receive (check-definedness check-sort)
    ;walk through substitution components determining whether definedness or sort
    ;has to be checked:
    (iterate loop ((check-definedness '())
		   (check-sort '())
		   (rem-subst subst))
      (cond ((null? rem-subst) (return check-definedness check-sort))
	    ((memq? (caar rem-subst) exposed-vars)
	     ;don't need to check definedness in this case: only need to
	     ;know that if expr is defined then it has the same sort 
	     ;trivial case: expression-sorting of replacement (cdar rem-subst) is included in
	     ;expression sorting of target (caar rem-subst).
	     (loop check-definedness
		   (if (sorting-leq (expression-sorting (cdar rem-subst))
				    (expression-sorting (caar rem-subst)))
		       check-sort
		       (cons (car rem-subst) check-sort))
		   ;check only sort and then only if not obviously correct.
		   (cdr rem-subst)))
	    (else (loop (cons (car rem-subst) check-definedness)
			check-sort
			(cdr rem-subst)))))
    (append (map (lambda (x) (in-sort-if-defined (cdr x) (expression-sorting (car x))))
		 check-sort)
	    (substitution-definedness-conditions check-definedness))))

(define (IN-SORT-IF-DEFINED term sort)
  (if (predicate? term)
      (the-true)
      (implication (is-defined term) (defined-in term sort))))
