;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald REWRITE-RULES)


;;;a rule is pair of expressions (expr1 . expr2).
;;;a rewrite-rule is a transform:
;;;Its procedure component takes EXPR and applies rule RULE to it.

(define *rewrite-rules-table* (make-table '*rewrite-rules-table*))

;;; a table of rewrite rules indexed by theorems. Each theorem has a LIST of rules.

(define-settable-operation (SIMPLIFY-LOGICALLY-FIRST? rule))

(define-operation (REWRITE-RULE-LHS rule))
(define-operation (REWRITE-RULE-RHS rule))
(define-predicate REWRITE-RULE?)
(define-operation (REWRITE-RULE-FORMULA rule))
(define-settable-operation (REWRITE-RULE-TRIGGER rule))


(define (MAKE-REWRITE-RULE formula rule)
  (let ((simp-comps? '#f)
	(trigger (lambda (context reqs persist subst)
		   (ignore subst)
		   (return 
		    (bind (((accumulate-undischarged-minor-premises?) '#f))
		      (tc-prove-requirements context reqs persist))
		    '()))))
    (imps-enforce expression? (car rule))
    (imps-enforce expression? (cdr rule))
  
    (let ((jointly-exposed-vars (jointly-exposed-variables (car rule) (cdr rule))))
      (object
	  (lambda (context expr persist)
	    (let ((expr (if simp-comps? 
			    (simplify-logically context expr persist)
			    expr)))
	      (let ((subst-alist (match expr (car rule))))
		(if (fail? subst-alist)
		    (return expr '() '#f)
		    (let ((reqs
			   (restricted-substitution-definedness-conditions
			    subst-alist
			    jointly-exposed-vars)))
		      (receive (fire? remaining-reqs)
			(trigger context reqs persist subst-alist)
			(if fire?
			    (return
			     (apply-substitution subst-alist (cdr rule))
			     remaining-reqs
			     '#f)
			    (return expr '() '#f))))))))
      
	(((setter simplify-logically-first?) soi new-val) 
	 (set simp-comps? new-val))
	((simplify-logically-first? soi) simp-comps?)
	(((setter rewrite-rule-trigger) soi new-val) 
	 (set trigger new-val))
	((rewrite-rule-trigger soi) trigger)
	((rewrite-rule-lhs soi) (car rule))
	((rewrite-rule-rhs soi) (cdr rule))
	((rewrite-rule-formula rule) formula)
	((rewrite-rule? soi) '#t)))))


;;;(let ((subst-alist (match expr (car rule))))
;;;		(if (fail? subst-alist)
;;;		    (return expr '() '#f)
;;;		    (return
;;;		     (apply-substitution subst-alist (cdr rule))
;;;		     (restricted-substitution-definedness-conditions
;;;		      subst-alist
;;;		      jointly-exposed-vars)
;;;		     '#f)))
      
;;;      (let* ((arglist 
;;;	      (map
;;;	       (lambda (k)
;;;		 (simplify-by-transforms context k persist))
;;;	       (arguments expr)))
;;;	     (reduced-expr
;;;	      (apply apply-operator (operator expr) arglist))
;;;	     (subst-alist (match reduced-expr (car rule))))
;;;	(if (fail? subst-alist)
;;;	    (return reduced-expr '() '#t)
;;;	    (return
;;;	     (apply-substitution subst-alist (cdr rule))
;;;	     (restricted-substitution-definedness-conditions
;;;	      subst-alist
;;;	      jointly-exposed-vars)
;;;	     '#t)))


(define (THEORY-INSTALL-REWRITE-RULE theory theorem)
  (let ((formula (theorem-formula theorem)))
    (set (table-entry *rewrite-rules-table* theorem)
	 (build-and-install-rewrite-rules-from-formula theory formula))))

(define (THEORY-ADD-REWRITE-RULE theory formula rule)
  (let ((rewrite-rule (make-rewrite-rule formula rule))
	(constr (expression-quasi-constructor-or-constructor (car rule)))
	(lead (expression-lead-constant (car rule))))
    (theory-install-transform theory constr lead rewrite-rule)
    (install-transform-as-rewrite-rule rewrite-rule)
    (theory-install-transform-in-algebraic-processors theory rewrite-rule)
    rewrite-rule))

(define (BUILD-AND-INSTALL-REWRITE-RULES-FROM-FORMULA theory formula) 
  (let ((body (universal-matrix formula '())))
    
    (cond ((conjunction? body)
	   (big-u
	    (map (lambda (x) (build-and-install-rewrite-rules-from-formula theory x))
		 (ultimate-conjuncts (list body)))))

	  ((or (equation? body)
	       (quasi-equation? body)	; This was added Thu Aug 30 15:02:50 EDT 1990.
	       (biconditional? body))
	   (let ((source (if (quasi-equation? body) (quasi-equation-lhs body)
			     (expression-lhs body)))
		 (target (if (quasi-equation? body) (quasi-equation-rhs body)
			     (expression-rhs body))))
	     (cond ((equation? source)
		    (list (theory-add-rewrite-rule theory formula (cons source target))))
		   ((negated-equation? source)
		    (build-and-install-rewrite-rules-from-formula
		     theory
		     (biconditional (negation-body source)
				    (negation target))))
		   (else
		    (list (theory-add-rewrite-rule theory formula (cons source target)))))))
	  ((negation? body)
	   (build-and-install-rewrite-rules-from-formula
	    theory
	    (biconditional (negation-body body) falsehood)))
	  (else
	   (build-and-install-rewrite-rules-from-formula
	    theory
	    (biconditional body truth))))))



(define (REWRITE-USAGE-SIMPLOG1ST theorem)
  (let ((transforms (table-entry *rewrite-rules-table* theorem)))
    (walk
     (lambda (transform)
       (if (rewrite-rule? transform)
	   (set (simplify-logically-first? transform) '#t)))
     transforms)))


(define (SET-REWRITE-USAGE-TRIGGER theorem proc)
  (let ((transforms (table-entry *rewrite-rules-table* theorem)))
    (walk
     (lambda (transform)
       (if (rewrite-rule? transform)
	   (set (rewrite-rule-trigger transform) proc)))
     transforms)))

(define (REWRITE-USAGE-SORT-CHECK-TRIGGER theorem)
  (rewrite-usage-trigger
   theorem
   (lambda (context reqs persist subst)
     (ignore context persist)
     (return (substitution-preserves-sort-inclusions? subst) reqs))))

