;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald THEOREM)


(lset *NAME-THEOREM-TABLE* (make-table '*name-theorem-table*))

(define (NAME->THEOREM the-name)
  (or (NAME->THEOREM-1 the-name)
      (imps-error "NAME->THEOREM: no theorem named ~A." the-name)))

(define (NAME->THEOREM-1 the-name)
  (table-entry *name-theorem-table* the-name))

(define-integrable RETRIEVE-THEOREM (lambda (fmla) fmla))

(define theorem? formula?)

(lset *THEOREM-INFO-TABLE* (make-table '*theorem-info-table*))

(define (SET-THEOREM-INFO formula
			  home-theory name-list
			  usage-list theory-usage-alist
			  downcased-name)
  (set (table-entry *THEOREM-INFO-TABLE* formula)
       (list home-theory name-list
	     usage-list theory-usage-alist
	     downcased-name))
  (return))

(define (SET-THEOREM-INFO-NTH formula n new-value)
  (let ((entry  (table-entry *THEOREM-INFO-TABLE* formula)))
    (if entry 
	(set (nth entry n) new-value)
	(block
	  (set-theorem-info formula
			   '() '() '() '() '())
	  (set-theorem-info-nth formula n new-value))))
  (return))

(define (COUNT-THEOREMS)
  (let ((count 0))
    (walk-table
     (lambda (key entry)
       (ignore key entry)
       (increment count))
     *THEOREM-INFO-TABLE*)
    count))

(define THEOREM-HOME-THEORY
  (operation
      (lambda (theorem)
	(let ((entry  (table-entry *THEOREM-INFO-TABLE* theorem)))
	  (if entry 
	      (car entry)
	      '#f)))
    ((setter self)
     (lambda (theorem nv)
       (set-theorem-info-nth theorem 0 nv)))))


(define THEOREM-NAME
  (operation
      (lambda (theorem)
	(let ((entry  (table-entry *THEOREM-INFO-TABLE* theorem)))
	  (if entry 
	      (caadr entry)
	      '#f)))
    ((setter self) 
     (lambda (theorem nv)
       (imps-enforce (lambda (nv)
		       (or (false? nv)
			   (symbol? nv)))
		     nv)
       (or (table-entry *THEOREM-INFO-TABLE* theorem)
	   (set-theorem-info theorem '() '() '() '() '()))
       (let ((old (nth (table-entry *THEOREM-INFO-TABLE* theorem) 1)))
	 (or (eq? nv (car old))
	     (false? nv)
	     (block
	       (set (theorem-downcased-name theorem)
		    (if nv
			(string-downcase! (symbol->string nv))
			""))		   
	       (set-theorem-info-nth theorem 1 (cons nv old))
	       (set (table-entry *name-theorem-table* nv) theorem))))))))

(define-integrable THEOREM-FORMULA (lambda (thm) thm))

(define THEOREM-USAGE-LIST
  (operation
      (lambda (theorem)
	(let ((entry  (table-entry *THEOREM-INFO-TABLE* theorem)))
	  (if entry 
	      (caddr entry)
	      '#f)))
    ((setter self) 
     (lambda (theorem nv)
       (set-theorem-info-nth theorem 2 nv)))))

(define THEOREM-THEORY-USAGE-ALIST
  (operation
      (lambda (theorem)
	(let ((entry  (table-entry *THEOREM-INFO-TABLE* theorem)))
	  (if entry 
	      (cadddr entry)
	      '#f)))
    ((setter self) 
     (lambda (theorem nv)
       (set-theorem-info-nth theorem 3 nv)))))

(define THEOREM-DOWNCASED-NAME
  (operation
      (lambda (theorem)
	(let ((entry  (table-entry *THEOREM-INFO-TABLE* theorem)))
	  (if entry 
	      (nth entry 4)
	      '#f)))
    ((setter self)
     (lambda (theorem nv)
       (set-theorem-info-nth theorem 4 nv)))))


(define (BUILD-THEOREM home-theory formula the-name usage-list)
  (enforce (lambda (theory)
	     (or (null? theory)
		 (theory? theory)))
	   home-theory)
  (enforce formula? formula)
;;;
;;;  (enforce closed? formula)
;;;  Changed by WMF Thu Oct 18 10:08:57 EDT 1990
;;;
;;;  !Guttman--  Bill, Why did you remove the requirement that a theorem be a
;;;  closed formula?  I don't get it.
;;;  	Josh, Thu Mar 28 17:56:07 EST 1991
;;;  	

  (enforce (lambda (the-name)
	     (or (null? the-name)
		 (symbol? the-name))) the-name)
  (if (not (null? the-name))
      (let ((old-thm (table-entry *name-theorem-table* the-name)))
	(and old-thm
	     (not (eq? (theorem-formula old-thm) formula))
	     (rename-theorem old-thm the-name))))
  (let ((thm formula)
	(the-name (or the-name (theorem-name formula)))
	(home-theory (or home-theory (theorem-home-theory formula))))
    (let ((usage-list (if the-name
			  (cons 'elementary-macete usage-list)
			  usage-list)))
      (set (theorem-home-theory thm) home-theory)
      (set (theorem-name thm) the-name)
      (set (theorem-usage-list thm)
	   (set-union usage-list (theorem-usage-list thm)))
      (set (theorem-theory-usage-alist thm) '())
      (set (table-entry *name-theorem-table* the-name) thm)
      (maybe-register-imps-obarray-entry the-name 'theorem)
      thm)))

(define (RENAME-THEOREM formula the-name)
  (let ((preferred-name (theorem-name formula)))
    (let ((new-name (concatenate-symbol the-name '$)))
      (format (error-output)
	      "~%;; Warning -- RENAME-THEOREM: renaming theorem formerly called~_~S to ~S.~&"
	      the-name
	      new-name)
      (set (table-entry *name-theorem-table* new-name)
	   formula)
      (if (eq? preferred-name the-name)
	  (set (theorem-name formula) new-name)))))

(define (THEORY-INSTALL-THEOREM theory theorem)
  (let* ((thm-table (theory-theorem-hash-table theory))
	 (expr (universal-matrix (theorem-formula theorem) '()))
	 (constructor (expression-quasi-constructor-or-constructor expr))
	 (lead (expression-lead-constant expr)))
    (set (two-d-table-entry thm-table constructor lead)
	 (add-set-element
		 theorem
		 (two-d-table-entry thm-table constructor lead)))
    (return)))

;;;Just to cut down on the number of actual theorems.

(define (TRIVIAL-THEOREM? formula)
  (or (truth? formula)
      (and (or (universal? formula) (existential? formula))
	   (trivial-theorem? (binding-body formula)))))

  
(define (THEORY-LITERAL-THEOREM? theory theorem)
  (let* ((thm-table (theory-theorem-hash-table theory))
	 (expr (universal-matrix (theorem-formula theorem) '()))
	 (constructor (expression-quasi-constructor-or-constructor expr))
	 (lead (expression-lead-constant expr)))
    (memq? theorem
	   (two-d-table-entry thm-table constructor lead))))

(define (RETRIEVE-HASHED-THEOREMS table constr lead)
  (two-d-table-entry table constr lead))
  
(define (WALK-POSSIBLE-MATCHING-THEOREMS proc theory formula)
  (let* ((expr (universal-matrix formula '()))
	 (constrs (expression-quasi-constructors-and-constructor expr))
	 (lead (expression-lead-constant expr)))
    (walk
     (lambda (constr)
       (walk-theory-theorems-matching-constructor-and-first-lead
	proc theory constr lead))
     constrs)))

(define (WALK-THEORY-THEOREMS-MATCHING-CONSTRUCTOR-AND-FIRST-LEAD
	 proc theory constr lead)
  (walk proc
	(retrieve-hashed-theorems
	 (theory-theorem-hash-table theory)
	 constr
	 lead))
  (if (expression? lead)
      (walk proc
	    (retrieve-hashed-theorems
	     (theory-theorem-hash-table theory)
	     constr
	     'no-lead-constant))))

  
(define (theory-contains-theorem? theory theorem)
  (catch found
    (walk-possible-matching-theorems
     (lambda (th)
       (if (eq? theorem th)
	   (found '#t)))
     theory
     (theorem-formula theorem)))
  '#f)

(define (THEORY-THEOREMS theory)
  (let ((accum '()))
    (walk-two-d-table
     (lambda (k1 k2 formulas)
       (ignore k1 k2)
       (set accum (set-union formulas accum)))
     (theory-theorem-hash-table theory))
     accum))

(define (THEORY-WALK-THEOREMS theory proc)
  (walk-two-d-table
   (lambda (k1 k2 formulas)
     (ignore k1 k2)
     (walk proc formulas))
   (theory-theorem-hash-table theory)))

(define (RESOLVE-THEOREM-NAME formula the-name)
  (ignore formula)
  (format (error-output)
	  "~%;; Warning -- RESOLVE-THEOREM-NAME: renaming ~S to ~S.~&" the-name
	  (concatenate-symbol the-name '$))
  (concatenate-symbol the-name '$))

(define (FORMULA->THEOREM theory formula the-name . usage-list)  
  (build-theorem theory formula the-name usage-list))

(define (THEOREM-INSTANCE? theorem sequent persist)
  (ignore persist)
  (let ((extended-context
	 (context-add-assumption
	  (sequent-context sequent)
	  (universal-closure (theorem-formula theorem)))))
    (sequent-entailed?
     (build-sequent
      extended-context
      (sequent-assertion sequent)))))

;;; (define (THEOREM->SEXP theorem)
;;;   (let ((home-theory-name (theory-name (theorem-home-theory theorem)))
;;; 	(formula (theorem-formula theorem))
;;; 	(the-name (theorem-name theorem))
;;; 	(usage-list (theorem-usage-list theorem)))
;;;     (list
;;;      home-theory-name
;;;      the-name
;;;      (expression->sexp formula)
;;;      usage-list)))

(define (THEOREM->SEXP theorem)
  (let ((home-theory-name (theory-name (theorem-home-theory theorem)))
	(formula (theorem-formula theorem))
	(the-name (theorem-name theorem))
	(usage-list (theorem-usage-list theorem)))
    (list
     home-theory-name
     the-name
     (qp formula)
     usage-list)))

(define (SEXP->THEOREM sexp)
  (destructure (((home-theory-name the-name formula-sexp usage-list) sexp))
    (let ((theory (name->theory home-theory-name)))
      (build-theorem theory
		     (sexp->expression (theory-language theory) formula-sexp)
		     the-name
		     usage-list))))

(define (THEORY-THEOREMS->SEXP theory)
  (map
   theorem->sexp
   (theory-theorems theory)))

(define (REVERSE-FORMULA formula)
  (let* ((body (universal-matrix-respecting-qcs (expression-alpha-root formula) '()))
	 (reversed-body (reverse-formula-body body '())))
    (universal-closure reversed-body)))

(define (REVERSE-FORMULA-BODY body reqs)
  (cond ((quasi-equation? body)
	 (quasi-equality (quasi-equation-rhs body) 
			 (quasi-equation-lhs body)))
	((quasi-constructor?
	  (expression-quasi-constructor-if-enabled-or-constructor body))
	 body)
	((equation? body)
	 (equality (expression-rhs body) 
		   (expression-lhs body)))
	((biconditional? body)
	 (biconditional (expression-rhs body) 
			(expression-lhs body)))
	((implication? body)
	 (let ((reversed-rhs 
		(reverse-formula-body (expression-rhs body)
				      (set-union reqs
						 (ultimate-conjuncts
						  (list (expression-lhs body)))))))
	   (implication (expression-lhs body) reversed-rhs)))
	((and (universal? body)
	      (empty-set? (set-intersection
			   (big-u (set-map free-variables reqs))
			   (newly-bound-variables body))))
	 (let ((reversed-rhs 
		(reverse-formula-body (universal-matrix-respecting-qcs body '())
				      reqs)))
	   (apply forall reversed-rhs (binding-variables body))))
	(else body)))
