/******************************************************************************
  anf_ideal_faclst_delete.c
******************************************************************************/
 
#include "kant.h"
#include "poly_z_faclst.h"
#include "anf.h"

t_void
anf_ideal_faclst_delete WITH_2_ARGS(
	order,		ord,
	t_handle *,	h
)
/*******************************************************************************
 
Description:
 
	Deletes a faclst of ideals.
 
 
Calling sequence: 
	
	anf_ideal_faclst_delete(ord, &lst);
                               
	order		ord    = t_handle of the order 
	t_handle		lst    = factorization list to delete
  
 
History:
 
        91-10-01 JS	first version
 
*******************************************************************************/
{
	block_declarations;

	if (!block_has_other_refs(*h))
	{
		integer_small	i;
		anf_ideal	id;

		for (i=m_poly_z_faclst_len(*h)-1; i>=0; --i )
			anf_ideal_delete(ord, &m_poly_z_faclst_factor(*h, i));
	}

	block_decref_delete(*h);
	*h = 0;
 
	return;
}
