/******************************************************************************
  anf_ideal_lat.c
******************************************************************************/
#include "kant.h"
#include "anf.h"
#include "lattice.h"  


void
anf_ideal_lat WITH_4_ARGS (
	order,		ord,
	anf_ideal,	id,
	lattice*,	lat,
	lat_enum_env*,	env
)

/******************************************************************************
 
Description:	Initialisation of a lattice and an appropriate enumeration
		enviroment. The basis of the new lattice is the real basis
		of the passed ideal.

Calling sequence:

		anf_ideal_lat(ord,id,&lat,&env)

		order		ord	= t_handle of order
		anf_ideal       id	= t_handle of ideal
		lattice		lat	= t_handle of the new lattice
		lat_enum_env	env	= t_handle of the new enumeration env

History:
        
        93-02-02 MJ/KW  chol ring setting
	92-03-20 KW	order_r2(ord) = 0
	92-03-03 KW	written
 
******************************************************************************/
{
	block_declarations;

	t_handle		R,Z;
	integer_big	den;
	matrix		mat1,mat2;
	matrix		mata,matb,matc;
	t_real		tempu,tempv,tempw;

	R = order_reals(ord);
	den = anf_ideal_tran_den(id);

	*lat = lat_create();
	lat_rank(*lat) = order_abs_degree(ord);
/*
*	We need the transformation matrix of the ideal.
*/
 	if(!anf_ideal_is_z(id)) anf_ideal_2_z(ord,id); 

/*
*			order_basis_real(ord) * anf_ideal_trafo_matrix(id)
*	lat_basis =    ----------------------------------------------------
*                                            den
*/
	mat1 = mat_z_to_mat_real(R,anf_ideal_tran(id));	
	mat2 = mat_ring_mult(R,order_basis_real(ord),mat1);

	lat_basis_ring(*lat) = ring_incref(R);
	lat_chol_ring(*lat) = ring_incref(R);

	if (den == 1)
	{
		lat_basis(*lat) = mat_incref(mat2);
		
/*
*		The gram-matrix of lat is over Z if ord is totally real
		(Save Z and beware of R !!).
*/
		if ( (order_r2(ord) == 0)
			&& (ring_type(order_coef_order(ord)) == RING_Z)
			&& (order_mult_table_known(ord)) )
		{
			Z = order_coef_order(ord);

			mata = order_trace_mat(ord);
			matb = mat_ring_trans(Z,anf_ideal_tran(id));
			matc = mat_ring_mult(Z,mata,anf_ideal_tran(id));
			lat_gram(*lat) = mat_ring_mult(Z,matb,matc);

			lat_gram_ring(*lat) = ring_incref(Z);

			mat_delref(Z,&mata);
			mat_delref(Z,&matb);
			mat_delref(Z,&matc);
		}
	}
	else
	{
		tempu = conv_int_to_real(R,anf_ideal_tran_den(id));
		tempv = ring_one(R);
		tempw = real_divide(R,tempv,tempu);

		lat_basis(*lat) = mat_ring_scalar_left_mult(R,tempw,mat2);

		real_delete(&tempu);
		real_delete(&tempv);
		real_delete(&tempw);
	}
	mat_delref(R,&mat1);
	mat_delref(R,&mat2);

	*env = lat_enum_create(*lat);
}
