/******************************************************************************
  lat_elt_move.c
******************************************************************************/
#include "kant.h"
#include "lattice.h"
#include "vector.h"

lat_elt
lat_elt_move WITH_3_ARGS (
	lattice,	lat,
	lat_elt,	elt,
	matrix,		trans
)
/******************************************************************************
 
Description:	Calculates trans * elt.
 
Calling sequence:
 
	eltr = lat_elt_move(lat,elt,trans)
	
	lat_elt		eltr	= t_handle of lattice element
	lattice		lat	= t_handle of lattice
	lat_elt		elt	= t_handle of lattice element
	matrix		trans	= t_handle of integer matrix
 
History:
 
	92-03-05 KW    written
 
******************************************************************************/
{
	block_declarations;

	t_handle		Z;
	integer_small	i;
	lat_elt		r;
	vector		v,w;

	Z = m_z_str_incref(structure_z);

/*
*	simple linear algebra
*/
	v = vec_new(lat_rank(lat));
	for(i=1;i<=lat_rank(lat);i++)
	{
		vec_entry(v,i) = integer_incref(lat_elt_coef(elt,i));
	}

	w = mat_vector_col_mult(Z,trans,v);

	lat_elt_alloc(r,lat_rank(lat));
	for(i=1;i<=lat_rank(lat);i++)
	{
		lat_elt_coef(r,i) = integer_incref(vec_entry(w,i));
	}

	vec_delete(Z,&v);
	vec_delete(Z,&w);
	ring_delete(&Z);

	return (r);
}
