/*******************************************************************************
  mat_z_maple_out.c
********************************************************************************/

         
#include <stdio.h>             
#include "kant.h"
#include "anf.h"
#include "mat.h"
#include "mat.e"                         



void
mat_z_maple_out WITH_2_ARGS (t_handle   ,    Z  ,
                             matrix   ,    mat )
/*******************************************************************************

Description:               
   
   Output of an integer - matrix in stdout in MAPLE - format. The output can
   be directly used in MAPLE.       


Calling sequence:            
  
               t_handle            Z     : a t_handle to a ring_structure of ZZ.
               matrix            mat   : a standard Cayley-matrix. Output.
                                                                          

     mat_z_maple_out (Z,mat);

                                                                     
History:  
                                                               
       MD 92-01-20         : first version                
  
********************************************************************************/
{                              
     block_declarations;         

     integer_small    i,k,l,n,m;

       
  if (ring_type (Z) == RING_Z)                                    
  {
    n = mat_row (mat);
    m = mat_col (mat);

    printf (" a := array (1..%d,1..%d,[",n,m);
    for (k=1;k<=m;k++)
      for (i=1;i<=n;i++)
      {
       printf ("(%d,%d) = ",k,i);
       integer_write (mat_elt (mat,k,i));
       if ((i== n) && (k==m)) 
         printf ("]);\n");
       else  
         printf (",");
      }
  }
}                                      



