/******************************************************************************
  order_dump.c                                                           
******************************************************************************/

#include "kant.h"
 
#define cnt(h) block_ref_count(h)
#define prnt   for(i=callcnt;i;printf("     "),i--); printf
 
void
order_dump WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
       Prints out order information, especially the handles and
       reference counts of the elements in the structure. If a quotient
       field is given also anf_dump is called.
 
 
Calling sequence:
 
	order_dump(ord);
 
      	order       ord   = t_handle of order to dump
      
 
History:
 
	92-06-12 JS    subfield orders
	92-03-16 JS    add'l features
	92-03-12 JS    first version
 
*******************************************************************************/
{
	
	order		ordcoef, ordact, subord;
        anf             field;
	t_poly       pol;
        matrix          trans;
        anf_elt         alpha;
        int             i, count;
 
        static int      callcnt= -1;

        callcnt++;    
      
        prnt("Start order_dump of %d %d\n", ord, cnt(ord));
 
        if (ring_type(ord) == RING_Z) 
	{
		prnt("This is Z.\n");
                callcnt--;
		return; 
	}
        if(field=order_anf(ord))
        {
                if(callcnt) 
                {
	                prnt("Quotient field: %d %d\n", field, cnt(field));
                }
                else
                {
	                prnt("Quotient field: \n");
                        anf_dump(field);
                }
        }
        prnt("Signature: %d/%d %d %d %d\n",
                                order_abs_degree(ord),
                                order_rel_degree(ord),
                                order_r1(ord),
                                order_r2(ord),
                                order_r(ord));
	prnt("Coefficient order");
        ordcoef = order_coef_order(ord);
        if (ring_type(ordcoef) == RING_Z)
        {
                printf(" is Z.\n");
        }
        else
        {
                printf(":\n");
	        order_dump(ordcoef);
        }
        if(order_basis_is_power(ord))
        {  
               pol = m_poly_poly_to_handle(order_poly(ord));
               prnt("Power basis, polynomial: %d %d\n", pol, cnt(pol));
               if (ring_type(ordcoef) == RING_Z)
               {
                        prnt(" = "); 
			poly_z_write(structure_pring_z, order_poly(ord));
                        prnt("\n");
                }
        }
        else if(order_basis_is_rel(ord))
        {             
                trans = order_tran(ord);
                prnt("Basis via Trafo matrix: %d %d\n",trans, cnt(trans));
		prnt("Suborder:\n");
                order_dump(order_suborder(ord));
        }
          
 
        if (order_disc_known(ord))
        {
                prnt("Discriminant: ");
                integer_write(order_disc(ord));
                printf("\n");
        }
         
        if (order_is_maximal(ord)) 
	{       
		prnt("Order is maximal order.\n"); 
        }
        if (count = order_units_count(ord))
        {
                prnt("Number of units: %d, ", count);
                for (i=1; i<=count; ++i) 
		{       
                        alpha = anf_elt_big_to_handle(order_unit(ord, i)); 
			printf("  %d %d  ", alpha, cnt(alpha));
		}
                prnt("\n");
        }
        if(order_units_are_fund(ord)) 
        {
		prnt("The units are fundamental units.\n");
        }
 
        if (count = order_subfield_order_count(ord))
        {
                prnt("There are %d subfield orders:\n");
                for (i=1; i<=count; ++i)
                        order_dump(order_subfield_order(ord, i));
        }

        callcnt--;

        return;
 
}
