#include "kant.h"

/*
 
This file contains:
 
order_prime_factorize         (generic)
order_prime_factorize_power
order_prime_factorize_trans
order_prime_factorize_general 
order_prime_factorize_co      (general case, see Diplomarbeit JS)
   -> anf_ideal_divide_out
order_prime_factorize_md      (dto, alternative)
 
*/
 
 

t_handle
order_prime_factorize WITH_2_ARGS(
	order,		ord,
	integer_big,	p
)
/*******************************************************************************
    
Description:
 
	Factorizes the principal ideal of p (which is a prime) into a power 
	product of prime ideals (generic routine).
 
History:
 
        91-10-01 JS	first version
 
*******************************************************************************/
{
	block_declarations;         
	
	t_handle		id_facs;
	t_handle		order_prime_factorize_power();
	t_handle		order_prime_factorize_trans();
	t_handle		order_prime_factorize_general();

 
	if (!integer_is_single(p))
	error_internal("Berlekamp etc. not yet implemented for long p.");
 
	order_must_be_over_z(ord);
 
 
	if (order_basis_is_power(ord))
	{
		id_facs = order_prime_factorize_power(ord, p);
	}
	else if (order_basis_is_rel(ord))
	{
		id_facs = order_prime_factorize_trans(ord, p);
	}
	else
	{	
		id_facs = order_prime_factorize_general(ord, p);
	}
 	
	if (anf_print_level > 2)
	{
		printf("Factorization of %d: \n", p);
		anf_ideal_faclst_write(ord, id_facs);
	}
	
	return id_facs;
}
                                      
 
  
 
 

t_handle
order_prime_factorize_power WITH_2_ARGS(
	order,		ord,
	integer_big,	p
)
/*******************************************************************************
 
Description:
 
	Factorizes the principal ideal of p (which is a prime) into a
	power product of prime ideals.
 
	The order must be equation order over Z.
 
	At the moment the Header file for polynomial faclists is also used for the
	faclist of ideals. This should be abolished in future.
  

History:
 
        92-05-12 JS	... there was an anf_elt_incref too many!
        92-03-19 JS	minimum, degree 
        91-10-01 JS	first version
 
*******************************************************************************/
{
	block_declarations;         
 
	integer_small	facs, i, power, deg;
	t_poly	mpoly, pol;
	t_handle		poly_facs, id_facs, polh;
	anf_ideal	id, idsq;
	anf_elt		alpha, temp;

              
        deg = order_rel_degree(ord);
 
/*
    factorization of the minimal polynomial over Zp 
*/                            
	mpoly = modpoly_hom(0, p, order_poly(ord));
	poly_facs = poly_u_zm_fact(0, p, mpoly);
 
	facs = m_poly_z_faclst_len(poly_facs);
 
/*
    Our ideal factor list
*/
	id_facs = m_poly_z_faclst_alloc(facs);
	m_poly_z_faclst_len_put(id_facs, facs);
 
/*
    constructing two-element presentations for the prime ideals 
*/
 
/*
    first the trivial case (prime is inert)
*/
	if (facs==1 && m_poly_z_faclst_power(poly_facs, 0) == 1)
	{
		id 				= anf_ideal_alloc();
		anf_ideal_gen1(id)  		= integer_incref(p);
		anf_ideal_gen2(id)  		= integer_incref(p);
		anf_ideal_gen_g(id)		= integer_incref(p);
                anf_ideal_min(id)   		= integer_incref(p);
                anf_ideal_degree(id)		= deg;
		m_poly_z_faclst_factor(id_facs, 0) = id;
	    	m_poly_z_faclst_power(id_facs, 0) 	= 1;
	}
 
	else
 
	{
		for (i=0; i<facs; ++i)
 
		{
			power = m_poly_z_faclst_power(poly_facs, i);
		    	m_poly_z_faclst_power(id_facs, i) = power;
	 
		    	id = anf_ideal_alloc();
	 
		    	anf_ideal_gen1(id) = integer_incref(p);
/*
    Now we construct a normal presentation. If the ramification index
    (= the exponent) is larger than 1 we already have what we want.
    Unfortunately this only happens to few primes (those which divide
    the order discriminant).
    For the others we have to check whether alpha lies in the square of
    the ideal. If not, we are done, in the other case we have to add p
    to alpha.
*/              
                        pol   		    = m_poly_z_faclst_factor(poly_facs, i);
			polh                = m_poly_poly_to_handle(pol);
		    	anf_ideal_gen_g(id) = integer_incref(p);
		    	alpha 	            = poly_to_anf_elt(ord, pol);
		    	anf_ideal_gen2(id)  = alpha;
 
	    		if (power == 1)
		    	{	
				idsq = anf_ideal_2_mult(ord, id, id);
				if (anf_elt_in_ideal(ord, alpha, idsq))
				{
					anf_ideal_gen2(id) = 
					anf_add(ord, alpha, p);
					anf_elt_delete(ord, &alpha);
				}
				anf_ideal_delete(ord, &idsq);
			} 
 
                        anf_ideal_min(id) 	= integer_incref(p);
                        anf_ideal_degree(id) 	= m_poly_expt(polh, m_poly_nterms(polh)-1);
	 
			m_poly_z_faclst_factor(id_facs, i) = id;
		}     
	}
 
	m_poly_z_delref(structure_pring_z, mpoly);
	poly_z_faclst_delete(structure_pring_z, &poly_facs);	
	
	return id_facs;
}
 
 
 
 
 
t_handle
order_prime_factorize_trans WITH_2_ARGS(
	order,		ord,
	integer_big,	p
)
/*******************************************************************************
      
Factorizes the principal ideal of p (which is a prime) into a
power product of prime ideals.
 
The order must be given via a transformation matrix referring to a suborder.
 
At the moment the Header file for polynomial faclists is also used for the
faclist of ideals. This should be abolished in future.
 
 
History:
 
        92-09-10 JS	Index divisors
        91-10-01 JS	first version
 
*******************************************************************************/
{
	block_declarations;         
 
	order		subord;
	integer_small	facs, i;
	t_handle		id_facs;
	anf_ideal	id;
	anf_elt		temp;
	t_handle		order_prime_factorize_general();

 
	subord = order_suborder(ord);
 
/*
    index divisors are dealt with in the general function
*/
                             
	if (is_index_divisor(ord, p))
                return order_prime_factorize_general(ord, p);
 
/*
   We factorize p in the suborder and move the ideals up.
   I think they still will be in normal presentation.
*/
	id_facs = order_prime_factorize(subord, p);
 
	facs = m_poly_z_faclst_len(id_facs);
 
	for (i=0; i<facs; ++i)
	{
		id 			= m_poly_z_faclst_factor(id_facs, i);
		temp 			= anf_ideal_gen2(id);
		anf_ideal_gen2(id) 	= anf_elt_move(subord, temp, ord);
 
		anf_elt_delete(subord, &temp);
	}
	
 
	return id_facs;
}


t_handle
order_prime_factorize_general WITH_2_ARGS(
	order,		ord,
	integer_big,	p
)
/*******************************************************************************
      
Factorizes the principal ideal of p (which is a prime) into a
power product of prime ideals.
 
No conditions are needed. This function branches into general
prime ideal computation functions, currently into 
order_prime_factorize_co, in future into order_prime_factorize_ore.
In this case order_fac_basis_create should be adjusted since the
creation of prime ideals will be much more efficient.
 
History:
 
        92-09-16 JS	first version
 
*******************************************************************************/
{
	t_handle		order_prime_factorize_co();
	t_handle		order_prime_factorize_md();
 
	return order_prime_factorize_co(ord, p);
}


 
faclst
order_prime_factorize_co WITH_2_ARGS(
	order,		ord,
	integer_big,	p
)
/*******************************************************************************
 
Description:

	Calculates the prime ideal decomposition of p*ord (ord must be
	a dedekind ring). The resulting prime ideals are stored in an
	ideal factor list (as "m_poly_z_faclst_factor's"; their exponents
	are the "m_poly_z_faclst_power's"). Further the degree is set.
	This method also works for index divisors.
	Maybe it is not very fast.
  
Calling sequence:
 
        anf_ideal_decompose(ord, id);
 
        order   	ord:        order
        integer_big       p:	    prime number
 
History:

	92-10-01 CO	correction of line 359 (MEM_NH)
	92-09-02 CO	anf_ideal_is_in_faclst
	92-07-17 CO     first version

*******************************************************************************/
{       
	block_declarations;
 
	faclst		ideal_faclst, prime_ideal_faclst;
	integer_big	norm, den;
	integer_small   n, k, i;
	anf_ideal	actual_id, id1, id2, dum;
 
	order_must_be_over_z(ord);


	prime_ideal_faclst = MEM_NH;
	ideal_faclst = MEM_NH;

	id1 = anf_elt_to_princ_ideal( ord, p );
/*	anf_ideal_2_assure( ord, id1 );*/
	n = order_abs_degree( ord );
	anf_ideal_degree( id1 ) = n;
	anf_ideal_add_to_faclst( ord, &ideal_faclst, id1, 1 );
	anf_ideal_delete( ord, &id1 );


/******* We try to find all prime ideals:              *******/
/******* We start with an ideal factor list containing *******/
/******* only the principal ideal p * o_F.             *******/
/******* In the loop we take the last ideal out of the *******/
/******* list and test if it is prime.                 *******/


/*	while( m_poly_z_faclst_len( ideal_faclst ) > 0 )  */
	while( ideal_faclst != MEM_NH )
	{
	    actual_id = anf_ideal_incref( m_poly_z_faclst_factor
		( ideal_faclst, m_poly_z_faclst_len( ideal_faclst ) - 1 ));
	    anf_ideal_take_out_of_faclst( &ideal_faclst, ord,
		m_poly_z_faclst_len( ideal_faclst ) - 1 );

	    if( anf_print_level > 5 )
	    {
		printf("\n actual ideal =");
		anf_ideal_2_write( ord, actual_id);puts("");
		anf_ideal_z_write( ord, actual_id);puts("");
	    }

/*** If the actual ideal is found to be prime we add it	***/
/*** to a prime ideal list.		       		***/

	    if( anf_ideal_is_prime_ideal( ord, actual_id, &id1 ))
	    {
		if( -1 == anf_ideal_is_in_faclst( ord,
					actual_id, prime_ideal_faclst ) )
		{
		    k = anf_ideal_ram_index_p( ord, p, actual_id, &n );
		    anf_ideal_add_to_faclst( ord, &prime_ideal_faclst, actual_id, k);
		}
	    }

/*** If the actual ideal is NOT prime, the prime ideal 	***/
/*** test will return a different ideal dividing our 	***/
/*** actual ideal. We add this new ideal to the ideal   ***/
/*** list we are testing. Further we compute a remainder***/
/*** ideal (i.e. we divide the actual ideal by the new  ***/
/*** ideal as often as possible). If the norm of this   ***/
/*** remainder ideal is <> 1 we also add it to the 	***/
/*** ideal faclst.					***/ 

	    else
	    {
		anf_ideal_2_assure( ord, id1 );
		anf_ideal_norm( ord, id1, &norm, &den );
		k = integer_prime_val( norm, p );
		anf_ideal_degree( id1 ) = k;
		if( -1 == anf_ideal_is_in_faclst( ord, id1, ideal_faclst ) )
		    anf_ideal_add_to_faclst( ord, &ideal_faclst, id1, 1 );
/*  MJ & CO line changed to following line 
		id2 = anf_ideal_divide_out( ord, actual_id, id1 ); 
*/
		id2 = anf_ideal_divide_out_ideal_same_p( ord, actual_id, id1 );

		if( anf_ideal_degree( id2 ) > 0 )
		{
/*		    anf_ideal_2_assure( ord, id2 );*/
		    if( -1 == anf_ideal_is_in_faclst( ord, id2, ideal_faclst ) )
			anf_ideal_add_to_faclst( ord, &ideal_faclst, id2, 1 );
		}

		integer_delref( norm );
		integer_delref( den );
		anf_ideal_delete( ord, &id1 );
		anf_ideal_delete( ord, &id2 );
	    }
	    anf_ideal_delete( ord, &actual_id );
	}

	return( prime_ideal_faclst );
}




t_handle
order_prime_factorize_md WITH_2_ARGS (order          , ord ,
                                      integer_big    ,  p    )
/*******************************************************************************
 
Description:
   
      Factores a given rational prime into prime ideals in the maximal order
      of an alg. number field. The used method is very slow, so this function
      should only be used for index - divisors. 
      This function is called by order_prime_factorize.

Calling sequence:
                                                           
      order            ord       :  The order ord has to be the ring of 
                                    integers of a number field.
      integer_big      p         :  The rational prime that has to be factored.
                      
      t_handle           fac       :  The factorization of (p).

         
         fac = order_prime_factorize_remainder (ord,p);
                                                           

History:                                 
           

       10.09.92  MD written
   

********************************************************************************/
{
              block_declarations;

              anf_ideal        ideal,a,b;

              t_handle           fac;
              dyn_arr_handle   p_ideal_val;

              anf_elt          alpha;  
              integer_big      i_norm,a_norm,den,rem,temp,dummy;
              integer_small    i,m,n,x,e,a_val;
              t_logical          ok,is_prime,new_p_ideal;

  if (anf_print_level >5)
    puts ("START FACTO.");              


  order_must_be_over_z (ord);

  n           = order_abs_degree (ord);
  m           = 0;
  x           = n;
  p_ideal_val = MEM_NH;


  ideal  = anf_ideal_2_create (ord,p,p);
  anf_ideal_2_z (ord,ideal);

  if (anf_print_level >1)
  {
    printf ("We want to fact. the ideal : ");anf_ideal_2_write (ord,ideal);puts("");
  }


  anf_ideal_remainder_init (&alpha);

  while (    (ok = anf_ideal_remainder_next (ord,ideal,&alpha)) 
          && (x > 0)                                           )
  {
    if (!anf_elt_is_zero (ord,alpha))
    {
      if (anf_print_level >5)
      {
        puts ("... next");
        printf ("Testing element alpha = ");anf_elt_write (ord,alpha);puts (""); 
      }


/* There are still more possible ideals, which are divisors of p O(F)  */

/* Create a possible divisor                                           */
/* Some checks have to be done in order to check whether or not        */
/* this ideal is a prime - divisor.                                    */

/* If the norm the present element is not divided by p the ideal a can */
/* not be a divisor.                                                   */
  

      anf_norm (ord,alpha,&a_norm,&den);
      temp = integer_rem (a_norm,p);
      rem  = integer_abs (temp);
 
      integer_delref (temp);

      if (anf_print_level >5)
      {
        cay_print ("With norm : %d\n",a_norm);
        cay_print ("and with remainder : %d\n",rem);
      }

      if (rem == 0) /* This ideal (created by p and alpha)               */
                    /* might be a prime ideal, we  check it              */
      {

        a = anf_ideal_2_create (ord,p,alpha);

        anf_ideal_norm (ord,a,&i_norm,&den);      

        a_val    = integer_prime_val (i_norm,p);

        if (anf_print_level >5)
        {
          printf ("Checking ideal : ");anf_ideal_2_write (ord,a);
          cay_print (" with norm %d  (p-val = %d)\n",i_norm,a_val);
        }

        if (a_val != 1) 
        {
/* We have to do an additional check, since the norm of the ideal      */
/* is NOT prime.                                                       */ 
          is_prime = anf_ideal_is_prime_ideal (ord,a,&b);              

          if (!is_prime)
            anf_ideal_delete (ord,&b);
        } 
        else /* Since norm(a) equals p we have a prime ideal              */
          is_prime = TRUE;



        if (is_prime)
        {
/* Check if ideal a (which is prime) has already been detected as an   */
/* divisor of    p O(F).                                               */

          if (anf_print_level >2)
          {
            printf ("We found a new prime ideal : ");
            anf_ideal_2_write (ord,a);puts ("");
          }

          new_p_ideal = TRUE;
          i = 0;
  
          if (anf_print_level >2)
            puts ("checking the new PI (does it already ex. ?)");

          while (    (i<m)
                  && (new_p_ideal) ) 
          {
            if (dyn_arr_element (p_ideal_val,i) == a_val)
            {
               b = m_poly_z_faclst_factor (fac,i);
             
               anf_ideal_tran_assure_hnf_upper (ord,b);
               if (anf_print_level > 6)
               {
                 printf("Testing : ");anf_elt_write (ord,alpha);
                 printf(" in ideal : ");anf_ideal_2_write (ord,b);
                 puts ("");
                 puts ("Z - Basis of ideal ");anf_ideal_z_write (ord,b);
                 puts ("");
               }               

               if (anf_elt_in_ideal (ord,alpha,b))
                 new_p_ideal = FALSE;        
               if (anf_print_level > 6)
               {
                 if (new_p_ideal)
                   puts ("NOT in");
                 else
                   puts ("IN");
               }
            }
            i++;
          }

          if (anf_print_level >2)
            puts ("check done");     

          if (new_p_ideal)
	  {
            if (anf_print_level >2)
              puts ("A NEW DIVISOR");

            m++; /* We have a new prime ideal */

            anf_ideal_tran_assure_hnf_upper (ord,a);
            anf_ideal_min_assure (ord,a); 
        
            anf_ideal_degree (a) = a_val;           
         
            e = anf_ideal_ram_index_p (ord,p,a,&x);

            if (anf_print_level >3)
            {
              cay_print ("Norm of new prime ideal   : %d\n",i_norm);  
              printf ("Degree                    : %d\n",a_val);
              printf ("ramification index        : %d\n",e);
              printf ("product                   : %d\n",e*a_val);

              printf ("new bound                 : %d\n", x);
            }

            if (m == 1) /* Everything is new -- create all data */ 
            {
              p_ideal_val = dyn_arr_alloc (1);
              dyn_arr_element (p_ideal_val,0)   = a_val;
	      dyn_arr_curr_length (p_ideal_val) = 1;

              fac = m_poly_z_faclst_alloc (1); 
              m_poly_z_faclst_power (fac,0)  = e;
              m_poly_z_faclst_factor (fac,0) = anf_ideal_incref (a);
              m_poly_z_faclst_len_put (fac,1);
            }      
            else /* We already created the needed structures */
              {
/* First store the data in p_ideal_val    */
                dyn_arr_assure_space (p_ideal_val,m,1);
                dyn_arr_element (p_ideal_val,m-1)   = a_val;
                dyn_arr_curr_length (p_ideal_val)   = m;

/* Now store the prime ideal a with ram. index e in faclst */
                m_poly_z_faclst_assure_space (fac,m);
                m_poly_z_faclst_power (fac,m-1)  = e;
                m_poly_z_faclst_factor (fac,m-1) = anf_ideal_incref (a);
                m_poly_z_faclst_len_put (fac,m);         
              } 
          }
        } 
        integer_delref (i_norm);
        anf_ideal_delete (ord,&a);
      }
      integer_delref (a_norm);
      integer_delref (rem);
    }
  }

  if (anf_print_level >1)
    puts ("FINISHED BRUTE FORCE SEARCHING");


/* Now delete the dynamic array p_ideal_val                      */
/* Remember : there are just small integers stored in this array */

  if (p_ideal_val != MEM_NH)
    dyn_arr_delete (&p_ideal_val);



  if (m == 0) /* We found no ideal */
  {
    fac = m_poly_z_faclst_alloc (1); 
    m_poly_z_faclst_power (fac,0)  = 1;
    m_poly_z_faclst_factor (fac,0) = anf_ideal_incref (ideal);
    m_poly_z_faclst_len_put (fac,1);
  }      

  anf_elt_delete (ord,&alpha);
  anf_ideal_delete (ord,&ideal);

  if (anf_print_level > 1)
  {
    printf ("Factorization of %d\n",p);
    anf_ideal_faclst_write (ord,fac); 
  }

  return fac;
}
 


