/******************************************************************************
  order_subfield_orders_find_dirty.c                                                           
******************************************************************************/
                  
#include "kant.h" 
 
#define MINEXT  10
 
t_void
order_subfield_orders_find_dirty WITH_1_ARG(
	order,		ord
)
/*******************************************************************************

Description: 
 
 	Tries to find subfield orders of ord. This is done by LLL
        reducing the order basis, then computing all elements of
        T2 value below T2 of the third integral basis element.
        For all these elements is is checked whether they are not
        primitive, if this is the case we found a subfield order.
 
        This routine is very dumb. 
 
        For all these subfield orders an integral basis is computed.
               
 
Calling sequence: 
	
	order_subfield_orders_find_dirty(ord);
                               
	order		ord    = t_handle of the order 

  
History:

 	92-06-05 JS 	first version
  
*******************************************************************************/
{
	block_declarations;
 
        order		ordlll, ordeq, subord, ord1;
        integer_small   deg, i, j, pdeg, ordc, pcnt, ppcnt;
        anf_elt         alpha, omega, alpha2;
        t_handle          R, Z;
        lattice         lat;
        lat_enum_env    env;
        t_poly       pol;
        dyn_arr_handle  ordlst;
        t_logical         found;
                                              
        order_mult_assure(ord);
        order_reals_assure(ord);
                                              
        deg = order_abs_degree(ord);
 
        if (deg < 4 || integer_is_prime_small(deg)) return;
 
        R      = order_reals(ord);
        Z      = m_z_str_incref(structure_z);
        ordlst = dyn_arr_alloc(MINEXT);
        ordc   = dyn_arr_curr_length(ordlst) = 0;
        pcnt   = ppcnt =0;
                          
        ordlll = order_lll_reduce(ord);
        order_lat(ordlll, &lat, &env);
	lat_enum_request_set_next(env);
 
        omega  			= order_basis_elt(ordlll, deg);
	lat_enum_ubound(env) 	= anf_elt_t2(ordlll, omega);
 
        anf_print_level--;
        while (lat_enum(lat, env))
        {        
                alpha = lat_elt_to_anf_elt(lat, lat_enum_act_coefs(env), ordlll);
                pol   = anf_elt_minpoly(ordlll, alpha); pcnt++;
                pdeg  = poly_deg(pol);
                if (pdeg < deg && pdeg > 1)
	        {      
                      if (anf_print_level > 1)
                      {
                          printf("Imprimitive polynomial: ");
                          poly_z_write(structure_pring_z, pol);
                          puts("");
                      }
                      ppcnt++;
                      found  = FALSE;
                      for (i=0; (i<ordc && !found); i++)
                      {
                            ord1  = dyn_arr_element(ordlst, i);
                            if (order_abs_degree(ord1) == pdeg)
                            {
                                 if (anf_elt_embed(ordlll, alpha, pol, ord1, &alpha2))
                                 {
                                       found = TRUE;
				       anf_elt_delete(ord1, &alpha2);
                                 }
                            }  
                      }
                      if (!found)
                      {      
                            ordeq = order_equation_create(Z, pol);

                            dyn_arr_assure_space_fun(ordlst, ++ordc, MINEXT);
                            dyn_arr_curr_length(ordlst)     = ordc;
                            dyn_arr_element(ordlst, ordc-1) = order_maximal(ordeq);
	                    ring_delete(&ordeq);
                      }
                }
	        anf_elt_delete(ordlll, &alpha);
        	m_poly_z_delref(structure_pring_z, pol);
        }
        anf_print_level++;
 
        if (anf_print_level > 0)
	        printf("Numbers: %d    Imprimitive: %d    Fields: %d\n", 
			pcnt, ppcnt, ordc);

        for (i=0; i<ordc; i++)
        {                           
                subord = dyn_arr_element(ordlst, i);
                order_find_hom(subord, ord);
	        if (anf_print_level > 0)
                {
                        puts("Subfield order:"); 
                        order_write(subord);
                }
        }
           
        for (i=0; i<ordc; ++i) ring_delete(&dyn_arr_element(ordlst, i));
        dyn_arr_delete(&ordlst);
        anf_elt_delete(ordlll, &omega);
                 
        ring_delete(&Z);
        ring_delete(&ordlll);
        lat_enum_delete(lat, &env);
        lat_delete(&lat);
 
        return;
}
