/******************************************************************************
  order_torsion_subgroup_calc.c
 
  This file contains:
  order_torsion_subgroup_calc
  order_relation_eval_torsion_subgroup        (KW, taken from reglb.c)
  anf_elt_is_torsion_unit                     (KW, taken from reglb.c)
  real_is_zero                                (KW, taken from reglb.c)
  vec_real_dot_product                        
 
******************************************************************************/

#include "kant.h"        
 
void
order_torsion_subgroup_calc WITH_1_ARG (
	order,		ord
)

/*******************************************************************************
 
Description:	
 
        Computes a generator of the torsion subgroup of ord and its rank.
        Initializes the data inside the order structure appropriately.
        This function collects algebraic integers of T2-norm equal to n.
        These integers must be torsion units. It then performs
        order_relation_eval_torsion_subgroup. 
 
        Attention: The function ".._eval_torsion.." just considers all
        torsion units which are in the Eimer. So the user has to take care
        that he anf_elt_factorized sufficiently many. This is guaranteed
        at the moment by this function (order_torsion_subgroup_calc) and
        by the main program reglb.c
  
  
Calling sequence:  

	order_torsion_subgroup_calc(ord)

	ord	=	t_handle of order
 
  
History:
 
	92-09-01 JS     first version
 
*******************************************************************************/
{
	block_declarations;

	anf_elt		zeta;
	t_handle		R;
        lattice         lat;
        lat_enum_env    env;
        void            order_relation_eval_torsion_subgroup();

/* 
    maybe the calculation has been done already?
*/	
	if (order_torsion_unit(ord)) return;
        
        order_reals_assure(ord);
  
/*
   trivial case: not totally complex
*/
	if (order_r1(ord))
	{
		order_torsion_rank(ord) = 2;
		order_torsion_unit(ord) = -1;
		return;
	}

	R = order_reals(ord);

/*
    we get all numbers of T2 less than n*1.5.
    These must be torsion units.
*/ 
        order_lat(ord, &lat, &env);
	lat_enum_request_set_next(env);
	lat_enum_ubound(env) = 
		conv_double_to_real(R, ((double) order_abs_degree(ord)) * 1.5);
 
        while(lat_enum(lat, env)) 
	{
		zeta = lat_elt_to_anf_elt(lat, lat_enum_act_coefs(env), ord);
		anf_elt_factorize(ord, zeta);
                anf_elt_delete(ord, &zeta);
        } 
 
        lat_enum_delete(lat, &env);
        lat_delete(&lat);
 
        order_relation_eval_torsion_subgroup(ord);
 
        return;
} 
 
