#include "defs.h"
#include "integer.e"
#include "dyn_arr.h"

Logical
dyn_arr_vcomp WITH_2_ARGS(
    dyn_arr_handle,    u,
    dyn_arr_handle,    v
)
/*
** vector comparison
**
** returns /--  0 if u == v
**         |    1 if u <= v in all components
**         |    2 if v <= u in all components
**         \--  3 otherwise
**
** adds zeros to the end of vector (effectively) to compare unequal lengths
*/
{
    t_int    ulen;
    t_int    len;
    t_int    vlen;
    t_int    i;
    Logical          usmall;
    Logical          vsmall;
    Logical          uveq;
    t_int    c;

    ulen = dyn_arr_curr_length( u );
    vlen = dyn_arr_curr_length( v );

    len = ( ulen >= vlen ? ulen : vlen );

    usmall = vsmall = uveq = TRUE;

    for ( i=0; i<len && ( usmall || vsmall || uveq ); ++i )
    {
	c = integer_compare(
	    ( i >= ulen ? 0 : dyn_arr_element( u, i ) ),
	    ( i >= vlen ? 0 : dyn_arr_element( v, i ) ) );

	if ( c == -1 )
	{
	    uveq = FALSE;
	    vsmall = FALSE;
	}
	else if (c == 1)
	{
	    uveq = FALSE;
	    usmall = FALSE;
	}
	/* else if c == 0, nothing */
    }

    if ( uveq )
    {
	return  0;
    }

    if ( usmall )
    {
	return  1;
    }

    if ( vsmall )
    {
	return  2;
    }

    return  3;
}

dyn_arr_handle
dyn_arr_vmin WITH_2_ARGS(
    dyn_arr_handle,    u,
    dyn_arr_handle,    v
)
/*
** vector minimum
**
** returns vector with entries equal to minimum of either u or v entry
** adds zeros to the end of vector (effectively) to compare unequal lengths
*/
{
    block_declarations;

    t_int     ulen;
    t_int     len;
    t_int     vlen;
    t_int     i;
    t_int     c;
    dyn_arr_handle    w;
    integer_big       uelt;
    integer_big       velt;

    ulen = dyn_arr_curr_length( u );
    vlen = dyn_arr_curr_length( v );

    len = ( ulen >= vlen ? ulen : vlen );

    w = dyn_arr_alloc( len );

    for ( i=0; i<len; ++i )
    {
	c = integer_compare(
	    uelt = ( i >= ulen ? 0 : dyn_arr_element( u, i ) ),
	    velt = ( i >= vlen ? 0 : dyn_arr_element( v, i ) ) );

	if ( c == -1 )
	{
	    dyn_arr_element( w, i ) = integer_incref( uelt );
	}
	else /* c >= 0 */
	{
	    dyn_arr_element( w, i ) = integer_incref( velt );
	}
    }

    dyn_arr_curr_length( w ) = len;

    return w;
}

