#include "defs.h" 
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

extern integer_small small_primes[];

Void
i_trial_div_factor WITH_5_ARGS(
    integer_big,      n,
    integer_big,      min,
    integer_big,      max,
    integer_big *,    factor,
    integer_big *,    residue
)
/*
** Try to find a factor of n by trial division ranging from min to
** max.  If a factor is found, it is returned as factor,
** and the residue is returned in residue.  Otherwise, factor is the
** 1, and residue is n.
**
*/
{
/*	trbl_declarations;

	register integer_big	i;
	register integer_big	first;
	register integer_big	last;
	integer_big		q;
	integer_big		r;

	*
	 * John Brownie, August 1989
	 *

	if (integer_compare(min, small_primes[ NSPRIMES-1 ]) <= 0)
	{
		for (i = 0; i < NSPRIMES ; i++)
		{
			if (small_primes[i] >= min)
				break;
		}
		first = i;
		if (integer_compare(max, small_primes[ NSPRIMES-1 ]) < 0)
		{
			for (i = first; i <  NSPRIMES ; i++)
				if (small_primes[i] > max)
					break;
			last = i - 1;
		}
		else
			last =  NSPRIMES-1 ;
		for (i = first; i <= last; i++)
		{
			integer_quot_rem(n, small_primes[i], &q, &r);
				* r is single precision *
			if (r == 0)
			{
				*residue = q;		* transfer *
				*factor = small_primes[i];
				return;
			}
			integer_delref( q );
		}
		min = small_primes[ NSPRIMES-1 ] + 2;
	}
	if (integer_compare(max, min) < 0)
	{
		*factor = 1;
		*residue = integer_incref( n );
		return;
	}

	*
	 * Run out of small primes, with more of the range to do: use
	 * i_medium_prime_divisor to try to find another prime divisor.  If it
	 * cannot, then n is prime (as far as this test goes).
	 */

	i_medium_prime_divisor(n, min, max, factor, residue);
}
