/*  inthdl_negate.c
*/

#include "defs.h"
#include "inthdl.e"
#include "intbig.h"

void
inthdl_negate	WITH_2_ARGS(
    inthdl_handle,	x,
    inthdl_handle,	addinv
)
/*
Return in addinv the additive inverse of the integer in block x; addinv
must be a pre-allocated block which may be the same as x and with room
for at least intbig_curr_size(x) beta-digits.
*/
{
    if ((intbig_sign(addinv) = -intbig_sign(x)) && x != addinv)
    {
	intbig_copy_digits(x, 0, intbig_curr_size(x), addinv, 0);
	intbig_curr_size(addinv) = intbig_curr_size(x);
    }
}
