#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"
#include "zm.e"
#include "integer.e"

t_void mat_ring_create_id_sub P_((t_handle, matrix));

matrix 
mat_ring_create_id WITH_2_ARGS(
	t_handle,		ring,
	integer_small,	dim
)
/* 
 *	Returns t_handle to identity matrix.
 *	"ring" is the coefficient ring.
 *	"dim" is the dimension of the matrix.
 *
 *	It calls mat_ring_create_id_sub
 */
{
	matrix c;

	c = mat_new(dim, dim);
	mat_ring_create_id_sub (ring, c);
	return c;
}

t_void
mat_ring_create_id_sub WITH_2_ARGS(
t_handle,	ring,
matrix,	mat
)
/*
 *	Puts the identity matrix in mat.
 *	Assumes "mat" has been allocated and is UNPACKED.
 *	"ring" is the coefficient ring.
 */
{
	register t_int	j;
	register t_int	diag;
	register t_int	dsquared;
	register t_int	*ptr_mat;
	register t_int	ring_t;
	t_int	zero;
	t_int	one;
	t_int	n;

	if (mat_is_packed(mat))
		error_internal("Given packed matrix in CREATE_ID");

	n = mat_row(mat);
	if (n != mat_col(mat))
		error_internal("Matrix not square in CREATE_ID");

	ring_t = ring_type(ring);
	zero = ring_zero(ring);
	one = ring_one(ring);

	ptr_mat = mat_elt0_ptr(mat);
	dsquared = n * n;
	for (j = 1; j <= dsquared; j++)
		ptr_mat[j] = zero;
	diag = n + 1;
	for (j = 1; j <= dsquared; j += diag)
	{
		ptr_mat[j] = one;
	}

	/*
	 * increment reference counts for the matrix, and decrement one count
	 * each for zero & one.
	 */
	mat_incref_entries(ring, mat);
	ring_elt_delete(ring, &zero);
	ring_elt_delete(ring, &one);

	return;
}
