#include "defs.h"
#include "ring.h"
#include "mat.h"

void
mat_ring_hnf_col_sub WITH_5_ARGS(
	t_handle,		cring,
	matrix,		a,
	matrix *,	hnf,
	matrix *,	trn,
	Logical,	req_trn
)
/*
** Calculates Column Hermite Normal Form of a and transformation matrix.
** Places Column Hermite Normal Form into *hnf.
** Places transformation matrix into *trn if req_trn is TRUE.
*/
{
	switch( ring_type( cring ))
	{
	case RING_Z:
		mat_z_hnf_col_sub( cring, a, hnf, trn, req_trn );
		return;

	default:
		break;
	}

	error_internal( "generic HNF not coded" );
}


matrix
mat_ring_hnf_col WITH_2_ARGS(
	t_handle,		cring,
	matrix,		a
)
/*
** Return the HNF column form of a.
*/
{
	matrix		trn;
	matrix		hnf;

	hnf = trn = 0;
	mat_ring_hnf_col_sub( cring, a, &hnf, &trn, FALSE );
	return hnf;
}

void
mat_ring_hnf_row_sub WITH_5_ARGS(
	t_handle,		cring,
	matrix,		a,
	matrix *,	hnf,
	matrix *,	trn,
	Logical,	req_trn
)
/*
** Calculates Row Hermite Normal Form of a and transformation matrix.
** Places Row Hermite Normal Form into *hnf.
** Places transformation matrix into *trn if req_trn is TRUE.
*/
{
	matrix		atran;
	matrix		invtrn;
	integer_small	temp;

	atran = 0;
	mat_ring_trans_sub( cring, a, &atran );

	if ( *hnf != 0 )
	{
		temp = mat_row( *hnf );
		mat_row( *hnf ) = mat_col( *hnf );
		mat_col( *hnf ) = temp;
	}

	if ( *trn != 0 && req_trn )
	{
		temp = mat_row( *trn );
		mat_row( *trn ) = mat_col( *trn );
		mat_col( *trn ) = temp;
	}

	mat_ring_hnf_col_sub( cring, atran, hnf, trn, req_trn );

	mat_delref( cring, &atran );

	mat_ring_trans_sub( cring, *hnf, hnf );
	if ( req_trn )
	{
		mat_ring_trans_sub( cring, *trn, trn );
	}
}

matrix
mat_ring_hnf_row WITH_2_ARGS(
	t_handle,		cring,
	matrix,		a
)
/*
** Return the HNF row form of a.
*/
{
	matrix		trn;
	matrix		hnf;

	hnf = trn = 0;
	mat_ring_hnf_row_sub( cring, a, &hnf, &trn, FALSE );
	return hnf;
}


matrix
mat_ring_hnf_col_upper WITH_2_ARGS(
	t_handle,		cring,
	matrix,		a
)
/*
** Return the upper HNF column form of a.
*/
{
	matrix		trn;
	matrix		hnf;
	integer_small	i, j, r, rows, half_rows, cols, half_cols;

	rows = mat_row(a);
	cols = mat_col(a);
	r = ( rows > cols ? cols : rows );
	half_rows = rows / 2;
	half_cols = r / 2;
	 
	for (i=1, j=rows; i<=half_rows; ++i, --j)
		mat_ring_row_swap(cring, a, i, j, 1, cols);

	hnf = trn = 0;
	mat_ring_hnf_col_sub( cring, a, &hnf, &trn, FALSE );
 
	for (i=1, j=rows; i<=half_rows; ++i, --j)
		mat_ring_row_swap(cring, hnf, i, j, 1, r);
 
	for (i=1, j=r; i<=half_cols; ++i, --j)
		mat_ring_col_swap(cring, hnf, i, j, 1, rows);
 
	return hnf;
}

