#include "defs.h"
#include "ring.h"
#include "mat.h"

void
mat_ring_negate_sub WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix	*,	result
)
/*
** Assigns *result with -a, where a is a matrix over coefficient ring cring.
*/
{
	Logical respack;
	t_int		m;
	t_int		n;
	matrix	adash;
	matrix	resultdash;
	t_int		i;
	t_int		j;
	t_ring_elt	(*ringnegate)();

	switch( ring_type( cring ) )
	{
	case RING_Z:
		mat_z_negate_sub( cring, a, result );
		return;

	case RING_ZM:
		mat_zm_negate_sub( cring, a, result );
		return;

	default:
		break;
	}

	adash = resultdash = 0;
	ringnegate = ring_negation(cring);
	respack = mat_result_pkd(cring, *result);
	m = mat_row(a);
	n = mat_col(a);

	mat_alloc_result_unpkd(respack, *result, resultdash, m ,n);
	mat_create_unpkd(cring, a, adash, m, n);

	for (i = 1; i <= m*n; i++)
	{
		mat_entry(resultdash, i) = (*ringnegate)(cring, mat_entry(adash, i));
	}
			
	mat_create_result(cring, respack, *result, resultdash);
	mat_free_unpkd(a, adash);
}


matrix 
mat_ring_negate WITH_2_ARGS(
	t_handle,	cring,
	matrix,	a
)
/*
** Returns -a, where a is a matrix over coefficient ring cring.
*/
{
	matrix	result = 0;
	mat_ring_negate_sub(cring, a, &result);
	return result;
}
