#include "defs.h"
#include "poly.h"

/*
 * Assumes that every coefficient has a sensible value. ie some ringelt
 *
 */

static t_poly poly_clean_rec P_((t_poly_ctx,t_poly));


t_poly
poly_clean_crf(context, apoly)
t_poly_ctx	context;
t_poly	apoly;
{
	t_polyp          ap;
	t_poly       temp;
	t_handle	z;

	z = NULL_POLYNOMIAL;

	DENY ( m_poly_const (apoly) );
	ap = m_poly_to_ptr (apoly);

	if ( m_polyp_nterms (ap) == 0 )
	{
		temp = poly_zero_poly_crf(context, apoly);
		poly_elt_delete_crf(context, &apoly);
		return  (temp);
	}
	temp = poly_clean_rec (context, apoly);


	if (temp == z)  
	{
		/* The only time we should get a constant back is when 
		** the whole polynomial is zero.
		** Don't delete temp as we don't incref z in lower fns. 
		*/
		temp = poly_zero_poly_crf (context, apoly);
	}

	poly_elt_delete_crf (context, &apoly);
	return (temp);

} /* poly_clean_crf */

t_poly
poly_clean(pring, apoly)
t_handle	pring;
t_poly	apoly;
/*
*  POLY_CLEAN deletes unnecessary zero coefficients within a
*  polynomial to conform to the rules satisfying clean polynomials.
*  Also deletes empty terms.
*  NOTE : this function is DESTRUCTIVE.
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_clean_crf(&context, apoly);
}


static t_poly
poly_clean_rec(context, apoly)
t_poly_ctx	context;
t_poly	apoly; 
{
	t_polyp          ap;
	t_handle         resh;
	t_polyp		 resp;
	t_handle	 cring;
	t_int		 nterms;
	t_int	  	 atermno;
	t_int  		 restermno;
	t_poly        acoefft;
	t_poly        temp;
	t_handle	 z;
	t_pfh		 elt_incref;
	t_pfl		 elt_is_zero;
#ifdef DEBUG
	t_int		 last_exp;
	t_int		 this_exp;
	last_exp = -1;
#endif /* DEBUG */

	z = NULL_POLYNOMIAL;
	elt_incref = m_poly_ctx_elt_incref(context);
	elt_is_zero = m_poly_ctx_is_zero(context);
	cring = m_poly_ctx_cring(context);

	DENY (m_poly_const(apoly));

	ap = m_poly_to_ptr (apoly);
	nterms = m_polyp_nterms (ap);
	m_poly_create_empty(&resh,m_polyp_princvar(ap),m_polyp_least_pvar(ap),nterms);
	resp = m_poly_hdl_to_ptr(resh);
	if (m_polyp_univariate (ap))
	{
		for (restermno = 0, atermno = 0; atermno < nterms; atermno ++)
		{
			acoefft = m_polyp_coefft (ap, atermno);
			if (!(*elt_is_zero)(cring, acoefft))
			{
				m_polyp_coefft(resp, restermno)=
					(*elt_incref)(cring, acoefft);
#ifdef DEBUG
				this_exp = m_polyp_expt( ap, atermno);
				ASSERT (last_exp < this_exp);
				m_polyp_expt (resp, restermno) = this_exp;
				last_exp = this_exp;
#else
				m_polyp_expt(resp,restermno)=m_polyp_expt(ap,atermno);
#endif
				restermno ++;
			}
		}
		poly_minspace (resh, restermno);
		if (restermno == 0)
		{
			poly_delref_crf (context, m_poly_handle_to_poly(resh));
			return(z);
		}
		return (m_poly_handle_to_poly (resh));
	}

	for (restermno = 0, atermno = 0; atermno < nterms; atermno ++)
	{
		acoefft = m_polyp_coefft (ap, atermno);
		temp = poly_clean_rec (context, acoefft);
		if (temp != z)
		{
			m_polyp_coefft(resp, restermno) = temp;
#ifdef DEBUG
			this_exp = m_polyp_expt( ap, atermno);
			DENY(last_exp >= this_exp);
			m_polyp_expt (resp, restermno) = this_exp;
			last_exp = this_exp;
#else
			m_polyp_expt( resp, restermno)=m_polyp_expt( ap, atermno);
#endif
			restermno ++;
		}
	}
	poly_minspace (resh, restermno);
	if (restermno == 0)
	{
		poly_delref_crf (context, m_poly_handle_to_poly(resh));
		return(z);
	}
	return (m_poly_handle_to_poly (resh));
} /* poly_clean_rec() */
