#include "defs.h"
#include "zm.e"
#include "poly.h"
#include "error.e"

public t_void
poly_u_zm_half_xgcd WITH_6_ARGS (
	t_handle,	pring, 
	integer_big,	pdig, 
	t_poly,	apoly, 
	t_poly,	bpoly, 
	t_poly*,	cpoly, 
	t_poly*,	vpoly
)
{
	block_declarations;
	t_poly	v1, v2, v3;
	t_poly	a1, a2, a3;
	t_poly	q, temp;
	integer_big	aint, ainv;

	if (m_poly_not_univariate (m_poly_poly_to_handle (apoly))
	 || m_poly_not_univariate (m_poly_poly_to_handle (bpoly)))
		error_internal ("polys not univariate in poly_u_zm_half_xgcd\n");

	v1 = poly_z_constant_poly (pring, apoly, 0);
	v2 = poly_z_constant_poly (pring, apoly, 1);
	a1 = m_poly_z_incref (pring, apoly);
	a2 = m_poly_z_incref (pring, bpoly);

	while (! poly_z_is_zero_poly(pring, a2))
	{
		modpoly_quot_rem (pring, pdig, a1, a2, &q, &a3);
		temp = modpoly_mult (pring, pdig, q, v2);
		v3 = modpoly_subtract (pring, pdig, v1, temp);
		m_poly_z_delref (pring, a1);
		a1 = a2;
		a2 = a3;
		m_poly_z_delref (pring, v1);
		v1 = v2;
		v2 = v3;
		m_poly_z_delref (pring, q);
		m_poly_z_delref (pring, temp);
	}
	if (poly_z_is_zero_poly (pring, a1))
	{
		*cpoly = m_poly_z_incref (pring, a1);
		*vpoly = a1;
	}
	else
	{
		aint = poly_z_lbase_coefft (pring, a1);
		ainv = modint_invert (pdig, aint);
		*cpoly = modpoly_integer_mult (pring, pdig, a1, ainv);
		*vpoly = modpoly_integer_mult (pring, pdig, v1, ainv);
		m_poly_z_delref (pring, a1);
		integer_delref (aint);
		integer_delref (aint);
	}
	m_poly_z_delref (pring, a2);
	m_poly_z_delref (pring, v1);
	m_poly_z_delref (pring, v2);
}








public t_void
poly_u_zm_xgcd WITH_7_ARGS(
	t_handle,       pring,
	integer_big,	pdig,
	t_poly,		apoly,
	t_poly,		bpoly,
    t_poly*,		cpoly,
	t_poly*,		upoly,
	t_poly*,		vpoly
)
/*
** poly_u_zm_xgcd : modular univariate polynomial extended greatest
** common divisor.
** apoly and bpoly are univariate polynomials over Zpdig,
** pdig is a prime.
** returns cpoly = gcd(apoly, bpoly ) and upoly and vpoly such that
** apoly * upoly + bpoly * vpoly == cpoly
*/
{
	block_declarations;
	t_poly	temp1, temp2;

	poly_u_zm_half_xgcd (pring, pdig, apoly, bpoly, cpoly, vpoly);
	if (poly_z_is_zero_poly (pring, apoly))
	{
		*upoly = m_poly_z_incref (pring, apoly);
	}
	else
	{
		temp1 = modpoly_mult (pring, pdig, bpoly, *vpoly);
		temp2 = modpoly_subtract (pring, pdig, *cpoly, temp1);
		*upoly = modpoly_div (pring, pdig, temp2, apoly);
		m_poly_z_delref (pring, temp1);
		m_poly_z_delref (pring, temp2);
	}
}

