#include "defs.h"
#include "globals.e"
#include "poly.h"
#include "z.e"

t_poly
poly_z_random_rec(pring, deg, mpvar, lpvar, m)
t_handle	pring;
t_int		deg, mpvar, lpvar;
integer_big	m;
{
	t_int		index, i;
	integer_big	temp;
	t_handle	rph;

	if (mpvar > lpvar)
	{
		temp = z_ranint(structure_z, 1, m);
		return (z_ranint(structure_z,0,1)) ? temp : integer_destructively_negate(temp);
	}
	m_poly_create_empty(&rph, mpvar, lpvar, deg+1);
	index = z_ranint(structure_z, 0, deg);
	
	
	i = 0;
	while (index <= deg)
	{
		m_poly_coefft(rph, i) = poly_z_random_rec(pring, deg, mpvar + 1, lpvar, m);
		m_poly_expt(rph, i) = index;

		/* We know index <= deg so this is a valid call */
		index  = z_ranint(structure_z, index + 1, deg + 1);
		/* If index = deg + 1 then we terminate.  */
		i++;
	}
	m_poly_nterms(rph) = i;
	m_poly_red(rph, i);
	return m_poly_handle_to_poly(rph);
}

t_poly
poly_z_random(pring, deg, m)
t_handle	pring;
t_int		deg;
integer_big	m;
{
	t_int	lpvar, mpvar;

	mpvar = m_poly_first_var(pring);
	lpvar = mpvar + m_poly_nvars(pring) - 1;

	return poly_z_random_rec(pring, deg, mpvar, lpvar, m);
}
