#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"

t_poly
poly_zm_scalar_add (pring, apoly, number)
t_handle    pring;
t_poly   apoly;
t_int       number;
{
    block_declarations;
    t_handle           temp;
    t_handle           resp;
    t_handle           aph;

    number = modint_hom (zm_modulus(m_poly_coeff_ring(pring)), number);
    if ( m_poly_const( apoly ) )
    {
        /* constant polynomial */
        return  modint_add( zm_modulus(m_poly_coeff_ring(pring)), apoly, number );
    }

    /* general case: non_trivial polynomial */

    if ( number == 0 )
        return  m_poly_z_incref (pring, apoly);

    aph = m_poly_poly_to_handle( apoly );
    temp = poly_z_constant_poly (pring, apoly, number);
    resp = poly_z_add (pring, apoly, temp);
    m_poly_z_delref (pring, temp);
    integer_delref (number);
    return resp;
}

