#include "defs.h"
#include "principal_ideal.e"

t_handle
principal_ideal_str_mult(id1, id2)
t_handle	id1, id2;
{

	t_pi_context    context;

        pi_ctx_init(id1, &context);
        return pi_str_mult_ctx(&context, id1, id2);
}

t_handle
principal_ideal_str_scalar_mult(id1, coeff)
t_handle	id1, coeff;
{

	t_pi_context    context;

        pi_ctx_init(id1, &context);
        return pi_str_scalar_mult_ctx(&context, id1, coeff);
}

t_handle 
pi_str_mult_ctx(context, id1, id2)
t_pi_ctx	context;
t_handle	id1, id2;
{
        t_handle        ring;
	t_pfv		elt_delete;
	t_pfh		elt_mult;
	t_pi_elt	res;
	t_int		i;
	t_handle	g, g1, g2;

	g1 = m_pi_generator(id1);
	g2 = m_pi_generator(id2);
	ring = m_pi_ctx_ring(context);
	elt_mult = m_pi_ctx_elt_mult(context);
	elt_delete = m_pi_ctx_elt_delete(context);
	ASSERT(elt_mult);
	ASSERT(elt_delete);


        (*elt_mult)(ring, g1,0, g2,0,&g, &i);
	res = principal_ideal_str_create(ring, g);
	(*elt_delete)(ring, &g);
	return res;
	
}

t_handle
pi_str_scalar_mult_ctx(context, id1, coefft)
t_pi_ctx        context;
t_handle        id1, coefft;
{
        t_handle        ring;
        t_pfv           elt_delete;
        t_pi_elt        res;
        t_handle        g, g1;

	elt_delete = m_pi_ctx_elt_delete(context);
	ASSERT(elt_delete);

	g1 = m_pi_generator(id1);
	g = principal_ideal_elt_scalar_mult(id1, g1, coefft);
	res = principal_ideal_str_create(ring, g);
        (*elt_delete)(ring, &g);
        return res;
}
