#include "defs.h"
#include "integer.e"
#include "q.h"
#include "error.e"

rational
q_make WITH_3_ARGS(
	t_handle,		field,
	integer_big,	a,
	integer_big,	b
)
/*
Returns a rational with numerator a and denominator b.
The reference counts on a and b are incremented.
*/
{
    block_declarations;
    rational		r;

    if (b == 0)
	error_runtime (ERR_DIV_BY_ZERO);

    if (a == 0)
	return 0;

    r = q_new();
    q_numer(r) = integer_incref(a);
    q_denom(r) = integer_incref(b);
    q_simplify(r);

    return r;
}

rational
q_integer_to_q WITH_2_ARGS(
        t_handle,         field,
        integer_big,    i
)
/*
Returns a rational equal to i.
*/
{

    switch (i)
    {
    case 0:
	return 0;
    case 1:
	return q_incref(Q_ONE);
    case -1:
	return q_incref(Q_MINUS_ONE);
    default:
	return q_make(field, i, 1);
    }
}

